/*
 * lsm.h -- global declarations for LSM utilities.
 *
 * Lars Wirzenius
 * "@(#)lsm:lsm.h,v 1.3 1994/11/11 19:14:49 wirzeniu Exp"
 */

#ifndef lsm_h_included
#define lsm_h_included


#include <stdio.h>		/* need size_t, FILE */


/*
 * Maximum number of fields in one entry.
 */
#define MAX_FIELDS      128

/*
 * One entry.  The fields are identified by indexes; all entries have the
 * fields in the same order in the internal representation.  The mapping
 * between fields and indexes is done by lsm_field_to_index.
 *
 * Not all fields need be given; empty fields are set to
 * NULL.  Each field value will have its leading white space removed from
 * the first line (and the first line only), and will end in a newline.
 */
struct lsm_entry {
	char *fields[MAX_FIELDS];
};


/*
 * A database is a number of entries.  This table is resized dynamically.
 */
struct lsm_database {
	struct lsm_entry *entries;
	size_t nentries, nalloc;
};


int lsm_field_to_index(const char *);
const char *lsm_index_to_field(int);
int lsm_read_one_entry(FILE *, long *, struct lsm_entry *);
int lsm_read_database(FILE *, struct lsm_database *);
int lsm_write_one_entry(FILE *, const struct lsm_entry *);
int lsm_write_database(FILE *, struct lsm_database *);
int lsm_check_entry(struct lsm_entry *, const char *);

#endif
