/*
 * lsmcheck.c -- check validity of LSM database
 *
 * Lars Wirzenius
 * "@(#)lsmtool:lsmcheck.c,v 1.2 1994/11/11 19:16:30 wirzeniu Exp"
 */

 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <publib.h>
#include "lsm.h"

static int exit_code = 0;

static void checkit(FILE *, const char *);

int main(int argc, char **argv) {
	int i;
	FILE *f;

	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmtool");

	if (argc < 2)
		checkit(stdin, "stdin");
	else {
		for (i = 1; i < argc; ++i) {
			f = fopen(argv[i], "r");
			if (f == NULL)
				errormsg(0, -1, "couldn't open `%s'\n",
					argv[i]);
			else {
				checkit(f, argv[i]);
				(void) fclose(f);
			}
		}
	}

	return exit_code;
}

static void checkit(FILE *f, const char *name) {
	struct lsm_database db = {0};
	size_t i;

	if (lsm_read_database(f, &db) == -1)
		errormsg(1, 0, "error reading database `%s'", name);
	for (i = 0; i < db.nentries; ++i)
		if (lsm_check_entry(&db.entries[i], name) == -1)
			exit_code = EXIT_FAILURE;
}
