/*
 * lsmsort.c -- sort an LSM database by the title field
 *
 * Lars Wirzenius
 * "@(#)lsmtool:lsmsort.c,v 1.2 1994/11/20 18:18:22 wirzeniu Exp"
 */

 
#include <assert.h>
#include <ctype.h>
#include <stdlib.h>
#include <string.h>
#include <curses.h>
#include <publib.h>
#include "lsm.h"


/* The database and the current location in it */
static struct lsm_database db;


static void sort_database(void);

int main(int argc, char **argv) {
	__set_liberror(__exit_on_error | __complain_on_error);
	set_progname(argv[0], "lsmsort");

	if (lsm_read_database(stdin, &db) == -1)
		errormsg(1, 0, "error reading database");

	sort_database();

	if (lsm_write_database(stdout, &db) == -1)
		errormsg(1, 0, "error writing in database");

	return 0;
}


/* Sort the database.  Try to keep track of the current entry.  */
static int field = -1;
static int entry_cmp(const void *e1, const void *e2) {
	const struct lsm_entry *ee1 = e1;
	const struct lsm_entry *ee2 = e2;
	assert(field >= 0);
	return strcmp(ee1->fields[field], ee2->fields[field]);
}
static void sort_database(void) {
	int f, i;
	struct lsm_entry *e;

	f = lsm_field_to_index("Title");
	field = lsm_field_to_index(" temp ");
	for (i = 0; i < db.nentries; ++i) {
		e = &db.entries[i];
		if (e->fields[f] == NULL)
			e->fields[field] = xstrdup("");
		else
			e->fields[field] = strtrim(xstrdup(e->fields[f]));
	}

	qsort(db.entries, db.nentries, sizeof(*db.entries), entry_cmp);

	for (i = 0; i < db.nentries; ++i) {
		free(db.entries[i].fields[field]);
		db.entries[i].fields[field] = NULL;
	}
}
