/*
 * term.h -- terminal stuff for lsmtool
 *
 * Lars Wirzenius
 * "@(#)lsm:term.h,v 1.1 1994/12/28 13:06:37 wirzeniu Exp"
 */

#ifndef term_h_included
#define term_h_included

#include <limits.h>

enum {
	KEY_DUMMY = UCHAR_MAX,
	KEY_LEFT, KEY_RIGHT, KEY_UP, KEY_DOWN, KEY_NEXT, KEY_PREV,
	MAX_KEY, MIN_KEY = KEY_LEFT, NUM_KEYS = MAX_KEY - MIN_KEY + 1
};


void terminit(void);
void termend(void);
int termwidth(void);
int termheight(void);
int keymatch(const char *, int);
void move(int y, int x);
void clear(void);
void clrtoeol(void);
void delline(void);
void insline(void);
void standout(void);
void standend(void);

#endif
