/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/button.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), November 20 1992 
 * 	added toggle object
 * Steve Cole (SEP) January 14 1993
 *      Added toggle_sync routine.
 * Steve Cole (SEP) May 7 1993
 *	Fixed the name defaulting for toggles.
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Toggle.h>

#include <stdio.h>

#include "object.h" 
#include "tree.h"
#include "builders.h"

typedef struct buttoninfo {
    char* type;
    char* value;
} _binf;

void build_button(root,parent,type)
     entry *root;
     Widget parent;
     char *type;
{
    Objdef *object;
    char* label;
    struct buttoninfo *button_info;
    char defname[12];
    Widget button;
    Arg args[20];
    int narg;
    static int numbutt=1, numtog=1;
    extern void button_callback();
    extern void button_update();
    extern void toggle_sync();
    
    /* create new object */
    object = new_object();

    /* construct default button name */
    if (!strcmp(type,"button"))
      sprintf(defname,"button%d",numbutt++);
    else
      sprintf(defname,"toggle%d",numtog++);
    
    /* find label, name, action in tree */
    object->name = get_value(root,"name",defname);
    label = get_value(root,"label",object->name);
    object->action = parse_actions(object->name,root);
    button_info = (struct buttoninfo*) malloc( sizeof( struct buttoninfo ) );
    /* save type (button, toggle) for use by callback routines */
    button_info->type = strdupl(type);
    /* save value for toggles */
    button_info->value = get_value(root,"value",label);
    if (!strcmp(button_info->type,"toggle")) {
	object->value = strdupl("");
    }else{
	object->value = strdupl(button_info->value);
    }

    narg = 0;
    XtSetArg(args[narg], XtNlabel, label); narg++;

    /* common parameters */
    common_tags(parent,root,args,&narg,SET_ALL);

    if (!strcmp(type,"button")) 
    {
    	button = XtCreateManagedWidget(object->name,commandWidgetClass,
				   parent,args,narg);
    } else {
    	button = XtCreateManagedWidget(object->name,toggleWidgetClass,
				   parent,args,narg);
    }

    object->widgetname = button;
    object->info = button_info;
    object->updater = button_update;
    if (!strcmp(button_info->type,"toggle")) object->sync = toggle_sync;
    
    XtAddCallback( button, XtNcallback, button_callback, (XtPointer) object);
}

/* callback used for buttons */
void
  button_callback(widget, client_data, callData)
Widget widget;
XtPointer client_data, callData;
{
    Objdef *object;
    struct buttoninfo *button_info;
    extern int quitflag;
    Arg arg[1];
    Boolean state;
    
    object = (Objdef *) client_data;
    button_info = (struct buttoninfo *) object->info;

    /* set toggle value if it is on */
    if (!strcmp(button_info->type,"toggle"))
    {
        XtSetArg( arg[0], XtNstate, &state );
        XtGetValues( object->widgetname, arg, ONE );
        if (state == TRUE ) 
    	    object->value = strdupl(button_info->value);
        else
	    object->value = strdupl("");
    }

    if ( perform_actions(object->name,object->action,1) && !quitflag ) 
      quit_xtpanel(0);
}

void button_update(object,value)
Objdef* object;
char* value;
{
    struct buttoninfo *button_info;
    Arg arg[1];
    Boolean state;

    button_info = (struct buttoninfo *) object->info;

    /* set toggle value if it is on */
    if (!strcmp(button_info->type,"toggle"))
    {
        button_info->value = strdupl(value);
        XtSetArg( arg[0], XtNstate, &state );
        XtGetValues( object->widgetname, arg, ONE );
        if (state == TRUE ) 
            object->value = strdupl(button_info->value);
    } else {
        object->value = strdupl(value);
    }
}

/*
 * this routine is called when a toggle's state is changed
 * by the SET action, to ensure that the value is set only
 * if the state is "on".
 */
void toggle_sync(object,tag,value)
Objdef* object;
char* tag;
char* value;
{
    struct buttoninfo *button_info;
    Arg args[20];
    Boolean state;
    int narg;

    button_info = (struct buttoninfo *) object->info;

    narg=0;
    SetTag(object->widgetname,args,&narg,tag,value);
    XtSetValues(object->widgetname,args,narg);

    /* set toggle value if it is on */
    if (!strcmp(button_info->type,"toggle"))
    {
        XtSetArg( args[0], XtNstate, &state );
        XtGetValues( object->widgetname, args, ONE );
	free( object->value );
        if (state == TRUE ) 
            object->value = strdupl(button_info->value);
	else
	    object->value = strdupl("");
    }
}
