/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/main.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), February 23 1993 
 * 1) added allow_resize to toplevel to let xtpanel resize itself.
 * 2) added support for form widget.
 * 3) improved fallback resources.
 * Steve Cole (SEP), February 24 1993 
 *      Added sensitive to list of recognized arguments.
 * Dave Nichols (SEP), April 29 1993
 *      Added return code to quit_xtpanel
 * Steve Cole (SEP), May 9 1993 
 *	Removed bad Scrollbar*orientation entry in fallback
 *      resources. Caused text scrollbars to be unusable when
 *      app-defaults were not found.
 */

#include "patchlevel.h"

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <X11/Xaw/Box.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xmu/Converters.h>

#ifdef _POSIX_SOURCE
#include <unistd.h>
#else
extern int isatty();
#endif

#include "tree.h"
#include "builders.h"

String fallback_resources[] = {
    "*input:                  			True",
    "*Paned*resizable:   			True",
    "*Dialog*Command.label:   			ok",
    "*sliderbox*Command.label:			ok",
    "*Dialog*resizable:       			True",
    "*Dialog*value.translations: #override <Key>Return: return_key()",
    "*Box*allowResize:        			True",
    "*Box*resizable:        			True",
    "*SimpleMenu*HorizontalMargins:         	30",
    "*noborder.borderWidth:          		0",
    "*squeezebox*vSpace:                        0",
    "*squeezebox*hSpace:                        0",
    "*squeezebox*defaultDistance:               0",
    "*Form*top:                      		ChainTop",
    "*Form*bottom:                  		ChainTop",
    "*Form*left:                     		ChainLeft",
    "*Form*right:                    		ChainLeft",
    "*graphbox*Scrollbar.translations:#override\\n\
      Meta<EnterNotify>: StartScroll(Continuous) MoveThumb() NotifyThumb()\\n\
      Meta<LeaveNotify>: NotifyScroll(Proportional) EndScroll()\\n\
      Meta<Motion>: MoveThumb() NotifyThumb()",
    "*togglebox*Toggle.translations:#override\\n\
      Meta<EnterNotify>:                set()\\n\
      Ctrl<EnterNotify>:                unset()",
    NULL,
};

extern void return_key_callback(),dialog_update_callback();
extern void text_update_callback(),graph_update_callback();
extern void field_return_key_callback(),grid_update_callback();
extern void quit_callback();

static XtActionsRec window_actions[] = {
    {"return_key",       return_key_callback},
    {"field_return_key", field_return_key_callback},
    {"update_dialog",    dialog_update_callback},
    {"update_text",      text_update_callback},
    {"update_graph",     graph_update_callback},
    {"update_grid",      grid_update_callback},
    {"quit",      	 quit_callback},
};

enum boxType{ NOBORDER, VBOX, HBOX, VPANE, HPANE, FORM };

int		quitflag=0;

Widget toplevel;
XtAppContext app_con;
char* progname;

int io_err_handler( disp ) Display * disp; { exit( 0 ); }
extern void quit_xtpanel();
extern void parse_args(),add_pixmap_converter();
static void process_tree();
    
int main(argc,argv)
     
     int argc;
     char **argv;
{
    entry *root;
    Arg args[20];
    int narg;
    
    /* set the io error handler */
    XSetIOErrorHandler( io_err_handler );

    /* this allows the xtpanel window to grow if needed */
    narg = 0;
    XtSetArg(args[narg], XtNallowShellResize, TRUE ); narg++;

    toplevel = XtAppInitialize(&app_con, "XTpanel", NULL, ZERO,
			       &argc, argv, fallback_resources,
			       args, narg);
    
    XtAddCallback( toplevel, XtNdestroyCallback, quit_callback, NULL);
    
    XtAppAddActions(app_con, window_actions, XtNumber(window_actions));

/*    add_pixmap_converter();*/
    
    /* make the root entry to the tree, it is called "root" */
    root= new_entry( "root", 4);
    
    /* now go and parse what is left of the command line */
    progname = strdupl( *argv );
    argv++; argc--;
    
    parse_args( argc, argv, root );
    
    /* parse stdin if it pointing at something */
    if( !isatty( fileno(stdin) )  ) parse_file( stdin, root );
    
    /* print tree for debugging */
    /* print_entry( stderr,root,0 );*/
    
    /*now go and do something with the tree we have created */
    process_tree( root,toplevel,NOBORDER );
    
    XtRealizeWidget(toplevel);
    
    /* do the action for all objects with action type string */
    /* so that strings are set to something when they are needed */
    all_actions();
    
    /* make panel just big enough to encompass all items */
    /* pass control to notifier */
    XtAppMainLoop(app_con);

    return 0;
}


/* 
  This routine take the fully parsed object tree and makes the
  appropriate widgets from each object.
  */

/* this routine may be called recursively (if the user defined sub boxes ) */

static void process_tree(  root,parent,btype )
     entry *root;
     Widget parent;
     enum boxType btype;
{
    entry* curr;
    Widget box;
    char *name;
    Arg args[20];
    int narg;
    
    switch (btype) {
      case NOBORDER:
      default:
	/* a vertical box with no border */
	/* used only for boxes made by xtpanel, which have no name */
	narg=0;
	box = XtCreateManagedWidget("noborder",boxWidgetClass,parent,
				    args,narg);
	break;
      case VBOX:
	/* begin a new vertical (tall and thin) box */
	name = get_value(root,"name","vbox");
	narg=0;
	common_tags(parent,root,args,&narg,SET_ALL);
	XtSetArg(args[narg], XtNorientation, XtorientVertical ); narg++;
	box = XtCreateManagedWidget(name,boxWidgetClass,parent,args,narg);
	break;
      case HBOX:
	/* begin a new horizontal box */
	name = get_value(root,"name","hbox");
	narg=0;
	common_tags(parent,root,args,&narg,SET_ALL);
	XtSetArg(args[narg], XtNorientation, XtorientHorizontal ); narg++;
	box = XtCreateManagedWidget(name,boxWidgetClass,parent,args,narg);
	break;
      case VPANE:
	/* begin a new vertically paned widget */
	name = get_value(root,"name","paned");
	narg=0;
	common_tags(parent,root,args,&narg,SET_ALL);
	XtSetArg(args[narg], XtNorientation, XtorientVertical ); narg++;
	box = XtCreateManagedWidget(name,panedWidgetClass,parent,args,narg);
	break;
      case HPANE:
	/* begin a new horizontally paned widget */
	name = get_value(root,"name","paned");
	narg=0;
	common_tags(parent,root,args,&narg,SET_ALL);
	XtSetArg(args[narg], XtNorientation, XtorientHorizontal ); narg++;
	box = XtCreateManagedWidget(name,panedWidgetClass,parent,args,narg);
	break;
      case FORM:
	/* begin a new form widget */
	name = get_value(root,"name","form");
	narg=0;
	common_tags(parent,root,args,&narg,SET_ALL);
	box = XtCreateManagedWidget(name,formWidgetClass,parent,args,narg);
	break;
    }
    
    /* loop over first level of tree */
    for( curr=root->child; curr != (entry*)0; curr=curr->next ){
	
	/* here is the big switch on item type */
	
	if( !strcmp( curr->tag, "box" ) || !strcmp( curr->tag, "vbox")){
	    /* recursively call process_tree, rooted at this entry */
	    process_tree( curr, box, VBOX);
	    
	}else if( !strcmp( curr->tag, "hbox" ) ){
	    /* recursively call process_tree, rooted at this entry */
	    process_tree( curr, box, HBOX);
	    
	}else if( !strcmp( curr->tag, "pane" ) || 
		  !strcmp( curr->tag,"vpane")){
	    process_tree( curr, box, VPANE);
	    
	}else if( !strcmp( curr->tag, "hpane" ) ){
	    process_tree( curr, box, HPANE);
	    
	}else if( !strcmp( curr->tag, "form" ) ){
	    process_tree( curr, box, FORM);
	    
	}else if( !strcmp( curr->tag, "message" ) ){
	    build_message(curr,box);
	    
	}else if( !strcmp( curr->tag, "button" ) ||
		 !strcmp( curr->tag, "toggle" )){
	    build_button(curr,box,curr->tag);
	    
	}else if( !strcmp( curr->tag, "choice" ) ){
	    build_choice(curr,box);
	    
	}else if( !strcmp( curr->tag, "slider" ) ||
		 !strcmp( curr->tag, "scrollbar" )){
	    build_slider(curr,box,curr->tag);

	}else if( !strcmp( curr->tag, "graph" ) ){
	    build_graph(curr,box);
	    
	}else if( !strcmp( curr->tag, "grid" ) ||
		 !strcmp( curr->tag, "togglegrid" )){
	    build_grid(curr,box,curr->tag);
	    
	}else if( !strcmp( curr->tag, "menubutton" ) ){
	    build_menubutton(curr,box);
	    
	}else if( !strcmp( curr->tag, "list" ) ){
	    build_list(curr,box);
	    
	}else if( !strcmp( curr->tag, "dialog" ) ){
	    build_dialog(curr,box);
	    
	}else if( !strcmp( curr->tag, "text" ) || 
	          !strcmp( curr->tag, "field" ) ){
	    build_text(curr,box,curr->tag);
	    	    
	}else if( !strcmp( curr->tag, "var" ) ||
	          !strcmp( curr->tag, "startup" ) ){
	    build_variable(curr,box,curr->tag);
	    
	}else if( !strcmp( curr->tag, "timer" ) ){
	    build_timer(curr,box);
	    
        /* ignore tags specified for top level box */
	}else if( !strcmp( curr->tag, "name" ) ||
		  !strcmp( curr->tag, "foreground" ) ||
		  !strcmp( curr->tag, "background" ) ||
		  !strcmp( curr->tag, "borderColor" ) ||
		  !strcmp( curr->tag, "borderWidth" ) ||
		  !strcmp( curr->tag, "height" ) ||
		  !strcmp( curr->tag, "width" ) ||
		  !strcmp( curr->tag, "orientation" ) ||
		  !strcmp( curr->tag, "bitmap" ) ||
		  !strcmp( curr->tag, "backgroundPixmap" ) ||
		  !strcmp( curr->tag, "backgroundBitmap" ) ||
		  !strcmp( curr->tag, "editType" ) ||
		  !strcmp( curr->tag, "font" ) ||
		  !strcmp( curr->tag, "sensitive" ) ||
		  !strcmp( curr->tag, "fromHoriz" ) ||
		  !strcmp( curr->tag, "fromVert" ) ||
		  !strcmp( curr->tag, "columns" ) ||
		  !strcmp( curr->tag, "position" ) ||
		  !strcmp( curr->tag, "x" ) ||
		  !strcmp( curr->tag, "y" )) {

	}else{
	    fprintf( stderr,"Unrecognised object type %s \n", curr->tag );
	    exit(-1);
	}
	
    }
    
}

/*
 * Function name: quit_xtpanel
 * Description: quits by destroying toplevel widget.
 * Arguments: none
 * Returns: none
 */
extern Widget toplevel;
void quit_callback() { quit_xtpanel( 0 ); }


void quit_xtpanel( ret )
int ret;
{
    XtDestroyWidget((Widget)toplevel);
    exit(ret);
}

void flush_display()
{
    XFlush( XtDisplay( toplevel ) );
}

