/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/string_buf.c
 *
 * Steve Cole, Dave Nichols (SEP), September 29 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 */

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include "string_buf.h"

#ifndef MAX
#define MAX(a,b) ( ((a)>(b)) ? (a):(b) )
#endif

/* String buffer manager 
 * ======================
 * these routines maintain a buffer and handle growing it to the correct size.
 * A buffer starts off at size DEF_LEN.
 */

#define DEF_LEN 2000

static void add_length( buffer, len )
string_buf* buffer;
int len;
{
   int newmax;
   char* newbuf;

   if( buffer->len + len  < buffer->max ) return;

   /* allocate a new buffer */
   if(  buffer->max == 0 ){
      newmax= MAX(DEF_LEN,len);
   }else{ 
      newmax= MAX(((buffer->max)*2),(buffer->len + len ));
   }

   if( (newbuf = (char*)malloc( newmax + 1 ) ) == 0 ){
      fprintf(stderr,
             "action string too long, unable to grow string buffer\n");
      exit(-1);
   }

   /* and copy over the old stuff */
   if( buffer->len > 0 ) 
     strcpy( newbuf, buffer->data ); 
   else
     newbuf[0] = '\0';

   /* free the old buffer and assign the new one */
   if( buffer->data != 0 ) free( buffer->data ); 
   buffer->data = newbuf; buffer->max = newmax; 

}

string_buf* buf_start()
{
   string_buf* buffer;

   buffer = (string_buf*) malloc(sizeof(string_buf));
   buffer->len=0;
   buffer->max=0;
   buffer->data=0;
   
   /* make sure the buffer is some default initial size */
   add_length( buffer, DEF_LEN );
   /* and set it to a null */
   (buffer->data)[0]='\0';

   return buffer;

}

void buf_cat( buffer, str, len )
string_buf* buffer;
char* str;
int len;
{
   /* make sure the buffer is big enough */
   add_length( buffer, len );
   assert( (buffer->len+len)  <= buffer->max );

   strncat( buffer->data, str, len  );
   buffer->len += len;
   buffer->data[buffer->len] = '\0';

   /* check for stupidities */
   assert( strlen( buffer->data) == buffer->len  );
}

/* remove any trailing characters from the string str */
void buf_trim( buffer, str )
 string_buf *buffer;
 char *str;
{
  int pos;

  pos = buffer->len;
   
  while( strchr( str, buffer->data[pos] ) != NULL ){
     pos--;
  }
  buffer->data[pos+1] = '\0';
  buffer->len = pos;
}

/* get back the string , reset the buffer */
char* buf_fetch( buffer ) 
  string_buf* buffer; 
{ 
   char * ret;
   ret = buffer->data;
   buffer->len=0;
   buffer->max=0;
   buffer->data = 0;
   return ret;
}

int buf_len( buffer ) string_buf* buffer; { return buffer->len; }
 
void buf_free(buffer) 
   string_buf* buffer;
{ 
   if( buffer->data != 0 ) free(buffer->data); 
   free(buffer) ; 
}
 
