#ifndef STRBUF_H
#define STRBUF_H

/* these routines manage a growing string buffer
 * Get a fresh instance with buf_start and then add characters to it
 * using buf_cat (passing the instance) and specifying the length.
 *
 * Use buf_trim to trim characters from the end (trims characters in the
 * string you specify bu stops at the first character not in the string.
 *
 * Use buf_fetch to get the character array back from the struct, NOTE
 * this also resets the buffer back to zero.
 *
 * buf_free() frees the buffer and associated memory.
 */

struct _string_buf {
        char* data;
	int len;
        int max;
} ;

typedef struct _string_buf string_buf;

#if ( defined(__STDC__) || defined(FUNCPROTO) ) && !defined(_NO_PROTO)
extern string_buf* buf_start();
extern void buf_cat( string_buf*, char*, int );
extern char* buf_fetch( string_buf* );
extern int buf_len( string_buf* );
extern void buf_free( string_buf* );
extern void buf_trim( string_buf *, char * );

#else
extern string_buf* buf_start();
extern void buf_cat();
extern char* buf_fetch();
extern int buf_len();
extern void buf_free();
extern void buf_trim();
#endif

#endif
