/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/text.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP), February 23 1993
 *      new object "field" - single line text widget.
 * Steve Cole (SEP), May 6 1993
 *      only string actions are performed when leaving a field.
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Text.h>

#include "object.h"
#include "tree.h"
#include "builders.h"

/* translation table used for text object */
char text_trans[] =
  "<Leave>:         update_text()";

/* translation table used for field object */
char field_trans[] =
  "<Leave>:         update_text()\n\
   <Key>Return:     field_return_key()";

void build_text(root,parent,type)
     entry *root;
     Widget parent;
     char *type;
{
    Objdef *object;
    Arg args[20];
    int narg;
    Widget text;
    char defname[8];
    int width,height;
    static int numtext=1, numfield=1;
    extern void text_update();
    
    /* create new object */
    object = new_object();

    /* construct default text widget name */
    if (!strcmp(type,"text"))
       sprintf(defname,"text%d",numtext++);
    else
       sprintf(defname,"field%d",numfield++);
    
    /* find value, name, etc. in tree */
    object->name = get_value(root,"name",defname);
    object->action = parse_actions(object->name,root);
    object->value = get_value(root,"value","");
    if (!strcmp(type,"text"))
      width = (int) atoi(get_value(root,"width","500"));
    else
      width = (int) atoi(get_value(root,"width","100"));
    height = (int) atoi(get_value(root,"height","100"));
    
    narg=0;

    /* scrollbars only if type is text */
    if (!strcmp(type,"text"))
    {
       XtSetArg(args[narg], XtNscrollVertical, XawtextScrollWhenNeeded); 
       narg++;
       XtSetArg(args[narg], XtNscrollHorizontal, XawtextScrollWhenNeeded); 
       narg++;
    }

    /* set height only for text object */
    if (!strcmp(type,"text")) {
	XtSetArg(args[narg], XtNheight, height); narg++;
	}

    /* set width and default text for both types */
    XtSetArg(args[narg], XtNwidth, width); narg++;
    XtSetArg(args[narg], XtNstring, object->value); narg++;

    /* allow field object to resize horizontally, and make it read-write */
    if (!strcmp(type,"field")) {
	XtSetArg(args[narg], XtNresize, XawtextResizeWidth); narg++;
	XtSetArg(args[narg], XtNeditType, XawtextEdit); narg++;
	}

    /* common parameters */
    common_tags(parent,root,args,&narg,~SET_SIZE);

    text = XtCreateManagedWidget(object->name,asciiTextWidgetClass,
               parent,args,narg);
    
    object->widgetname = text;
    object->updater = text_update;

    /* use translations to update value whenever mouse leaves widget */
    if (!strcmp(type,"text"))
      XtAugmentTranslations(text,XtParseTranslationTable(text_trans));
    else
      XtOverrideTranslations(text,XtParseTranslationTable(field_trans));
}

/*
 * this routine gets called whenever we leave
 * a text widget, to be sure its value is up to date
 */
void text_update_callback( w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
    Objdef* object;
    char *value;
    Arg args[20];
    int narg;

    object = find_by_widget(w);
    narg = 0;
    XtSetArg(args[narg], XtNstring, &value); narg++;
    XtGetValues(object->widgetname,args,narg);
    object->value = strdupl(value);
    /* only string actions get performed */
    perform_actions(object->name,object->action,0);
}

/*
 * this routine gets called whenever we press return
 * in a field object
 */
void field_return_key_callback( w, event, params, num_params)
     Widget w;
     XEvent *event;
     String *params;
     Cardinal *num_params;
{
    Objdef *object;
    extern int quitflag;
    char *value;
    Arg args[20];
    int narg;

    object = find_by_widget(w);
    narg = 0;
    XtSetArg(args[narg], XtNstring, &value); narg++;
    XtGetValues(object->widgetname,args,narg);
    object->value = strdupl(value);

    if (perform_actions(object->name,object->action,1) && !quitflag)
      quit_xtpanel(0);
    return;
}

/* this gets called by ASSIGN actions */
void text_update(object,value)
Objdef* object;
char* value;
{
    Arg args[20];
    int narg;
    XawTextPosition pos;

    narg = 0;
    XtSetArg(args[narg], XtNstring, value); narg++;
    XtSetValues(object->widgetname,args,narg);
}
