/*
 * Copyright 1992 the Board of Trustees of the Leland Stanford Junior
 * University. Official permission to use this software is included in
 * the documentation. It authorizes you to use this file for any
 * non-commercial purpose, provided that this copyright notice is not
 * removed and that any modifications made to this file are commented
 * and dated in the style of the example below.
 */

/*
 *
 *  source file:   ./xtpanel/variable.c
 *
 * Steve Cole, Dave Nichols (SEP), August 28 1992
 *      Inserted this sample edit history entry.
 *      Please log any further modifications made to this file:
 * Steve Cole (SEP) April 23 1993
 *      Added actions and new object "startup".
 */

#include <X11/Intrinsic.h>

#include "object.h" 
#include "tree.h"
#include "builders.h"

typedef struct varinfo {
    char* type;
} _binf;

/* a variable has no screen representation it is just an object
 * with a name, a value, and an action.
 * var actions get done whenever the var's value is changed.
 * startup object is same as var except actions get performed
 * only once at startup.
 */
void build_variable(root,parent,type)
     entry *root;
     Widget parent;
     char *type;
{
    Objdef *object;
    char defname[12];
    static int numvar=1;
    static int numstart=1;
    struct varinfo *var_info;
    extern void variable_update();

    /* create new object */
    object = new_object();

    /* construct default variable name */
    if (!strcmp(type,"var"))
       sprintf(defname,"var%d",numvar++);
    else if (!strcmp(type,"startup"))
       sprintf(defname,"startup%d",numstart++);
    
    /* find name, value, actions */
    object->name = get_value(root,"name",defname);
    object->value = get_value(root,"value",object->name);
    object->action = parse_actions(object->name,root);

    /* save type (var, startup) for use by callback routines */
    var_info = (struct varinfo*) malloc( sizeof( struct varinfo ) );
    var_info->type = strdupl(type);
    object->info = var_info;

    object->updater = variable_update;

    /* startup object actions get performed once now */
    if (!strcmp(var_info->type,"startup"))
       perform_actions(object->name,object->action,1);
}

void variable_update(object,value)
Objdef* object;
char* value;
{
    struct varinfo *var_info;
    var_info = (struct varinfo *) object->info;
    object->value = strdupl(value);
    /* var actions get performed whenever the value changes */
    if (!strcmp(var_info->type,"var"))
       perform_actions(object->name,object->action,1);
}
