/* commandline.c -- Braindead prompt
   Copyright (C) 1993, 1994 John Harper <jsh@ukc.ac.uk>

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "jade.h"
#include "jade_protos.h"

#include <string.h>

_PR void commandline_init(void);
_PR void commandline_kill(void);
_PR u_char *last_prompted;	  /* one line history */
u_char *last_prompted;

_PR VALUE cmd_prompt(VALUE prompt, VALUE string);
DEFUN("prompt", cmd_prompt, subr_prompt, (VALUE prompt, VALUE string), V_Subr2, DOC_prompt) /*
::doc:prompt::
prompt PROMPT [STRING]

Displays PROMPT and waits for the user to enter a string, which is
then returned. If STRING is provided it is used as the starting value
of the string.
::end:: */
{
    u_char *str = NULL;
    VALUE res;
    DECLARE1(prompt, STRINGP);
    if(STRINGP(string))
	str = VSTR(string);
    str = sys_prompt(curr_vw, VSTR(prompt), str);
    if(str)
    {
	res = string_dup(str);
	str_free(str);
	return(res);
    }
    return(sym_nil);
}

void
commandline_init(void)
{
    ADD_SUBR(subr_prompt);
}
void
commandline_kill(void)
{
    if(last_prompted)
    {
	str_free(last_prompted);
	last_prompted = NULL;
    }
}
