


REGEXP(3)              C LIBRARY FUNCTIONS              REGEXP(3)



NAME
     regcomp, regexec,  regsub,  regerror  -  regular  expression
     handler

SYNOPSIS
     #include <regexp.h>

     regexp *regcomp(exp)
     char *exp;

     int regexec(prog, string)
     regexp *prog;
     char *string;

     regsub(prog, source, dest)
     regexp *prog;
     char *source;
     char *dest;

     regerror(msg)
     char *msg;

DESCRIPTION
     These functions implement _e_g_r_e_p(1)-style regular expressions
     and supporting facilities.

     _R_e_g_c_o_m_p compiles a regular expression into  a  structure  of
     type  _r_e_g_e_x_p,  and  returns  a pointer to it.  The space has
     been allocated using _m_a_l_l_o_c(3) and may be released by _f_r_e_e.

     _R_e_g_e_x_e_c matches a NUL-terminated _s_t_r_i_n_g against the compiled
     regular  expression in _p_r_o_g.  It returns 1 for success and 0
     for failure, and adjusts the contents of _p_r_o_g's  _s_t_a_r_t_p  and
     _e_n_d_p (see below) accordingly.

     The members of a _r_e_g_e_x_p structure include at least the  fol-
     lowing (not necessarily in order):

          char *startp[NSUBEXP];
          char *endp[NSUBEXP];

     where _N_S_U_B_E_X_P is defined (as 10) in the header file.  Once a
     successful  _r_e_g_e_x_e_c  has  been  done  using the _r_e_g_e_x_p, each
     _s_t_a_r_t_p-_e_n_d_p pair describes one substring within the  _s_t_r_i_n_g,
     with  the _s_t_a_r_t_p pointing to the first character of the sub-
     string and the _e_n_d_p pointing to the first character  follow-
     ing  the  substring.   The 0th substring is the substring of
     _s_t_r_i_n_g that matched the whole regular expression.  The  oth-
     ers  are those substrings that matched parenthesized expres-
     sions within  the  regular  expression,  with  parenthesized
     expressions numbered in left-to-right order of their opening
     parentheses.



Sun Release 4.1        Last change: local                       1






REGEXP(3)              C LIBRARY FUNCTIONS              REGEXP(3)



     _R_e_g_s_u_b copies _s_o_u_r_c_e to _d_e_s_t, making substitutions according
     to  the  most  recent  _r_e_g_e_x_e_c  performed  using _p_r_o_g.  Each
     instance of `&' in _s_o_u_r_c_e is replaced by the substring indi-
     cated  by  _s_t_a_r_t_p[_0]  and  _e_n_d_p[_0].   Each instance of `\_n',
     where _n is a digit, is replaced by the  substring  indicated
     by _s_t_a_r_t_p[_n] and _e_n_d_p[_n].  To get a literal `&' or `\_n' into
     _d_e_s_t, prefix it with `\'; to get a literal `\' preceding `&'
     or `\_n', prefix it with another `\'.

     _R_e_g_e_r_r_o_r is called whenever an error is detected in _r_e_g_c_o_m_p,
     _r_e_g_e_x_e_c,  or _r_e_g_s_u_b.  The default _r_e_g_e_r_r_o_r writes the string
     _m_s_g, with a suitable indicator of origin,  on  the  standard
     error  output and invokes _e_x_i_t(2).  _R_e_g_e_r_r_o_r can be replaced
     by the user if other actions are desirable.

REGULAR EXPRESSION SYNTAX
     A regular expression is zero or more _b_r_a_n_c_h_e_s, separated  by
     `|'.  It matches anything that matches one of the branches.

     A branch is zero or more _p_i_e_c_e_s, concatenated.  It matches a
     match  for  the  first,  followed by a match for the second,
     etc.

     A piece is an _a_t_o_m possibly followed by `*',  `+',  or  `?'.
     An  atom  followed  by  `*'  matches a sequence of 0 or more
     matches of the atom.  An atom  followed  by  `+'  matches  a
     sequence of 1 or more matches of the atom.  An atom followed
     by `?' matches a match of the atom, or the null string.

     An atom is a regular expression in parentheses  (matching  a
     match  for the regular expression), a _r_a_n_g_e (see below), `.'
     (matching any single  character),  `^'  (matching  the  null
     string  at the beginning of the input string), `$' (matching
     the null string at the end of the input string), a `\'  fol-
     lowed  by a single character (matching that character), or a
     single character with no other significance  (matching  that
     character).

     A _r_a_n_g_e is a sequence of characters enclosed  in  `[]'.   It
     normally matches any single character from the sequence.  If
     the sequence begins with `^', it matches any single  charac-
     ter _n_o_t from the rest of the sequence.  If two characters in
     the sequence are separated by `-', this is shorthand for the
     full  list  of  ASCII  characters between them (e.g. `[0-9]'
     matches any decimal digit).  To include a literal `]' in the
     sequence,  make it the first character (following a possible
     `^').  To include a literal `-', make it the first  or  last
     character.

AMBIGUITY
     If a regular expression could match two different  parts  of
     the  input  string,  it  will  match  the  one  which begins



Sun Release 4.1        Last change: local                       2






REGEXP(3)              C LIBRARY FUNCTIONS              REGEXP(3)



     earliest.  If both begin in the same place    but match dif-
     ferent  lengths, or match the same length in different ways,
     life gets messier, as follows.

     In general, the possibilities in a list of branches are con-
     sidered  in  left-to-right order, the possibilities for `*',
     `+', and `?' are considered longest-first, nested constructs
     are  considered from the outermost in, and concatenated con-
     structs are considered leftmost-first.  The match that  will
     be  chosen  is the one that uses the earliest possibility in
     the first choice that has to be made.  If there is more than
     one choice, the next will be made in the same manner (earli-
     est possibility)  subject  to  the  decision  on  the  first
     choice.  And so forth.

     For example, `(ab|a)b*c' could match `abc'  in  one  of  two
     ways.   The first choice is between `ab' and `a'; since `ab'
     is earlier, and does lead to a successful overall match,  it
     is  chosen.   Since  the `b' is already spoken for, the `b*'
     must match its last possibility-the  empty  string-since  it
     must respect the earlier choice.

     In the particular case where no `|'s are present  and  there
     is  only  one  `*',  `+', or `?', the net effect is that the
     longest possible match will be chosen.  So `ab*',  presented
     with  `xabbbby',  will match `abbbb'.  Note that if `ab*' is
     tried against `xabyabbbz', it will  match  `ab'  just  after
     `x', due to the begins-earliest rule.  (In effect, the deci-
     sion on where to start the match is the first choice  to  be
     made,  hence subsequent choices must respect it even if this
     leads them to less-preferred alternatives.)

SEE ALSO
     egrep(1), expr(1)

DIAGNOSTICS
     _R_e_g_c_o_m_p returns NULL for a  failure  (_r_e_g_e_r_r_o_r  permitting),
     where  failures  are syntax errors, exceeding implementation
     limits, or applying `+' or `*' to a possibly-null operand.

HISTORY
     Both code and manual page were written at U of T.  They  are
     intended  to  be  compatible with the Bell V8 _r_e_g_e_x_p(3), but
     are not derived from Bell code.

BUGS
     Empty branches and empty regular expressions are  not  port-
     able to V8.

     The restriction against applying `*' or `+' to  a  possibly-
     null  operand  is  an artifact of the simplistic implementa-
     tion.



Sun Release 4.1        Last change: local                       3






REGEXP(3)              C LIBRARY FUNCTIONS              REGEXP(3)



     Does not support _e_g_r_e_p's newline-separated branches; neither
     does the V8 _r_e_g_e_x_p(3), though.

     Due to emphasis on  compactness  and  simplicity,  it's  not
     strikingly fast.  It does give special attention to handling
     simple cases quickly.

















































Sun Release 4.1        Last change: local                       4



