/* x11_misc.c -- Miscellaneous functions for X11
   Copyright (C) 1993, 1994 John Harper <jsh@ukc.ac.uk>

   This file is part of Jade.

   Jade is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Jade is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Jade; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "jade.h"
#include "jade_protos.h"

#include <string.h>
#include <errno.h>
#include <sys/stat.h>

_PR int write_clip(int, char *, int);
_PR VALUE read_clip(int);
_PR void beep(VW *);

int
write_clip(int buffer, char *str, int len)
{
    int rc = TRUE;
    if((buffer >= 0) && (buffer <= 7))
	XStoreBuffer(x11_display, str, len, buffer);
    else
    {
	cmd_signal(sym_error, list_2(MKSTR("No cut buffer"), make_number(buffer)));
	rc = FALSE;
    }
    return(rc);
}

VALUE
read_clip(int buffer)
{
    if((buffer >= 0) && (buffer <= 7))
    {
	int len;
	u_char *mem = XFetchBuffer(x11_display, &len, buffer);
	if(mem)
	    return(string_dupn(mem, len));
	return(NULL);
    }
    cmd_signal(sym_error, list_2(MKSTR("Not cut-buffer"), make_number(buffer)));
    return(NULL);
}

void
beep(VW *vw)
{
    XBell(x11_display, 0);
}
