#!/usr/local/bin/perl
#  yearend.pl - export all uncleared transactions to "uncleared.cbb"
#               Then DELETE these transactions from the original file!
#
#  warning:  This program is rather slow ... but hey, you only have
#            to run it occasionally and it gives the impression that
#            it is really working hard. :)
#
#  Written by Curtis Olson.  Started February 10, 1995.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: yearend.pl,v 1.1 1995/02/23 04:54:24 curt Exp $
# (Log is kept at end of this file)


# NOTE: the desired account should already be opened.


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "categories.pl";
require "engine.pl";

($#ARGV >= 0) || 
    die "Usage: yearend.pl account output-file";

print "This program will MOVE all uncleared transactions from the\n";
print "specified account to the specified export file.  The uncleared\n";
print "transactions WILL BE DELETED from the specified account.\n";
print "You are strongly encouraged to make BACKUPS of all your data\n";
print "before attempting to do this.\n\n";
print "Do you wish to continue?  (yes/no) ";

$response = <STDIN>;

if ( $response =~ m/yes/i ) {
    print "Ok, continuing:\n\n";
} else {
    die "Bailing out ... nothing was done to your data.\n";
}

$account = shift(@ARGV);
(&load_trans($account) eq "ok") || die "Cannot open account:  $account";

$outfile = shift(@ARGV);
open(OUTPUT, ">$outfile");

$result = &first_trans();
while ( $result ne "none" ) {
    ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
     $total) = split(/:/, $result);

    if ( $cleared ne "x" ) {
	print (OUTPUT "$TRANS{$key}\n");
	print ".";
	&delete_trans($key);
	if ( defined($lastkey) ) {
	    &find_trans($lastkey);
	}
    } else {
	$lastkey = $key;
    }

    $result = &next_trans();
}

close(OUTPUT);

print "\n";

# ----------------------------------------------------------------------------
# $Log: yearend.pl,v $
% Revision 1.1  1995/02/23  04:54:24  curt
% Initial add to repository
%
