#!/usr/local/bin/perl
#  reports.pl - code for various reports
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: reports.pl,v 1.7 1995/01/23 03:23:17 curt Exp $
# (Log is kept at end of this file)


# NOTE: the desired account should already be opened.


# specify the installed location of the necessary pieces.
$cbb_incl_dir = "..";
unshift(@INC, $cbb_incl_dir);

require "categories.pl";
require "engine.pl";


sub rep_txn_list {
    local($fromdate, $todate, $tofile) = split(/ /, @_[0]);
    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, 
	  $cleared, $total);

    # print "'$fromdate' '$todate'\n";

    if ( $fromdate eq "all" ) {
	$fromdate = "";
    }

    if ( $todate eq "all" ) {
	$todate = "";
    }

    $result = &first_trans();
    while ( $result ne "none" ) {
	($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	 $total) = split(/:/, $result);

	if ( (($fromdate == 0) || ($fromdate <= $date)) && 
	    (($todate == 0) || ($todate >= $date)) ) {
	    &format_list($result);
	}

	$result = &next_trans();
    }

    return "none";
}


sub format_list {
    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	  $total) = split(/:/, $result);
    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);

    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 15);
    $cutcom = substr($com, 0, 15);
    $nicecat = substr($cat, 0, 9);
    if ( substr($cat, 0, 1) eq "|" ) {
	$nicecat = "-Splits-";
    }

    printf("%5s  %-8s  %-15s  %9.2f  %9.2f  %-1s  %9.2f\n",
	  $check, $nicedate, $cutdesc, $debit, $credit, $cleared, $total);
    printf("%5s  %-8s  %-15s  %-9s\n\n", "", "", $cutcom, $nicecat);
}


sub rep_txn_by_cat {
    local($fromdate, $todate, $tofile) = split(/ /, @_[0]);
    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, 
	  $cleared, $total);
    local(%tmp_cat) = ();

    # print "'$fromdate' '$todate'\n";

    if ( $fromdate eq "all" ) {
	$fromdate = "";
    }

    if ( $todate eq "all" ) {
	$todate = "";
    }

    $result = &first_trans();
    while ( $result ne "none" ) {
	($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	 $total) = split(/:/, $result);

	$amt = $credit - $debit;

	if ( (($fromdate == 0) || ($fromdate <= $date)) && 
	    (($todate == 0) || ($todate >= $date)) ) {
	    if ( substr($cat, 0, 1) ne "|" ) {
		$tmp_cat{$cat} .= $key . "," . $amt . ",";
	    } else {
		# process split

		@splits = split(/\|/, $cat);
		shift(@splits);

		$tmp = 0;

		while ( $#splits >= 0 ) {
		    $tcat = shift(@splits);
		    $tamt = shift(@splits);

		    $tmp += $tamt;

		    # print "processing $tcat $tamt\n";
		    $tmp_cat{$tcat} .= $key . "," . $tamt . ",";
		}
		if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
		    printf("WARNING:  Incorrect splits in $date: $desc\n");
		    printf("    %.2f != %.2f\n\n", $tmp, $amt);
		}
	    }
	}
	
	$result = &next_trans();
    }


    $credit_total = 0.00;
    $debit_total = 0.00;

    foreach $lcat (sort keys(%tmp_cat)) {
	chop($tmp_cat{$lcat});	# Delete final comma
	print "$lcat\n";

	@keys = split(/,/, $tmp_cat{$lcat});

	$subtotal = 0.00;

	while ( $#keys >= 0 ) {
	    $lkey = shift(@keys);
	    $amt  = shift(@keys);

	    $result = &find_trans($lkey);

	    ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	     $total) = split(/:/, $result);

	    $subtotal = $subtotal + $amt;
	    if ( $amt > 0 ) {
		$credit_total = $credit_total + $amt;
	    } else {
		$debit_total = $debit_total + $amt;
	    }

	    &format_by_cat( $result, $amt );
	}

	printf("                                         ---------\n" );
	printf("                              Subtotal = %9.2f\n\n", $subtotal);
    }

    printf("                                         ---------\n" );
    printf("                         Total Credits = %9.2f\n\n", $credit_total);

    printf("                                         ---------\n" );
    printf("                          Total Debits = %9.2f\n\n", $debit_total);

    printf("                                         ---------\n" );
    printf("                               Balance = %9.2f\n\n", 
	   $credit_total + $debit_total);

    return "none";
}

sub format_by_cat {
    local($result, $amt) = @_;

    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	  $total) = split(/:/, $result);

    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);
    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
	$nicecat = "-Splits-";
    }

    printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
	  $check, $nicedate, $cutdesc, $amt, $cleared);
}


sub rep_txn_by_cat_short {
    local($fromdate, $todate, $tofile) = split(/ /, @_[0]);
    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, 
          $cleared, $total, $i);
    local(%tmp_cat) = ();

    # print "'$fromdate' '$todate'\n";

    if ( $fromdate eq "all" ) {
        $fromdate = "";
    }

    if ( $todate eq "all" ) {
        $todate = "";
    }

    $result = &first_trans();
    while ( $result ne "none" ) {
        ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
         $total) = split(/:/, $result);

        $amt = $credit - $debit;

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {
            if ( substr($cat, 0, 1) ne "|" ) {
                $tmp_cat{$cat} .= $key . "," . $amt . ",";
            } else {
                # process split

                @splits = split(/\|/, $cat);
                shift(@splits);

		$tmp = 0;

                while ( $#splits >= 0 ) {
                    $tcat = shift(@splits);
                    $tamt = shift(@splits);

		    $tmp += $tamt;

                    # print "processing $tcat $tamt\n";
                    $tmp_cat{$tcat} .= $key . "," . $tamt . ",";
                }
		if ( sprintf("%.2f", $tmp) ne sprintf("%.2f", $amt) ) {
		    printf("WARNING:  Incorrect splits in $date: $desc\n");
		    printf("    %.2f != %.2f\n\n", $tmp, $amt);
		}
            }
        }

        $result = &next_trans();
    }


    $credit_total = 0.00;
    $debit_total = 0.00;

    foreach $lcat (sort keys(%tmp_cat)) {
        chop($tmp_cat{$lcat});  # Delete final comma

        &spad($lcat,35);
#       print "$lcat\";
#       for ($i = length($lcat); $i < 35; $i++) {
#               print " ";
#       }

        @keys = split(/,/, $tmp_cat{$lcat});

        $subtotal = 0.00;

        while ( $#keys >= 0 ) {
            $lkey = shift(@keys);
            $amt  = shift(@keys);

            $result = &find_trans($lkey);

            ($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
             $total) = split(/:/, $result);

            $subtotal = $subtotal + $amt;
            if ( $amt > 0 ) {
                $credit_total = $credit_total + $amt;
            } else {
                $debit_total = $debit_total + $amt;
            }

            &format_by_cat_short( $result, $amt );
        }

#       printf("                                         ---------\n" );
#           printf("     Subtotal = %9.2f\n\n", $subtotal);
            printf(" = %9.2f\n", $subtotal);
    }

#    printf("                                         ---------\n" );
    printf("                      Total Credits = %9.2f\n", $credit_total);

#    printf("                                         ---------\n" );
    printf("                       Total Debits = %9.2f\n", $debit_total);

#    printf("                                         ---------\n" );
    printf("                            Balance = %9.2f\n", 
           $credit_total + $debit_total);

    return "none";
}

# $foo is the string to write, $num is the number of spaces to pad
# note:  it does not printa newline.
sub spad {
    local($foo, $num) = @_;
    local($i);

    for ( $i = length($foo); $i < $num; $i++) {
                print " ";
    }
    print "$foo";
}


sub format_by_cat_short {
    local($result, $amt) = @_;

    local($key, $date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
          $total) = split(/:/, $result);

    ($year,$mon,$day) = $date =~ /(\d\d\d\d)(\d\d)(\d\d)/;
    $year = substr($year, 2, 4);
    $nicedate = "$mon/$day/$year";
    $cutdesc = substr($desc, 0, 20);
    if ( substr($cat, 0, 1) eq "|" ) {
        $nicecat = "-Splits-";
    }

#    printf("  %5s  %-8s  %-20s  %9.2f  %-1s\n",
#         $check, $nicedate, $cutdesc, $amt, $cleared);
}


1;

# ----------------------------------------------------------------------------
# $Log: reports.pl,v $
# Revision 1.7  1995/01/23  03:23:17  curt
# Preparing for more flexible report printing.
#
# Revision 1.6  1995/01/07  01:50:50  curt
# Figured out why report balance didn't match actual balance ... included
# warning now when printing mis-entered splits.
#
# Changed splits Difference -> Sum.
#
# Revision 1.5  1994/12/20  02:44:19  curt
# Added a "by category summary report"
#
# Revision 1.4  1994/12/05  17:12:39  clolson
# Final tunups for 0.51a release.
#
# Revision 1.3  1994/11/29  13:14:53  curt
# Fixed a bug where the temporary category list was not cleared for
# subsequent reports.
#
# Revision 1.2  1994/11/28  19:46:05  clolson
# Additional work on reporting
#
# Revision 1.1  1994/11/28  18:50:20  clolson
# Began integration of reporting functions.
#
