.ds Ps P\s-2OST\s+2S\s-2CRIPT\s+2
.TH hpcdtoppm 1L "3 March 1994"
.IX hpcdtoppm
.SH NAME
hpcdtoppm \- convert a Photo-CD file into a portable bitmap file
.SH SYNOPSIS
.B hpcdtoppm
.I infile
.RB [ \-a ]
.RB [{ \-C | \-0 | \-Overview | \-O }]
.IR "file opt" ]
.RB [ \-c0 ]
.RB [ \-c- ]
.RB [ \-c+ ]
.RB [ \-crop ]
.RB [ \-d ]
.RB [ \-dpi
.IR f ]
.RB [ \-eps ]
.RB [ \-epsd ]
.RB [ \-epsg ]
.RB [ \-fak
.IR scale ]
.RB [ \-hori ]
.RB [ \-i ]
.RB [ \-l ]
.RB [ \-m ]
.RB [ \-n ]
.RB [ \-pb
.IR pos ]
.RB [ \-pgm ]
.RB [ \-ph
.IR height ]
.RB [ \-pl
.IR pos ]
.RB [ \-pos ]
.RB [ \-ppm ]
.RB [ \-ps ]
.RB [ \-psd ]
.RB [ \-psg ]
.RB [ \-pw
.IR width ]
.RB [ \-r ]
.RB [ \-rep ]
.RB [ \-S
.IR "long short" ]
.RB [ \-s ]
.RB [ \-vert ]
.RB [ -x ]
.RB [ \-ycc ]
.RB [ \-1 | \-Base/16
.RI | \-128x192 ]
.RB [ \-2 | \-Base/4
.RI | \-256x384 ]
.RB [ \-3 | \-Base
.RI | \-512x768 ]
.RB [ \-4 | \-4Base
.RI | \-1024x1536 ]
.RB [ \-5 | \-16Base
.RI | \-2048x3072 ]
.RB [ \-6 | \-64Base
.RI | \-4096x6144 ]
.RI [ outfile ]
.SH DESCRIPTION
This program accepts Photo-CD image or overview file data from the specified
input file,
.I infile
(or, if the resolution is lower than 64Base and the file argument is specified as
.BR \- ,
from standard input),
and writes either Portable Bitmap Format or \*(Ps to the specified output file
(or to standard output if no file is specified).
.LP
On a standard Photo-CD,
image files appear in
.IR photo_cd/images ,
where they appear in files with names of the form
.RI img nnnn.pcd ,
where
.I nnnn
is a 4-digit-number.
The overview file appears in
.IR photo_cd/overview.pcd .
.LP
Photo-CD images are stored using as many as 6 different resolutions:
.ta 1i 3i
.nf
	Format	Resolution
	------	----------
	64Base	4096x6144 (ProPhotoCD only)
	16Base	2048x3072
	4Base	1024x1536
	Base	512x768
	Base/4	256x384
	Base/16	128x192
.fi
.LP
The overview file employs Base/16 format.
.IX GIF
.SH OPTIONS
Invoking
.I hpcdtoppm
without arguments produces a list of default values.
Note that you can supply only one size option.
.TP
.B \-a
Automatically determine image orientation
(this option is experimental,
and does not work for overview files).
.TP
{\fB\-C\fP | \fB\-0\fP | \fB\-Overview\fP | \fB\-O\fP } \fIfile opt\fP
Extract all images from an overview file.
The mandatory
.I file
argument is the name of a
.I ppm
file;
output files are named
.IR filennnn ,
where
.I nnnn
is a 4-digit number.
Overview images are extracted in their original Base/16 format.
The value of
.I opt
determines the orientation of the contact sheet image;
recognized values are:
.RS
.TP
.B n
Do not rotate the image.
.TP
.B l
Rotate the picture counter-clockwise (portrait mode).
.TP
.B r
Rotate the picture clockwise (portrait mode).
.RE
.TP
.B \-c0
Do not correct (brighten or darken) the image.
.TP
.B \-c-
Darken the image.
.TP
.B \-c+
Brighten the image.
.TP
.B \-crop
Cut off the black frame which sometimes appears
at the image borders.
.TP
.B \-d
Show only the decompressed difference rather than the complete image
(applicable only to 4Base and 16Base images).
.TP
.B \-dpi res
Set the printer resolution to
.I res
for dithered \*(Ps images. 
.TP
.B \-eps
Write a RGB Encapsulated \*(Ps color image.
.TP
.B \-epsd
Write a Floyd-Steinberg dithered image in Encapsulated \*(Ps.
.TP
.B \-epsg
Write a grayscale image in Encapsulated \*(Ps.
.TP
.B \-fak scale
Set the scaling factor for dithered \*(Ps images to
.IR scale . 
.TP
.B \-hori
Flip the image horizontally.
.TP
.B \-i
Send information from an image file header to standard error.
.TP
.B \-l
Rotate the picture counter-clockwise (portrait mode).
.TP
.B \-m
Write messages about the phases of decoding to standard error.
.TP
.B \-n
Do not rotate the image.
.TP
.B \-pb pos
Set the bottom position of the \*(Ps image to
.IR pos .
.TP
.B \-pgm
Write a
.I pgm
(grayscale) image.
.TP
.B \-ph height
Set the height of the \*(Ps image to
.IR height .
.TP
.B \-pl pos
Set the leftmost position of the \*(Ps image to
.IR pos .
.TP
.B \-pos
Print the relative starting position of the data for the current resolution.
.TP
.B \-ppm
Write a
.I ppm
RGB (color) image.
.TP
.B \-ps
Write a RGB \*(Ps color image.
.TP
.B \-psd
Write a Floyd-Steinberg dithered image in \*(Ps.
.TP
.B \-psg
Write a \*(Ps grayscale image.
.TP
.B \-pw width
Set the width of the \*(Ps image to
.IR width .
.TP
.B \-r
Rotate the picture clockwise (portrait mode).
.TP
.B \-rep
Try to jump over reading errors in the Huffman code. 
.TP
.B \-S "long short"
Cut out a subrectangle with boundaries defined by the values:
.RS
.TP
.I long
For the longer side of the image.
.TP
.I short
For the shorter side of the image.
.RE
.IP
where
.I long
and
.I short
take one of two forms:
.RS
.TP
.B a\-b
Cut from position
.I a
to position
.IR b .
.TP
.B a+b
Starting at offset
.IR a ,
cut a length of
.IR b .
.RE
.IP
and where
.I a
and
.I b
are either integers representing pixel locations,
or floating point values over the range [0.0 ... 1.0],
representing the fraction of the length of a side.
.TP
.B \-s
Apply a simple sharpness operator to the luminosity channel.
.TP
.B \-vert
Flip the image vertically.
.TP
.B -x
Overskip Mode (applicable to Base/16, Base/4, Base and 4Base).
In Photo-CD images the luminosity channel is stored in full resolution,
the two chromaticity channels are stored in half resolution only and have
to be interpolated.
In Overskip Mode,
the chromaticity channels of the next higher resolution are
taken instead of interpolating.
To see the difference,
generate one
.I ppm
with and one
.I ppm
without this flag.
Use
.IR pnmarith (1L)
to generate the difference image of these two images.
Call
.IR ppmhist (1L)
for this difference or show it with
.IR xv (1L)
(push the
.B HistEq
button in the color editor).
.TP
.B \-ycc
Write the image in
.I ppm 
YCC format.
.TP
.BR \-1 | \-Base/16 | \-128x192
Extract the Base/16 image.
.TP
.B \-2 | \-Base/4 | \-256x384
Extract the Base/4 image.
.TP
.B \-3 | \-Base | \-512x768
Extract the Base image.
.TP
.B \-4 | \-4Base | \-1024x1536
Extract the 4Base image.
.TP
.B \-5 | \-16Base | \-2048x3072
Extract the 16Base image.
.TP
.B \-6 | \-64Base | \-4096x6144
Extract the 64Base image. This resolution can be extracted from
ProPhotoCD images only. The path of the 64Base extension files is
derived from the path to the image file. This means that it doesn't work
on stdin an the directory structure must be the very same as on the
ProPhotoCD.
.SH "POSTSCRIPT OUTPUT"
For \*(Ps output (options
.BR \-ps ,
.BR \-eps ,
.BR \-psg ,
.BR \-epsg ,
.BR \-psd ,
.BR \-epsg )
you can define both the resolution and placement of the image.
Both size and position are specified in points (1/72 inch).
.LP
The position of the image
(where the origin is assumed to be at the lower left corner of the page)
is controlled by the
.B \-pl
and
.B \-pb
options (applicable at all resolutions).
.LP
The size of color and grayscale images is changed with the
.B \-pw
and
.B \-ph
options.
Every image pixel is mapped onto one \*(Ps pixel.
.LP
There are three modes of control for dithered \*(Ps:
.TP
Image size
.RB ( \-pw
and
.BR -ph )
.TP
Printer resolution
.RB ( \-dpi )
.TP
Scaling factor
.RB ( \-fak )
.LP
These three factors are interdependent,
hence no more then two can be specified simultaneously.
Using
.B \-dpi
and the
.BR \-pw / \-ph
options together often yields pleasing results.
Even using the default values for these options will
produce results differing from those obtained without use of the options.
.SH BUGS
The program ignores read protection.
.LP
The
.B \-i
option is not working correctly.
.LP
Available information obout the Photo-CD format is vague;
this program was developed by trial-and-error after staring at hex-dumps.
Please send bugs reports and patches to the author.
.SH "SEE ALSO"
pnmarith(1L),
ppm(5L),
ppmhist(1L),
ppmquant(1L),
ppmtopgm(1L),
ppmtorgb3(1L),
xv(1L)
.SH VERSION
The name
.I hpcdtoppm
stands for "Hadmut's pcdtoppm,"
to make it distinguishable in the event that someone else is building
a similar application and naming it
.IR pcdtoppm .
This is version 0.6.
.SH AUTHOR
Copyright (c) 1992, 1993, 1994 by Hadmut Danisch (danisch@ira.uka.de).
This software is not public domain.
Permission to use and distribute this software and its
documentation for noncommercial use and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in
supporting documentation.
This software may not be sold or used for profit-making activities.
.LP
Manual page extensively modified by R. P. C. Rodgers (rodgers@nlm.nih.gov).
.\" end of document

