#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/ShellP.h>
#include <X11/CoreP.h>
#include <X11/Xos.h>

extern int close(/* int fd */);
extern pid_t fork(/* void */);
extern int execvp(/* char *file, char **argv */);

typedef struct _XtTypedArg {
    String      name;
    String      type;
    XtArgVal    value;
    int         size;
} XtTypedArg, *XtTypedArgList;

#include "myxlib.h"
#include "mymalloc.h"
#include "except.h"
#include "reslang.h"

#define XTPOINTER_TO_INT(x) ((int)(long) (x))
#define INT_TO_XTPOINTER(x) ((XtPointer) (long) (x))

extern void   ChangeWidget(Widget widget);
extern void   ShowTree(Widget w);
extern Widget HelpOnWidget(Widget w, const char *Name);

Atom ProtocolList[1];
static Atom DELETE;

/*
static void WMProtocol(Widget w, XEvent *event, String *str, Cardinal *n);
static void Destroy(), Exit(), Quit(), Mallocstats(), SetFocus();
static void Map(), Unmap(), Manage(), Unmanage(), SetValues(), CreateWitchet();
static void Popup(), Popdown(), PopToggle(), PopupMenu();
static void System(), Beep(Widget w, XEvent *evnt, String *str, Cardinal *n),
            Echo(), Help();
static void Info(Widget w, XEvent *evnt, String *str, Cardinal *n),
            Change(Widget w, XEvent *evnt, String *str, Cardinal *n),
            WidgetAction(Widget w, XEvent *evnt, String *str, Cardinal *n),
            WidgetTree(Widget w, XEvent *evnt, String *str, Cardinal *n);
*/

/*****************************************************************************/
/* An exit procedure that handles pending events                             */
/*****************************************************************************/

static int DoLoop;
static XtPointer LoopRc;

static Boolean ExitWorkProc(XtPointer closure)
{
    exit(XTPOINTER_TO_INT(closure));
    return True;
}

void Xexit(XtAppContext App, int status)
{
    XtAppAddWorkProc(App, ExitWorkProc, INT_TO_XTPOINTER(status));
}

static Boolean QuitWorkProc(XtPointer closure)
{
    LoopRc = closure;
    DoLoop = 0;
    return True;
}

void Xquit(XtAppContext App, XtPointer status)
{
    XtAppAddWorkProc(App, QuitWorkProc, status);
}

XtPointer MyAppMainLoop(XtAppContext app_context)
{
    XEvent event;

    DoLoop = 1;
    while (DoLoop) {
        XtAppNextEvent(app_context, &event);
        XtDispatchEvent(&event);
    }
    return LoopRc;
}

/*****************************************************************************/
/* Multiple WM_PROTOCOL messages                                             */
/*****************************************************************************/

const char *ResourceStringToString(const char *From)
{
    ResParse *Parse;

    Parse = resParse(From, strlen(From));
/*
    fprintParse(stdout, Parse);
    putc('\n', stdout);
*/
    FreeParse(Parse);
    return From;
}

int ResourceStringToInt(const char *From)
{
    ResParse *Parse;

    Parse = resParse(From, strlen(From));
/*
    fprintParse(stdout, Parse);
    putc('\n', stdout);
*/
    FreeParse(Parse);
    return atoi(From);
}

#define ClassName(x) (((CoreClassPart *)(x))->class_name)

#ifndef   HAVE_NO_STDARG_H
void WidgetWarning(Widget w, const char *Format, ...)
#else  /* HAVE_NO_STDARG_H */
void WidgetWarning(w, va_alist)
Widget w;
va_dcl
#endif /* HAVE_NO_STDARG_H */
{
    va_list         args;
    char            Buffer[2048];
#ifndef   HAVE_NO_STDARG_H
    va_start(args, Format);
#else  /* HAVE_NO_STDARG_H */
    const char *Format;

    va_start(args);
    Format = va_arg(args, const char *);
#endif /* HAVE_NO_STDARG_H */
    sprintf(Buffer, "%.*s%s %.*s: ",
            (int) sizeof(Buffer)/4-9, ClassName(XtClass(w)),
            XtIsWidget(w) == False ? "Object" : "Widget",
            (int) sizeof(Buffer)/4, XtName(w));
    vsprintf(strchr(Buffer, 0), Format, args);
    va_end(args);
    XtAppWarning(XtWidgetToApplicationContext(w), Buffer);
}

/* This code is stolen from SimpleMenu */
/* ARGSUSED */
static void PopupMenu(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    Widget      menu, temp, last;
    int         menu_x, menu_y, menu_width, menu_height;
    Position    button_x, button_y;
    const char *Name;
    XtPointer   data;

    if (*n == 1 || *n == 2) {
        Name = ResourceStringToString(str[0]);
        menu = last = NULL;
        for (temp = w; temp; temp = XtParent(temp)) {
            last = temp;
            menu = XtNameToWidget(temp, (String) Name);
            if (menu) break;
        }
        if (!menu && last && FindCallback(last, XtNdestroyCallback,
                                          CallFakeChildDestroy, &data))
            menu = XtNameToWidget((Widget) data, (String) Name);

        if (menu) {
            if (XtIsRealized(menu) == False) XtRealizeWidget(menu);
  
            menu_width    = menu->core.width  + 2 * menu->core.border_width;
            menu_height   = menu->core.height + 2 * menu->core.border_width;

            if (*n != 1)
                for (temp = w; temp; temp = XtParent(temp))
                    if (XtIsShell(temp) != False) {
                        w = temp;
                        break;
                    }
            XtTranslateCoords(w, 0, 0, &button_x, &button_y);
            menu_x = button_x - (menu_width - (int) w->core.width)/2;
            if (*n == 1)
                menu_y = button_y + w->core.height + w->core.border_width;
            else menu_y = button_y - (menu_height - (int) w->core.height)/2;

            if (menu_x >= 0) {
                int scr_width = WidthOfScreen(XtScreen(menu));
                if (menu_x + menu_width > scr_width)
                    menu_x = scr_width - menu_width;
            }
            if (menu_x < 0) menu_x = 0;

            if (menu_y >= 0) {
                int scr_height = HeightOfScreen(XtScreen(menu));
                if (menu_y + menu_height > scr_height)
                    menu_y = scr_height - menu_height;
            }
            if (menu_y < 0) menu_y = 0;

            XtVaSetValues(menu,
                          XtNx, (XtArgVal) menu_x,
                          XtNy, (XtArgVal) menu_y,
                          NULL);

            XtPopupSpringLoaded(menu);
        } else WidgetWarning(w, "popupmenu() action could not find widget "
                             "named %.*s", 500, Name);
    } else WidgetWarning(w, "popupmenu() action must be called with just the "
                         "popupshell name as an argument");
}

static void WidgetTree(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    Widget         Test;

    for (Test = w; Test; Test = XtParent(Test))
        if (XtIsShell(Test) != False) {
            ShowTree(Test);
            return;
        }
    WidgetWarning(w, "could not find Shell parent. This is bad(TM)");
}

static void Info(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    Widget         Test;

    Test = XtWindowToWidget(XtDisplay(w), ((XButtonEvent *) evnt)->window);
    if (Test) w = Test;
    InfoOfWidget(w);
}

static void Help(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    const char *Name;
    Widget      Root;
    String      WorkStr[2];
    Cardinal    WorkN;

    switch(*n) {
      default:
        WidgetWarning(w, "help() action must have 0 or 1 arguments. "
                      "Extra arguments ignored");
      case 1:
        Name = ResourceStringToString(str[0]);
        break;
      case 0:
        Name = XtName(w);
        break;
    }
    Root = HelpOnWidget(w, Name);
    if (Root) {
        WorkStr[0] = XtName(Root);
        WorkStr[1] = "middle";
        WorkN      = XtNumber(WorkStr);
        PopupMenu(w, evnt, WorkStr, &WorkN); 
    }
}

static void Beep(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    int i, m;

    m = *n;
    if (m) for (i=0; i<m; i++)
        XBell(XtDisplay(w), ResourceStringToInt(str[i]));
    else XBell(XtDisplay(w), 20);
}

static void WidgetAction(Widget w, XEvent *evnt,
                         String *str, Cardinal *n)
{
    if (*n) XtCallCallbacks(w, XtNcallback,
                            (XtPointer) ResourceStringToString(str[0]));
    else    XtCallCallbacks(w, XtNcallback, (XtPointer) NULL);
}

static void SetFocus(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget   Here, Source, Dest, *Children;
    Cardinal NumChildren;

    Here = Dest = Source = w;
    while (XtIsShell(Here) == False) Here = XtParent(Here);
    XtVaGetValues(Here,
                  XtNchildren,    (XtArgVal) &Children,
                  XtNnumChildren, (XtArgVal) &NumChildren,
                  NULL);
    /* Should always be one, but I'm paranoid */
    if (NumChildren) Source = *Children;

    switch(*n) {
      case 2:
        w = MyNameToWidget(Here, ResourceStringToString(str[1]));
        if (w) Source = w;
        else WidgetWarning(w, "setfocus() called with an invalid widgetname "
                           "as source");
        /* Intended drop through */
      case 1:
        w = MyNameToWidget(Here, ResourceStringToString(str[0]));
        if (w) Dest = w;
        else WidgetWarning(w, "setfocus() called with an invalid widgetname "
                           "as destination");
        /* Intended drop through */
      case 0:
        XtSetKeyboardFocus(Source, Dest);
        break;
      default:
        WidgetWarning(w, "setfocus() action called with more arguments than "
                      "just source and destination widgets");
        break;
    }
}

static void Unmanage(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget *Widgets, *Ptr;
    int     i;

    while (XtIsShell(w) == False) w = XtParent(w);
    
    Ptr = Widgets = mynews(Widget, *n);
    for (i= *n; i>0; i--, str++)
        if (0 == (*Ptr++ = MyNameToWidget(w, ResourceStringToString(*str)))) {
            WidgetWarning(w, "unmanage() called on invalid widget name");
            break;
        }
    if (!i) XtUnmanageChildren(Widgets, *n);
    myfree(Widgets);
}

static void Manage(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget *Widgets, *Ptr;
    int     i;

    while (XtIsShell(w) == False) w = XtParent(w);
    
    Ptr = Widgets = mynews(Widget, *n);
    for (i= *n; i>0; i--, str++)
        if (0 == (*Ptr++ = MyNameToWidget(w, ResourceStringToString(*str)))) {
            WidgetWarning(w, "manage() called on invalid widget name");
            break;
        }
    if (!i) XtManageChildren(Widgets, *n);
    myfree(Widgets);
}

static void Unmap(Widget w, XEvent *event, String *str, Cardinal *n)
{
    while (XtIsShell(w) == False) w = XtParent(w);
    XtUnmapWidget(w);
}

static void Map(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget pop;

    switch(*n) {
      case 0:
        /* Or map all children */
        WidgetWarning(w, "map() action called without widget name");
        break;
      case 1:
        pop = MyNameToWidget(w, ResourceStringToString(str[0]));
        if (pop) XtMapWidget(pop);
        else     WidgetWarning(w, "map() called on invalid widget name");
        break;
      default:
        WidgetWarning(w, "map() action called with more than one argument");
        break;
    }
}

static void Popdown(Widget w, XEvent *event, String *str, Cardinal *n)
{
    while (XtIsShell(w) == False) w = XtParent(w);
    XtPopdown(w);
}

static void Popup(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget      pop, Here;
    const char *Name;

    switch(*n) {
      case 0:
        /* Or popup all children */
        WidgetWarning(w, "popup() action called without widget name");
        break;
      case 2:
        /* Set grabtype here ??  */
        /* intended drop through */
      case 1:
        Name = ResourceStringToString(str[0]);
        for (Here = w; Here; Here = XtParent(Here))
            if ((pop = MyNameToWidget(Here, Name)) != 0) {
                if (XtIsRealized(pop) != False) XtPopup(pop, XtGrabNone);
                else MyRealizeWidget(pop);
                return;
            }
        WidgetWarning(w, "popup() called on invalid widget name %.200s", Name);
        break;
      default:
        WidgetWarning(w, "popup() action called with more than two arguments");
        break;
    }
}

static void PopToggle(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget      pop, Here;
    const char *Name;

    switch(*n) {
      case 0:
        /* Or toggle all children */
        WidgetWarning(w, "poptoggle() action called without widget name");
        break;
      case 2:
        /* Set grabtype here ??  */
        /* intended drop through */
      case 1:
        Name = ResourceStringToString(str[0]);
        for (Here = w; Here; Here = XtParent(Here))
            if ((pop = MyNameToWidget(Here, Name)) != 0) {
                if (((ShellWidget) pop)->shell.popped_up == False)
                    if (XtIsRealized(pop) != False) XtPopup(pop, XtGrabNone);
                    else MyRealizeWidget(pop);
                else XtPopdown(pop);
                return;
            }
        WidgetWarning(w, "poptoggle() called on invalid widget name %.200s",
                      Name);
        break;
      default:
        WidgetWarning(w, "poptoggle() action called with more than two "
                      "arguments");
        break;
    }
}

static void SetValues(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget      Here, Next;
    int         m;
    XtTypedArg *AvList, *Av;
    const char *Ptr;
    char *Open, *Close;
  
    if (*n % 2) { 
        Here = w;
        Ptr = ResourceStringToString(str[0]);
        if (Ptr && *Ptr) {
            while ((Next = XtParent(Here)) != 0) Here = Next;
            Close = NULL;
            if ((Open = strchr(Ptr, '(')) != NULL &&
                (Close = strchr(Open, ')')) != NULL) {
                Close = mystrndup(Open+1, Close-Open-1);
                Open  = mystrndup(Ptr, Open-Ptr);
                Here  = MyNameToWidget(Here, Close);
                if (Here) XtVaGetValues(Here, Open, &Here, NULL);
                myfree(Open);
                myfree(Close);
            } else Here = MyNameToWidget(Here, Ptr);
        }
        if (Here) {
            m = *n/2;
            if (m)
                if (m == 1) {
                    Ptr = ResourceStringToString(str[2]);
                    XtVaSetValues(Here, XtVaTypedArg,
                                  ResourceStringToString(str[1]), XtRString,
                                  (XtArgVal) Ptr, strlen(Ptr)+1, NULL);
                } else {
                    AvList = mynews(XtTypedArg, m+1);
                    str++;
                    for (Av = AvList; m>0; m--, Av++) {
                        Av->name  = (String) ResourceStringToString(*str++);
                        Av->type  = XtRString;
                        Ptr = ResourceStringToString(*str++);
                        Av->value = (XtArgVal) Ptr;
                        Av->size  = strlen(Ptr)+1;
                    }
                    Av->name = NULL;
                    XtVaSetValues(Here, XtVaNestedList, AvList, NULL);
                    myfree(AvList);
                }
        } else WidgetWarning(w, "setvalues() action called on unknown widget "
                             "name %.200s", Ptr);
    } else WidgetWarning(w, "setvalues() action called with an"
                         " even number of arguments");
}

static void CreateWitchet(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget      Here, Next;
    int         m;
    XtTypedArg *AvList, *Av;
    const char *Ptr;
    const char *Name;
    XtPointer   data;
  
    if (*n >= 2) {
        if (*n % 2 == 0) {
            Name = ResourceStringToString(str[0]);
            Here = w;
            while ((Next = XtParent(Here)) != NULL) Here = Next;
            if (FindCallback(Here, XtNdestroyCallback, CallFakeChildDestroy,
                             &data)) Here = (Widget) data;
            Here = MyNameToWidget(Here, ResourceStringToString(str[1]));
            if (Here) {
                m = *n/2-1;
                AvList = mynews(XtTypedArg, m+1);
                str+=2;
                for (Av = AvList; m>0; m--, Av++) {
                    Av->name  = (String) ResourceStringToString(*str++);
                    Av->type  = XtRString;
                    Ptr = ResourceStringToString(*str++);
                    Av->value = (XtArgVal) Ptr;
                    Av->size  = strlen(Ptr)+1;
                }
                Av->name = NULL;
                w = MyVaCreateManagedWidget(Name, Here,
                                            XtVaNestedList, AvList, NULL);
                MyRealizeWidget(w);
                myfree(AvList);
            } else WidgetWarning(w, "createwitchet() action called on an"
                                 " unknown widget name");
        } else WidgetWarning(w, "createwitchet() action called with an"
                             " odd number of arguments");
    } else WidgetWarning(w, "createwitchet() action called with less than"
                         " two arguments");
}

typedef const char *constString;

static void System(Widget w, XEvent *event, String *str, Cardinal *n)
{
    pid_t        Id;
    int          m;
    constString *Args, *Argh;

    if (*n) {
        switch(Id = fork()) {
          case 1:
            WidgetWarning(w, "system() failed, could not execute fork()");
            break;
          case 0:               /* Child */
            close(ConnectionNumber(XtDisplay(w)));
            Args = mynews(constString, *n+1);
            for (Argh = Args, m = *n; m>0; m--, Argh++, str++)
                *Argh = ResourceStringToString(*str);
            *Argh = NULL;
            CleanHandlers();
            /* should be: execvp(Args[0], (char * const *) Args), 
               but some compilers want const char ** or char ** */
            execvp(Args[0], (void *) Args);
            WidgetWarning(w, "system() failed, could not execute execvp()");
            exit(0);
            break;
          default:              /* Parent */
            break;
        }
    } else WidgetWarning(w, "system() called without arguments");
}

static void Exit(Widget w, XEvent *event, String *str, Cardinal *n)
{
    int rc;

    if (*n > 0) rc = ResourceStringToInt(str[0]);
    else        rc = 0;
    Xexit(XtWidgetToApplicationContext(w), rc);
}

static void Quit(Widget w, XEvent *event, String *str, Cardinal *n)
{
    int rc;

    if (*n > 0) rc = ResourceStringToInt(str[0]);
    else        rc = 0;
    Xquit(XtWidgetToApplicationContext(w), INT_TO_XTPOINTER(rc));
}

static void Mallocstats(Widget w, XEvent *event, String *str, Cardinal *n)
{
    mallocstats();
}

static void Destroy(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Widget Here;
    int    m;

    if (*n)
        for (m= *n; m>0; m--) {
            while (XtIsShell(w) == False) w = XtParent(w);

            Here = MyNameToWidget(w, ResourceStringToString(*str++));
            if (Here) {
                XtUnrealizeWidget(Here);
                XtDestroyWidget(Here);
            } else WidgetWarning(w, "destroy() refers to invalid widget name");
        }
    else {
        XtUnrealizeWidget(w);
        XtDestroyWidget(w);
    }
}

static void Echo(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    Cardinal i;

    if (*n) fputs(ResourceStringToString(str[0]), stdout);
    for (i=1; i<*n; i++) {
        putc(' ', stdout);
        fputs(ResourceStringToString(str[i]), stdout);
    }
    putc('\n', stdout);
    fflush(stdout);
}

Atom GetAtom(Widget w, const char *name)
{
    Atom     a;
    XrmValue src, dst;

    src.size = strlen(name)+1;
    src.addr = (XPointer) name;
    dst.size = sizeof(Atom);
    dst.addr = (XPointer) &a;

    XtConvertAndStore(w, XtRString, &src, XtRAtom, &dst);
    return a;
}

/* Multiplex WM_PROTOCOL events. Is a bit silly when we handle only one type */

static void WMProtocol(Widget w, XEvent *event, String *str, Cardinal *n)
{
    Atom   protocol;
    XEvent myEvent;
    int    rc;

    protocol = (Atom) event->xclient.data.l[0];
    if (event->type == ClientMessage) {
        if (protocol == ProtocolList[0]) { /* WM_DELETE_WINDOW */
            myEvent.xclient.type         = ClientMessage;
            myEvent.xclient.display      = event->xclient.display;
            myEvent.xclient.window       = event->xclient.window;
            myEvent.xclient.message_type = DELETE;
            myEvent.xclient.format       = 8;
            rc = XSendEvent(event->xclient.display, event->xclient.window,
                            False, NoEventMask, &myEvent);
        }
    }
}

static void Change(Widget w, XEvent *evnt, String *str, Cardinal *n)
{
    Widget         Test;

    Test = XtWindowToWidget(XtDisplay(w), ((XButtonEvent *) evnt)->window);
    if (Test) w = Test;
    ChangeWidget(w);
}

static XtActionsRec actionTable[] = {
    { "WMprotocol",    WMProtocol    },
    { "destroy",       Destroy       },
    { "exit",          Exit          },
    { "quit",          Quit          },
    { "mallocstats",   Mallocstats   },
    { "setfocus",      SetFocus      },
    { "map",           Map           },
    { "manage",        Manage        },
    { "unmanage",      Unmanage      },
    { "unmap",         Unmap         },
    { "popup",         Popup         },
    { "popdown",       Popdown       },
    { "poptoggle",     PopToggle     },
    { "popupmenu",     PopupMenu     },
    { "setvalues",     SetValues     },
    { "createwitchet", CreateWitchet },
    { "system",        System        },
    { "beep",          Beep          },
    { "echo",          Echo          },
    { "info",          Info          },
    { "help",          Help,         },
    { "change",        Change        },
    { "widgetAction",  WidgetAction  },
    { "widgets",       WidgetTree    }, 
};

void InitWMProtocol(Widget top)
{
    XtRegisterGrabAction(PopupMenu, True, ButtonPressMask | ButtonReleaseMask,
			 GrabModeAsync, GrabModeAsync);
    XtAppAddActions(XtWidgetToApplicationContext(top),
                    actionTable, XtNumber(actionTable)); 
    ProtocolList[0] = GetAtom(top, "WM_DELETE_WINDOW");
    DELETE          = GetAtom(top, "DELETE");
}
