/*

Copyright 1991-1995 Stephen S. Richardson (prefect@wpi.edu)
based off of several versions for several hardware and software platforms
from 1991-1995.

(credit is due to Arthur C. Smith, whose joystick code I studied to learn how
to write linux device drivers, and to Linus Torvalds, for being the cool kind
of person to start the whole Linux project.. yar.)

You may modify, copy, fix, change, or delete this code, as long as my
copyright remains intact.  Well, if you delete it, it doesn't have to.  I also
ask that you send me a piece of email if you make any interesting changes.
You don't have to, but I want to see if anyone does anything cool with it.

There are no warranties, expressed or implied.  If your computer blows up, or
you blow up your sibling trying to use this, I'm not responsible.  If it works,
and all your friends thing you're cool, you must tell them it is due to this
project. ;)


10/23/94    S.Richardson 0.1   Initial version
10/26/94    S.Richardson 0.2   More revisions
01/??/95    S.Richardson 0.3   More revisions again.
02/02/95    S.Richardson 0.042 "release"
07/30/95    S.Richardson 0.50  "release 2" - cleanup for newer kernels.

*/

#include <sys/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <utmp.h>
#include <math.h>
#include "release.h"
#include "lcd.h"

void lcd_init (int fd)
{
  int status;
  struct LCD_DATA_TYPE lcd;

  status=ioctl (fd, LCD_SETCONTROL);
  if (status == -1) {
    perror ("lcd");
    exit (1);
  }

  strcpy (lcd.text, LCD_INITSTRING);
  status = write (fd, &lcd, LCD_DATASIZE);
  if (status != LCD_DATASIZE) {
    perror ("lcd");
    exit (1);
  }
  usleep (1000);
}

void lcd_open (int *fd)
{
  *fd = open ("/dev/lcd0", O_WRONLY);
  if (*fd < 0) {
	perror ("lcd");
	exit (1);
      }
  lcd_init (*fd);
}



void lcd_clear (int fd)
{
  int status;
  struct LCD_DATA_TYPE lcd;

  status=ioctl (fd, LCD_SETCONTROL);
  if (status == -1) {
    perror ("lcd");
    exit (1);
  }

  strcpy (lcd.text, LCD_CLEARSTRING);
  status = write (fd, &lcd, LCD_DATASIZE);
  if (status != LCD_DATASIZE) {
    perror ("lcd");
    exit (1);
  }
}

void lcd_pos (int fd, int pos)
{
  int status;
  struct LCD_DATA_TYPE lcd;

  status=ioctl (fd, LCD_SETCONTROL);
  if (status == -1) {
    perror ("lcd");
    exit (1);
  }

  if ((pos<0)||(pos>0x40+40)) {
    printf ("lcd: position out of range\n");
    exit (1);
  }

  lcd.text[0]=128+pos;
  lcd.text[1]=0;

  status = write (fd, &lcd, LCD_DATASIZE);
  if (status != LCD_DATASIZE) {
    perror ("lcd");
    exit (1);
  }
}
 
void lcd_write (int fd, char *str)
{
  struct LCD_DATA_TYPE lcd;
  int status;

  strcpy (lcd.text, str);
  ioctl (fd, LCD_SETDATA);
  status = write (fd, &lcd, LCD_DATASIZE);
  if (status != LCD_DATASIZE) {
    perror ("lcd");
    exit (1);
  }
}

void netstat (char *dev, int *ip, int *op)
{
  FILE *nf;
  int j;
  char s_dv [12];
  char ln [100];

  nf=fopen ("/proc/net/dev", "rt");
  fgets (ln, 120, nf);
  fgets (ln, 120, nf);

  do {
    fscanf (nf, "%s %d %d %d %d %d %d %d %d %d %d %d", s_dv, ip, &j, &j, &j, &j, op, &j, &j, &j, &j, &j);
  } while (strcmp (s_dv, dev) != 0);
  fclose (nf);
}

double instload (char *pf)
/* returns the instantaneous load of the system */
{
  FILE *lf;
  double l=0, junk;

  lf=fopen (pf, "rt");
  fscanf (lf, "%lf %lf %lf", &l, &junk, &junk);
  fclose (lf);
  return l;
}

int numusers (char *utf)
/* returns # of users logged on */
{
  FILE *uf;
  struct utmp ut;
  int num=0;

  uf=fopen (utf, "rb");

  do {
    fread (&ut, sizeof(struct utmp), 1, uf);
    if ((ut.ut_type == USER_PROCESS) && (ut.ut_user[0]!=0)) {
      num++;
    }
  } while (!feof(uf));
  fclose (uf);
  return (num);
}

void memstat (int *tot, int *used, int *bf, char *pf)
{
  FILE *mf;
  int j;
  char ln[100];
  
  mf=fopen (pf, "rt");
  fgets (ln, 120, mf);
  fscanf (mf, "%s %d %d %d %d %d", ln, tot, used, &j, &j, bf);
  fclose (mf);

}

void do_summary (int fd)
{
  char text[81], l1[41], l2[41], ln[41], tms[30];
  int nu=0, i, c=0;
  double il, il_f, il_w;
  int mem_tot, mem_used, mem_bf;
/*  int eth0_i, eth0_o, eth1_i, eth1_o, eth0_t, eth1_t, eth0_l=0, eth1_l=0, eth0_c=0, eth1_c=0;*/
  double p_bf, p_u;
  int i_bf, i_u;
  time_t t;
/*  char spin[4] = {'.', 'o', 'O', 'o'};*/

  lcd_init (fd);
  /*            0123456789012345678901234567890123456789 */
  sprintf (l1, "Mem  [               ] eth0 [ ] eth1 [ ]"); 
  sprintf (l2, "Ld+  [               ][    users][  :  ]");

  sprintf (text, "%-40.40s%-40.40s", l1, l2);
  lcd_write (fd, text);
  
  do {
    /* do time */
    time (&t);
    strcpy (tms, ctime(&t));
    strcpy (ln, "  :  ");
    ln [0]=tms[11];
    ln [1]=tms[12];
    ln [3]=tms[14];
    ln [4]=tms[15];
    lcd_pos (fd, 0x40+34);
    lcd_write (fd, ln);

    /* do users */
    nu=numusers(UTMP_FILE);
    sprintf (ln, "%3d", nu);
    lcd_pos (fd, 0x40+23);
    lcd_write (fd, ln);

    /* do load */
    il=instload("/proc/loadavg");
    il_f=modf(il, &il_w);
    il_f=il_f*15;

    sprintf (ln, "%2d", (int) il_w);
    lcd_pos (fd, 0x40+3);
    lcd_write (fd, ln);

    /*           012345678901234 */
    strcpy (ln, "               ");
    for (i=0;i<(int)il_f;i++) ln[i]=219;
    lcd_pos (fd, 0x40+6);
    lcd_write (fd, ln);

    /* do memory */
    memstat (&mem_tot, &mem_used, &mem_bf, "/proc/meminfo");
   
    p_u=(double)mem_used/(double)mem_tot;
    p_bf=(double)mem_bf/(double)mem_tot;

    i_bf=p_bf*15;
    i_u=p_u*15;

    /*           012345678901234 */
    strcpy (ln, "               ");
    
    for (i=0;i<i_u;i++) ln[i]='u';
    for (i=0;i<i_bf;i++) ln[i]='B';
    
    lcd_pos (fd, 6);
    lcd_write (fd, ln);

    c=0;
    sprintf (ln, " ");
    sleep (1);
  } while (1);
}

void do_summary_2 (int fd)
{
  char text[81], l1[41], l2[41], ln[41], tms[30];
  int nu=0, i, c=0;
  double il, il_f, il_w;
  int mem_tot, mem_used, mem_bf;
/*  int eth0_i, eth0_o, eth1_i, eth1_o, eth0_t, eth1_t, eth0_l=0, eth1_l=0, eth0_c=0, eth1_c=0;*/
  double p_bf, p_u;
  int i_bf, i_u;
  time_t t;
/*  char spin[4] = {'.', 'o', 'O', 'o'};*/

  lcd_init (fd);

  /*            0123456789012345678901234567890123456789 */
  sprintf (l1, "CPU0 us    M[          ] L  [          ]"); 
  sprintf (l2, "CPU1 us    M[          ] L  [          ]");

  sprintf (text, "%-40.40s%-40.40s", l1, l2);
  lcd_write (fd, text);
  
  do {
    /* do users */
    nu=numusers(UTMP_FILE);
    sprintf (ln, "%2d", nu);
    lcd_pos (fd, 8);
    lcd_write (fd, ln);

    nu=numusers("/var/bw/utmp");
    sprintf (ln, "%2d", nu);
    lcd_pos (fd, 0x40+8);
    lcd_write (fd, ln);


    /* do loads */
    il=instload("/proc/loadavg");
    il_f=modf(il, &il_w);
    il_f=il_f*10;
    sprintf (ln, "%2d", (int) il_w);
    lcd_pos (fd, 26);
    lcd_write (fd, ln);
    strcpy (ln, "          ");
    for (i=0;i<(int)il_f;i++) ln[i]=219;
    lcd_pos (fd, 29);
    lcd_write (fd, ln);

    il=instload("/var/bw/loadavg");
    il_f=modf(il, &il_w);
    il_f=il_f*10;
    sprintf (ln, "%2d", (int) il_w);
    lcd_pos (fd, 0x40+26);
    lcd_write (fd, ln);
    strcpy (ln, "          ");
    for (i=0;i<(int)il_f;i++) ln[i]=219;
    lcd_pos (fd, 0x40+29);
    lcd_write (fd, ln);

    /* do memories */
    memstat (&mem_tot, &mem_used, &mem_bf, "/proc/meminfo");
    p_u=(double)mem_used/(double)mem_tot;
    p_bf=(double)mem_bf/(double)mem_tot;
    i_bf=p_bf*10;
    i_u=p_u*10;
    strcpy (ln, "          ");
    for (i=0;i<i_u;i++) ln[i]='u';
    for (i=0;i<i_bf;i++) ln[i]='B';
    lcd_pos (fd, 13);
    lcd_write (fd, ln);

    memstat (&mem_tot, &mem_used, &mem_bf, "/var/bw/meminfo");
    p_u=(double)mem_used/(double)mem_tot;
    p_bf=(double)mem_bf/(double)mem_tot;
    i_bf=p_bf*10;
    i_u=p_u*10;
    strcpy (ln, "          ");
    for (i=0;i<i_u;i++) ln[i]='u';
    for (i=0;i<i_bf;i++) ln[i]='B';
    lcd_pos (fd, 0x40+13);
    lcd_write (fd, ln);

    c=0;
    sprintf (ln, " ");
    sleep (1);
  } while (1);
}

int main (void)
{
	int fd;

	lcd_open (&fd);

	while (1) {
	  do_summary_2(fd);
	}
	exit (0);
}









