/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ rcimsgs.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs-3.21/lib/RCS/rcimsgs.c,v $
 *
 * DESCRIPTION:
 *
 *
 *	Diagnose request code information bits.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	April 28, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.2 $ $Date: 92/06/18 13:24:30 $ $State: Exp $)
 * $Log:	rcimsgs.c,v $
 * Revision 1.2  92/06/18  13:24:30  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  12:45:17  jrroma
 * Initial revision
 * 
 *
 */

#include <stdio.h>		/* FILE definition */
#include "informcc.h"		/* NQS information completion codes */

/*** rcimsgs
 *
 *
 *	void rcimsgs():
 *	Diagnose request code information bits.
 */
void rcimsgs (
	long code,		/* Completion code */
	FILE *stream,		/* Output stream */
	char *prefix,		/* Output prefix */
	void (*headerfn)())	/* Header display function */
{
	register short preamble;	/* Preamble seen flag */

	preamble = -1;			/* No preamble yet */
	if (code & RCI_ACCESSDEN) {
		preamble = 0;
		(*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Access denied;\n", stream);
	}
	if (code & RCI_CLIMIDUNKN) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Client machine-id is unknown at transaction peer;\n",
		       stream);
	}
	if (code & RCI_EFBIG) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  File size limit exceeded;\n", stream);
	}
	if (code & RCI_FATALABORT) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Non-recoverable transaction failure;\n", stream);
	}
	if (code & RCI_MIDCONFLICT) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs (
		  "  Machine-id conflict between client and destination;\n",
		     stream);
	}
	if (code & RCI_NETNOTSUPP) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Networking not supported at NQS site.\n", stream);
	}
	if (code & RCI_NETPASSWD) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Network password verification error;\n", stream);
	}
	fflush (stream);		/* For logfile */
	if (code & RCI_NOSUCHFORM) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  No such device forms;\n", stream);
	}
	if (code & RCI_NOSUCHQUE) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  No such queue;\n", stream);
	}
	if (code & RCI_PEERINTERR) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  NQS internal error at transaction peer;\n", stream);
	}
	if (code & RCI_PEERMIDUNKN) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Local machine-id is unknown at transaction peer;\n",
		       stream);
	}
	if (code & RCI_PEERNETDB) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Network database error at transaction peer;\n",
		       stream);
	}
	if (code & RCI_PEERNOACATH) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  No account authorization at transaction peer;\n",
		       stream);
	}
	fflush (stream);		/* For logfile */
	if (code & RCI_PROTOFAIL) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  NQS protocol failure;\n", stream);
	}
	if (code & RCI_QUOTALIMIT) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Explicit request quota limits exceed maximums;\n",
		       stream);
	}
	if (code & RCI_RRFUNKNMID) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs (
		  "  Request refers to mids unknown at transaction peer;\n",
		   stream);
	}
	if (code & RCI_WROQUETYP) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Wrong queue type for request;\n", stream);
	}
	if (code & RCI_UNAFAILURE) {
		if (!(++preamble)) (*headerfn)(stream, prefix);
		fputs (prefix, stream);
		fputs ("  Unanticipated transaction failure;\n", stream);
	}
	fflush (stream);		/* For logfile */
}
