#ifndef __NQS_GENERIC_XCI_HEADER
#define __NQS_GENERIC_XCI_HEADER

/*
 * nqs_generic/XCI.h
 * Masks for completion information
 * 
 * See ChangeLog for modification list
 */

#include <nqs_generic/license.h>

/*
 * NOTES:
 * 
 * 	1) The XCI_ values used here are used at both the local and peer
 * 	   machines.  Changing any of these values will result in Monsanto-NQS
 * 	   becoming *incompatible* with other NQS implementations.
 */

/*
 *	This file describes the information flags that are valid
 *	for the 21-bits of information data in an NQS completion
 *	code.
 *
 *	All NQS request and transaction completion codes fit in
 *	a long integer.  Each NQS completion code is broken down
 *	into four (4) sections:
 *
 *	.----------------------------------------------------------.
 *	| 0 | 21-bits of additional information | T | 9-bit reason |
 *	`----------------------------------------------------------'
 *
 *	The highest-order bit must be zero, to make the value positive,
 *	for "32-bit machines."
 *
 *	The 'T' bit when set, indicates that the code is a TRANSACTION
 *	completion code.  Otherwise, the code is a REQUEST completion
 *	code.
 */
 
/*
 *	Information field (XCI_) masks:
 */
#define	XCI_FULREA_MASK	000000001777L
  /*Full reason mask */
#define	XCI_REASON_MASK	000000000777L
  /*Reason bits */
#define	XCI_TRANSA_MASK	000000001000L
  /*Transaction code bit mask */
#define	XCI_PEER_MASK	000000000400L
  /*Transaction code from peer mask */
#define	XCI_INFORM_MASK	017777776000L
  /*Information bits */

#endif 		/* __NQS_GENERIC_XCI_HEADER */