/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*
*  PROJECT:     Network Queueing System
*  AUTHOR:      John Roman
*
*  Modification history:
*
*       Version Who     When            Description
*       -------+-------+---------------+-------------------------
*       V01.10  JRR                     Initial version.
*       V01.20  JRR     16-Jan-1992	Added support for RS6000.
*       V01.3   JRR     28-Feb-1992	Added Cosmic V2 changes.
*       V01.4   JRR     13-Mar-1992	Added Nqs_dump for last chance.
*	V01.5	JRR	17-Jun-1992	Added header.
*	V01.6	JRR	11-Nov-1992	Added support for HPUX.
*	V01.7	JRR	05-Mar-1993	Added Boeing enhancement for files.
*	V01.8	JRR	28-Feb-1994	Added support for SOLARIS.
*	V01.9	JRR	30-Mar-1994	Ranking compute servers.
*/
/*++ nqsxdirs.h - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.36/h/RCS/nqsxdirs.h,v $
 *
 * DESCRIPTION:
 *
 *	NQS daemon external directory and file definitions.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	October 2, 1985.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.9 $ $Date: 1994/09/02 17:37:23 $ $State: Exp $)
 * $Log: nqsxdirs.h,v $
 * Revision 1.9  1994/09/02  17:37:23  jrroma
 * Version 3.36
 *
 * Revision 1.8  94/03/30  20:31:41  jrroma
 * Version 3.35.6
 * 
 * Revision 1.7  93/07/13  21:30:01  jrroma
 * Version 3.34
 * 
 * Revision 1.6  92/12/22  15:45:25  jrroma
 * Version 3.30
 * 
 * Revision 1.5  92/06/18  09:46:27  jrroma
 * Added gnu header
 * 
 * Revision 1.4  92/03/13  15:32:06  jrroma
 * Added Nqs_dump.
 * 
 * Revision 1.3  92/02/28  11:15:35  jrroma
 * Added Cosmic V2 changes.
 * 
 * Revision 1.2  92/01/17  12:41:32  jrroma
 * Added support for RS6000.
 * 
 * Revision 1.1  92/01/17  12:40:43  jrroma
 * Initial revision
 * 
 *
 */

#if	BSD43
#else
#if	HPUX | SGI | SOLARIS | SYS52 | IBMRS | ULTRIX | DECOSF | LINUX
extern char *Nqs_fifo;			/* NQS interprocess FIFO pipe */
					/* relative pathname */
extern char *Nqs_ffifo;			/* NQS interprocess FIFO pipe */
					/* full pathname */
#else
BAD SYSTEM TYPE
#endif
#endif
extern char *Nqs_requests;		/* NQS new request directory */
extern char *Nqs_root;			/* NQS root directory */
extern char *Nqs_scripts;		/* NQS shell script links directory */
extern char *Nqs_dump;			/* NQS dump directory if all else */
					/*   fails */
/*
 *	All of the following directories/files are relative to Nqs_root.
 */
extern char *Nqs_control;		/* NQS control directory */
extern char *Nqs_data;			/* NQS data directory */
extern char *Nqs_devices;		/* NQS device status file */
extern char *Nqs_forms;			/* NQS forms file */
extern char *Nqs_netqueues;		/* NQS network queue/status file */
extern char *Nqs_qcomplex;              /* NQS queue complex status file */
extern char *Nqs_queues;		/* NQS non-network queue/status file */
extern char *Nqs_qmaps;			/* NQS queue/device/destination file */
extern char *Nqs_pipeto;		/* NQS pipe destination queues */
extern char *Nqs_params;		/* NQS general parameters file */
extern char *Nqs_mgracct;		/* NQS manager account name file */
extern char *Nqs_servers;		/* NQS compute servers file */
extern char *Nqs_seqno;			/* NQS request seq# file */
extern char *Nqs_qaccess;		/* NQS queue access directory */
extern char *Nqs_qorder;		/* NQS queue ordering directory */
extern char *Nqs_failed;		/* NQS failed directory */
extern char *Nqs_inter;			/* NQS inter-process comm. dir. */
extern char *Nqs_output;		/* NQS temporary output file dir */
extern char *Nqs_transact;		/* NQS transaction directory */
extern char *Nqs_libdir;	       	/* NQS daemons directory env variable */
extern char *Nqs_nmapdir;		/* NQS map directory env variable */
extern char *Nqs_spooldir;		/* NQS spool directory env variable */
