/*
 * nqs_generic/all-systems/fmtgidname.c
 * Format a gid in a string.
 */

#include <nqs_generic/license.h>
  /* NQS license information */
#include <nqs_generic/debug.h>
  /* debugging support */
#include <nqs_db/nqs_db.h>
  /* /etc/group (or equivalent) support */

/*** fmtgidname
 *
 *	char *fmtgidname():
 *
 *	Return a pointer to the groupname of the group
 *	identified by the local group-id.
 */

char *fmtgidname (gid_t gid)
{
  static char szStandInBuf [17];
    /* Stand-in buffer */

  register char *szName;
    /* Pointer to name */
  register struct group *stGroup;
    /* Group entry */

  ENTER_FUNCTION("nqs_generic/all-systems/fmtgidname");
    /* debugging information */
  
  stGroup = fetchgrgid (gid);
    /* Get group entry */
  
  if (stGroup == NULL)
  {
    /*
     *  No such group!  Format a "stand-in" name.
     */
    sprintf (szStandInBuf, "[%1d]", (int) gid);
    szName = szStandInBuf;
  }
  else
    szName = stGroup->gr_name;
  
  EXIT_FUNCTION;
  return (szName);
}
