#ifndef __NQS_QUEUE_LIM_HEADER
#define __NQS_QUEUE_LIM_HEADER

/*
 * nqs_queue/all-systems/LIM.h
 * Flags for supported limits for Monsanto-NQS
 */

#include <nqs_generic/license.h>

/*
 *	NQS request quota limits and nice value defined flags.
 *	VALID_LIMITS, the constant that defines which of the following
 *	are meaningful on a given operating system, appears at
 *	the top of this file.
 */
#define LIM_PPCORE	0000001		/* Request per-process */
					/* core file size limit exists */
#define	LIM_PPDATA	0000002		/* Request per-process */
					/* data size limit exists */
#define	LIM_PPPFILE	0000004		/* Request per-process permanent */
					/* file size limit exists */
#define	LIM_PRPFILE	0000010		/* Request per-request permanent */
					/* file space quota limit exists */
#define	LIM_PPQFILE	0000020		/* Request per-process quick */
					/* file size limit exists */
#define	LIM_PRQFILE	0000040		/* Request per-request quick */
					/* file space quota limit exists */
#define	LIM_PPTFILE	0000100		/* Request per-process temporary */
					/* file size limit exists */
#define	LIM_PRTFILE	0000200		/* Request per-request temporary */
					/* file space quota limit exists */
#define	LIM_PPMEM	0000400		/* Request per-process */
					/* memory size limit exists */
#define	LIM_PRMEM	0001000		/* Request per-request */
					/* memory space quota limit exists */
#define LIM_PPSTACK	0002000		/* Request per-process */
					/* stack size limit exists */
#define	LIM_PPWORK	0004000		/* Request per-process */
					/* working set quota exists */
#define	LIM_PPCPUT	0010000		/* Request per-process */
					/* CPU time limit exists */
#define	LIM_PRCPUT	0020000		/* Request per-request */
					/* CPU time quota limit exists */
#define	LIM_PPNICE	0040000		/* Request per-process */
					/* nice value exists */
#define LIM_PRDRIVES	0100000		/* Request per-process */
					/* limit on tape drives exists */
#define LIM_PRNCPUS	0200000		/* Request per-process limit */
					/* on number of cpus exists */

#endif /* __NQS_QUEUE_LIM_HEADER */
