/*
 *	Network Queueing System (NQS)
 *  This version of NQS is Copyright (C) 1992  John Roman
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 1, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/*++ nqs_fndnnq.c - Network Queueing System
 *
 * $Source: /usr2/jrroma/nqs/nqs-3.35.6/src/RCS/nqs_fndnnq.c,v $
 *
 * DESCRIPTION:
 *
 *	Return pointer to queue structure for the named non-network
 *	queue.
 *
 *
 *	Author:
 *	-------
 *	Brent A. Kingsbury, Sterling Software Incorporated.
 *	January 23, 1986.
 *
 *
 * STANDARDS VIOLATIONS:
 *   None.
 *
 * REVISION HISTORY: ($Revision: 1.4 $ $Date: 1994/03/30 20:36:37 $ $State: Exp $)
 * $Log: nqs_fndnnq.c,v $
 * Revision 1.4  1994/03/30  20:36:37  jrroma
 * Version 3.35.6
 *
 * Revision 1.3  93/09/10  13:57:15  jrroma
 * Version 3.35
 * 
 * Revision 1.2  92/06/18  17:31:05  jrroma
 * Added gnu header
 * 
 * Revision 1.1  92/06/18  15:00:10  jrroma
 * Initial revision
 * 
 *
 */

#include "nqs.h"
#include "nqsxvars.h"		/* External variables */
#include <string.h>


/*** nqs_fndnnq
 *
 *
 *	struct nqsqueue *nqs_fndnnq():
 *
 *	Return pointer to queue structure for the named non-network
 *	queue.
 *
 *	Returns:
 *		A pointer to the queue structure for the named non-
 *		network queue, if the named non-network queue exists;
 *		otherwise (struct nqsqueue *)0 is returned.
 */
struct nqsqueue *nqs_fndnnq (char *quename)
{
	register struct nqsqueue *queue;
	register int res;

	/*
	 *  We take advantage of the fact that the non-network queue set
	 *  is lexicographically ordered.
	 */
	queue = Nonnet_queueset;
	while (queue != (struct nqsqueue *)0) {
		if ((res = strcmp (queue->q.namev.name, quename)) < 0) {
			/*
			 *  We have not yet found the queue, but we should
			 *  keep on searching.
			 */
			queue = queue->next;
		}
		else if (res == 0) return (queue);	/* Found! */
		else return ((struct nqsqueue *)0);	/* Not found */
	}
	return (queue);					/* Not found */
}
