#
#	Upper Buttons
#
proc make_group_menu  {} {
    global tk_version

    msg_Make "Making group cascading menus"
    update
    grp_menu
    if {$tk_version >= 4.0} {
	.top.m.menu delete 1
    } else {
	.top.m.menu delete 0
    }
    destroy .msg
}

proc mksedit {} {
    Sedit_Pref
#    exmh_bind_e
    wm minsize .seditpref 0 0
#   Sedit_Pref clears entry Class bindings
    bind .seditpref <Unmap> {after 1000 setup_bindings}
}

proc mksedit_compose {} {
    Sedit_ComposeUI
    wm minsize .compose 0 0
}

proc menu_sedit {} {
    Preferences_Dialog
    .pref.but.save configure -command nn_PreferencesSave
}

proc do_uri {} {
    if {[catch {Uri_ScanMsg .more.t}] != 0} {
	URI_ScanMsg .more.t
    }
}

proc top_buttons {} {
    global token Config has_exmh
    frame .top -borderwidth 2  -relief ridge
    
    menubutton .top.m -text "Groups" -menu .top.m.menu -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.m.menu
    if {!$Config(mk_group_menu)} {
	.top.m.menu add command -label "Setup Groups menu" \
	    -command "make_group_menu"
    }
    
    menubutton .top.a -text "article" -menu .top.a.art -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.a.art
    .top.a.art add command -label "Post news" \
        -command "put_extended {post}"
    .top.a.art  add command -label "Followup news" \
	-command "put_extended {follow}"
    .top.a.art add separator
    .top.a.art  add command -label "Mail article" \
	-command "put_extended {mail}"
    .top.a.art  add command -label "Mail reply" \
	-command "put_extended {reply}"
    .top.a.art add separator
    .top.a.art add cascade -label "Process articles" -menu .top.a.art.a
    menu .top.a.art.a 
    .top.a.art.a  add command -label "Turn URLs into Buttons" \
	-command do_uri
    .top.a.art.a  add command -label "Treat selection as URL" \
	-command URI_OpenSelection
    .top.a.art.a  add command -label "View using PGP" \
	-command "put_extended {pgp}"
    .top.a.art.a add separator
    .top.a.art.a  add command -label "decode" \
	-command "put_extended {decode}"
    .top.a.art.a  add command -label "patch" \
	-command "put_extended {patch}"
    .top.a.art.a  add command -label "print" \
	-command "put_extended {print}"
    .top.a.art.a  add command -label "unshar" \
	-command "put_extended {unshar}"
     .top.a.art add cascade -label "Save articles" -menu .top.a.art.s
    menu .top.a.art.s
    .top.a.art.s  add command -label "save-body" \
	-command "put_extended {save-body}"
    .top.a.art.s  add command -label "save-short" \
	-command "put_extended {save-short}"
    .top.a.art.s  add command -label "save-full" \
	-command "put_extended {save-full}"
    .top.a.art add cascade -label "misc" \
	-menu .top.a.art.m
    menu .top.a.art.m
    .top.a.art.m add command -label "full headers" \
	-command "put_extended {page=0}"
    .top.a.art.m add separator
    .top.a.art.m add command -label "leave-next" \
	-command "put_extended {leave-next}"
    .top.a.art.m add command -label "leave-article" \
	-command "put_extended {leave-article}"
    .top.a.art.m add separator
    .top.a.art.m add command -label "rot13" \
	-command "put_extended {rot13}"
    .top.a.art.m add command -label "compress" \
	-command "put_extended {compress}"
    .top.a.art.m add command -label "full-digest" \
	-command "put_extended {full-digest}"
    
    menubutton .top.f -text "functs" -menu .top.f.func -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.f.func
    .top.f.func add command -label "reload groups" \
	-command "put_extended {reload} m"
    .top.f.func add cascade -label "make window" -menu .top.f.func.w
    menu .top.f.func.w
    .top.f.func.w add command -label "group list" \
	-command "list_Make .groups grp_list"
    .top.f.func.w add command -label "folder list" \
	-command "list_Make .folders folder_list"
    .top.f.func add command -label "define Kill/Select" \
	-command "put_extended {kill-select}"
    .top.f.func add command -label "cancel articles" \
	-command "put_extended {cancel}"
    .top.f.func add command -label "unsubscribe group" \
	-command "put_extended {unsub}"
    .top.f.func add separator
    .top.f.func add command -label "previous message" \
	-command "put_funct $token(K_LAST_MESSAGE)"
    
    menubutton .top.o -text "menu" -menu .top.o.others -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.o.others
    .top.o.others add cascade -label "sort type" -menu .top.o.others.s
    menu .top.o.others.s
    .top.o.others.s add command -label "Sort: arrival" \
	-command "put_extended {sort arrival}"
    .top.o.others.s add command -label "Sort: subject" \
	-command "put_extended {sort subject}"
    .top.o.others.s add command -label "Sort: lexical" \
	-command "put_extended {sort lexical}"
    .top.o.others.s add command -label "Sort: age" \
	-command "put_extended {sort age}"
    .top.o.others.s add command -label "Sort: sender" \
	-command "put_extended {sort sender}"
    .top.o.others add cascade -label "consolidate menu" \
	-menu .top.o.others.c
    menu .top.o.others.c
    .top.o.others.c add command -label "Menu: consolidate" \
	-command "put_extended {set consolidated-menu on}"
    .top.o.others.c add command -label "Menu: unconsolidate" \
	-command "put_extended {set consolidated-menu off}"
    .top.o.others add cascade -label "menu mode" -menu .top.o.others.m
    menu .top.o.others.m
    .top.o.others.m add command -label "select regexp" \
	-command "put_extended {find}"
    .top.o.others.m add command -label "select-auto" \
	-command "put_extended {select-auto}"
    .top.o.others.m add command -label "select-invert" \
	-command "put_extended {select-invert}"
    .top.o.others.m add command -label "select-range" \
	-command "put_extended {select-range}"
    .top.o.others.m add command -label "unselect-all" \
	-command "put_extended {unselect-all}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "first page" \
	-command "put_extended {page=1}"
    .top.o.others.m add command -label "last page" \
	-command "put_extended {page=$}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "open-subject" \
	-command "put_extended {open-subject}"
    .top.o.others.m add command -label "close-subject" \
	-command "put_extended {close-subject}"
    .top.o.others.m add separator
    .top.o.others.m add command -label "continue-no-mark" \
	-command "put_extended {continue-no-mark}"
    .top.o.others.m add command -label "read-return" \
	-command "put_extended {read-return}"
    .top.o.others.m add command -label "unread" \
	-command "put_extended {unread}"
    .top.o.others add cascade -label "menu misc" -menu .top.o.others.ms
    menu .top.o.others.ms
    .top.o.others.ms add command -label "pwd" \
	-command "put_extended {pwd}"
    .top.o.others.ms add command -label "cd" \
	-command "put_extended {cd}"
    .top.o.others.ms add command -label "mkdir" \
	-command "put_extended {mkdir}"
    .top.o.others.ms add separator
    .top.o.others.ms add command -label "rmail" \
	-command "put_extended {rmail}"
    .top.o.others.ms add command -label "motd" \
	-command "put_extended {motd}"
    
    menubutton .top.help -text "Info"  -menu .top.help.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.help.m
    .top.help.m add cascade -label "nn-tk Help" -menu .top.help.m.n
    menu .top.help.m.n
    .top.help.m.n add command -label "description" \
	-command "put_extended {help nn-tk}"
    .top.help.m.n add command -label "main window" \
	-command "put_extended {help nn-tk-main}"
    .top.help.m.n add command -label "TK-bindings" \
	-command "put_extended {help tk-bindings}"
    .top.help.m.n add command -label "options" \
	-command "put_extended {help options}"
    .top.help.m add cascade -label "nn Help" -menu .top.help.m.h
    menu .top.help.m.h
    .top.help.m.h add command -label "Help" -command "put_extended {help}"
    .top.help.m.h add command -label "attr" \
	-command "put_extended {help attr}"
    .top.help.m.h add command -label "commands" \
	-command "put_extended {help commands}"
    .top.help.m.h add command -label "extended" \
	-command "put_extended {help extended}"
    .top.help.m.h add command -label "map" -command "put_extended {help map}"
    .top.help.m.h add command -label "menu mode" \
	-command "put_extended {help menu}"
    .top.help.m.h add command -label "more mode" \
	-command "put_extended {help more}"
    .top.help.m.h add command -label "set variable" -command "put_extended {help set}"
    .top.help.m.h add command -label "show variable" \
	-command "put_extended {help show}"
    .top.help.m.h add command -label "sort" \
	-command "put_extended {help sort}"
    .top.help.m.h add command -label "variables" \
	-command "put_extended {help variables}"
    .top.help.m.h add command -label "nntp" \
	-command "put_extended {help nntp}"
    .top.help.m add separator
    .top.help.m add cascade -label "show info" -menu .top.help.m.sh
    menu .top.help.m.sh
    .top.help.m.sh add command -label "set" \
	-command "put_extended {set}"
    .top.help.m.sh add command -label "set all" \
	-command "put_extended {set all}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "kill" \
	-command "put_extended {show kill}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "groups" \
	-command "put_extended {show groups}"
    .top.help.m.sh add command -label "groups all" \
	-command "put_extended {show groups all}"
    .top.help.m.sh add command -label "groups subscr" \
	-command "put_extended {show groups subscr}"
    .top.help.m.sh add command -label "groups total" \
	-command "put_extended {show groups total}"
    .top.help.m.sh add command -label "groups unsub" \
	-command "put_extended {show groups unsub}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "map" \
	-command "put_extended {show map}"
    .top.help.m.sh add command -label "map key" \
	-command "put_extended {show map key}"
    .top.help.m.sh add command -label "map menu" \
	-command "put_extended {show map menu}"
    .top.help.m.sh add command -label "map show" \
	-command "put_extended {show map show}"
    .top.help.m.sh add command -label "map #" \
	-command "put_extended {show map #}"
    .top.help.m.sh add separator
    .top.help.m.sh add command -label "rc" \
	-command "put_extended {show rc}"
    if {[info procs Sedit_ComposeUI] != ""} {
	.top.help.m add command -label "Compose key sequences" \
	    -command "mksedit_compose"
    } else {
	.top.help.m add command -label "Edit Character compose" \
	    -command "mksedit_compose" -state disabled
    }
    .top.help.m add separator
    .top.help.m add command -label "Man" -command "put_extended {man}"
    
    menubutton .top.macro -text "USER"  -menu .top.macro.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.macro.m
    userc_menu .top.macro.m
    
    menubutton .top.option -text "Setup" -menu .top.option.m -bd 1 \
	-relief raised -padx 5 -pady 3
    menu .top.option.m
    .top.option.m add command -label "Save Window geometry" \
	-command "config_save_geom"
    .top.option.m add separator
    if { $has_exmh} {
	.top.option.m add command -label "Key bindings" \
	    -command "mksedit"
	.top.option.m add command -label "Exmh options" \
	    -command "menu_sedit"
    } else {
	.top.option.m add command -label "Key bindings" \
	    -command "mksedit" -state disabled
	.top.option.m add command -label "Exmh options" \
	    -command "Preferences_Dialog" -state disabled
    }	
    .top.option.m add separator
    .top.option.m add command -label "NN-TK General" -command {opt_Make var_misc options {options_fill var_misc $var_misc} "NN-TK general options"}
    .top.option.m add command -label "NN-TK Group List" -command {opt_Make var_group options {options_fill var_group $var_group} "NN-TK group list options"}
    .top.option.m add command -label "NN-TK Group Cascade Menu" -command {opt_Make var_cascade options {options_fill var_cascade $var_cascade} "NN-TK group menu options"}
    .top.option.m add separator
    .top.option.m add command -label "USER Command Menu" \
	-command "userc_Make"
    .top.option.m add separator
    .top.option.m add command -label "NN Variables (modified)" \
	-command "variables_Make 0"
    .top.option.m add command -label "NN Variables (all)" \
	-command "variables_Make 1"
    
    button .top.qu -text "quit"  -command "put_funct \{$token(K_QUIT)\} m" \
	-width 8 -padx 0 -pady 2
    
    pack  .top.m  .top.a .top.o .top.f .top.macro \
	.top.help .top.option  .top.qu -side left -padx 8 -pady 2
}

proc middle_buttons {} {
    global token

    if {[winfo exists .middle]} {
	destroy .middle
    }
    frame .middle -borderwidth 2  -relief ridge
    button .middle.pg -text "prev G"  \
	-command "put_funct $token(K_PREVIOUS) m" -width 8 -padx 0 -pady 2	
    button .middle.ps -text " < "  \
	-command "put_funct $token(K_PREV_PAGE) m" -width 3 -padx 0 -pady 2
    button .middle.bmenu -text "="  \
	-command "put_funct $token(K_BACK_TO_MENU)" -width 3 -padx 0 -pady 2
    button .middle.ns -text " > "  \
	-command "put_funct $token(K_NEXT_PAGE) m" -width 3 -padx 0 -pady 2
    button .middle.nread -text "read/skip"  \
	-command "put_funct $token(K_READ_GROUP_UPDATE)" -width 10 -padx 0 -pady 2
    button .middle.ng -text "next G"  \
	-command "put_funct $token(K_NEXT_GROUP_NO_UPDATE) m" -width 8 -padx 0 -pady 2
    button .middle.page -text "PAGE"  \
	-command "put_funct $token(K_CONTINUE)" -width 14 -padx 0 -pady 2
    
    pack .middle.pg  .middle.ps  .middle.bmenu .middle.ns  .middle.nread  \
	.middle.ng .middle.page -side left -padx 8 -pady 2
}

#
#	Article menu
#

proc choose {scr x y} {
    global ev_input EV_SELECT
    global chp
    set p [$scr index @$x,$y]
    scan $p %d.%d yc dd
    #	puts stderr "$yc $chp"
    if {$yc != $chp} {
	ev_type_menu
	if {$yc > $chp} {
	    set n 1 
	} else {
	    set n -1
	}
	set ychk [expr $yc+$n]
	for {set i [expr $chp+$n]} {$i != $ychk} {incr i $n} {
	    set c [format "%c" [expr $i+96] ]
	    rec_c $EV_SELECT $c
	}
	set chp $yc
    }
}

proc choose-s {scr x y funct} {
    global ev_input ev_type 
    global chp
    set p [$scr index @$x,$y]
    scan $p %d.%d yc dd
    #	puts stderr "$yc $chp"
    set c [format "%c" [expr $yc+96] ]
    ev_type_menu 
    rec_c $funct $c
    set chp $yc
}

proc menu_resize {l} {
    .menu-article configure -height $l
}

proc clear_menu {} {
    .menu-article delete 0.0 end
}

proc clear_partial_menu {l} {
    .menu-article delete $l.0 end
}

proc menu_mark {y} {
    global tk_version

    .menu-article tag remove mark 0.0 end
    if {$tk_version >= 4.0} {
	.menu-article tag remove select $y.0 [expr $y+1].0
	.menu-article tag add mark $y.0 [expr $y+1].0
    } else {
	.menu-article tag remove select $y.0 $y.999
	.menu-article tag add mark $y.0 $y.999
    }
}

proc menu_inverse {y} {
    global tk_version

    if {$tk_version >= 4.0} {
	.menu-article tag add select $y.0 [expr $y+1].0
    } else {
	.menu-article tag add select $y.0 $y.999
    }
}

proc menu_under {y} {
    global tk_version

    if {$tk_version >= 4.0} {
	.menu-article tag add under $y.0 [expr $y+1].0
    } else {
	.menu-article tag add under $y.0 $y.999
    }
}

proc menu_p_inverse {y xs xf} {
    global tk_version

    if {$tk_version >= 4.0} {
	.menu-article tag add select $y.0 [expr $y+1].0
    } else {
	.menu-article tag add select $y.$xs $y.$xf
    }
}

proc menu_normal {y} {
    global tk_version

    if {$tk_version >= 4.0} {
	.menu-article tag remove select $y.0 [expr $y+1].0
	.menu-article tag remove under $y.0 [expr $y+1].0
    } else {
	.menu-article tag remove select $y.0 $y.999
	.menu-article tag remove under $y.0 $y.999
    }
}

proc menu_ent { yp xp} {
    global tk_version menu_ent_t 
    set end [.menu-article index end]

    scan $end %d.%d yl dd
    if {$tk_version >= 4.0} {
	incr yl -1
    }
    if {$yp > $yl} {
	.menu-article insert $end "\n"
    }
    .menu-article delete $yp.0 "$yp.0 lineend"
    .menu-article insert $yp.0 $menu_ent_t
    .menu-article tag remove fix $yp.0 "$yp.0 lineend"
    .menu-article tag add fix $yp.0 $yp.$xp
    .menu-article tag add indx $yp.0 $yp.2
}

proc set_read_mode {{c " "}} {
    global read_mode
    set read_mode $c
}

# changes the state of buttons dependent on menu or article modes
proc set_menu_mode {c} {
    global menu_mode has_exmh
    global tk_version

    set menu_mode $c

    if {$menu_mode == "m"} {
	button_mode .middle.bmenu disabled
	button_mode .bottom.bns disabled
	button_mode .bottom.bp disabled
	button_mode .bottom.next disabled
	.middle.nread configure -text "read/skip"
	if {$tk_version >= 4.0} {
	    .top.a.art  entryconfigure 8 -state disabled
	    .top.a.art.a entryconfigure 1 -state disabled
	    .top.a.art.a entryconfigure 2 -state disabled
	    .top.a.art.a entryconfigure 3 -state disabled
	    .top.o.others entryconfigure 2 -state   normal
	    .top.o.others entryconfigure 3 -state  normal
	}  else {
	    .top.a.art  entryconfigure 7 -state disabled
	    .top.a.art.a entryconfigure 0 -state disabled
	    .top.a.art.a entryconfigure 1 -state disabled
	    .top.a.art.a entryconfigure 2 -state disabled
	    .top.o.others entryconfigure 1 -state   normal
	    .top.o.others entryconfigure 2 -state  normal
	}	
    } else {
	button_mode .middle.bmenu normal
	button_mode .bottom.bns normal
	button_mode .bottom.bp normal
	button_mode .bottom.next normal
	.middle.nread configure -text "skip G"
	if {$tk_version >= 4.0} {
	    .top.a.art entryconfigure 8 -state  normal
	    if {$has_exmh} {
		.top.a.art.a entryconfigure 1 -state normal
		.top.a.art.a entryconfigure 2 -state normal
		.top.a.art.a entryconfigure 3 -state normal
	    }
	    .top.o.others entryconfigure 2 -state  disabled
	    .top.o.others entryconfigure 3 -state  disabled
	}  else {
	    .top.a.art entryconfigure 7 -state  normal
	    if {$has_exmh} {
		.top.a.art.a entryconfigure 0 -state normal
		.top.a.art.a entryconfigure 1 -state normal
		.top.a.art.a entryconfigure 2 -state normal
	    }
	    .top.o.others entryconfigure 1 -state  disabled
	    .top.o.others entryconfigure 2 -state  disabled
	}
    }
}

proc menu_Make {} {
    global tk_version color_bd color_bs color_w monochrome EV_SELECT EV_SELECT_C

    text .menu-article -relief raised -bd 2  -setgrid true \
	-cursor left_ptr -width 80\
	-wrap none
    if {$tk_version >= 4.0} {
	bind .menu-article <B1-Motion> "choose .menu-article %x %y; break"
	bind .menu-article <Button-1> "choose-s .menu-article %x %y $EV_SELECT; break"
	bind .menu-article <Button-3> "choose-s .menu-article %x %y $EV_SELECT_C; break"
	bindtags .menu-article {.menu-article Text . all}
    } else {
	bind .menu-article <B1-Motion> "choose .menu-article %x %y"
	bind .menu-article <Button-1> "choose-s .menu-article %x %y $EV_SELECT"
	bind .menu-article <Button-3> "choose-s .menu-article %x %y $EV_SELECT_C"
    }
	
    text_bindings .menu-article 

    .menu-article tag configure fix -font [option get .menu-article fixed_font {} ]

    .menu-article tag configure indx  -relief raised -borderwidth 2 -background\
	$color_bd -font [option get .menu-article label_font {} ] 
    if {$monochrome == 1} {
	.menu-article tag configure select -background black -foreground white 
	.menu-article tag configure mark -bgstipple gray25 -background black
    } else {
	.menu-article tag configure select -background  $color_bs -relief raised -borderwidth 1
	.menu-article tag configure mark -background  $color_bd -relief raised -borderwidth 1
    }
    .menu-article tag configure under -underline 1

    text .menu-g -relief raised -bd 2 -setgrid true \
	-height 1 \
    	-font [option get .menu-article prompt_font {} ]
    text .menu-prompt -relief raised -bd 2 -setgrid true \
	-height 1 \
    	-font [option get .menu-article prompt_font {} ]
    .menu-article tag raise indx
}

#
#	Article display
#
proc more_all {state} {
    button_mode .bottom.all $state
}

proc more_end {} {
    set end [.more.t index end]
    scan $end %d.%d yl dd
    .more.t yview [expr $yl-12]
}

proc more_font {} {
    global Config
    global tk_version

    #	packer strangeness
    scan [.menu-article configure -height] "-height height Height %d %d" x ht

    if {$Config(mono_font)} {
	.more.t configure -font [option get .more fix_font {} ]
    } else {
	.more.t configure -font [option get .more  var_font {} ]
    }
    if {$tk_version < 4.0} {
	menu_resize $ht
    }
}

proc more_b {} {
    global more_l_t
    .more.t insert end $more_l_t
    .more.t tag add bold "end linestart" "end -2 chars"
}

proc more_l {} {
    global more_l_t
    .more.t insert end $more_l_t
}

proc more_clear {} {
    global more_pos str_old more_extended

    if {[lindex [.more.t configure -state] 4] == "disabled"} {
	clear_mime
    }
    set more_pos 1
    .more.t delete 0.0 end
    set str_old ""
    set more_extended 0
}

#               return 1 if not at the end in article display
proc page {} {
    global tk_version more_extended

    set t [.more.sv get]
    if {$tk_version >= 4.0} {
#      compensate for the fact that the bottom line
#      nolonger scrolls past the bottom of the window
	scan $t "%f %f" first last
	set lines [.more.t index end]
	set page [expr ($last-$first)*$lines]
	set remain [expr (1-$last)*$lines+2]
#	puts "lines=$lines page=$page remain=$remain"
	if {!$more_extended && ($page > $remain)} {
	    set pad [expr int($page-$remain)]
#	    puts "pad=$pad"
	    .more.t insert end [string range "\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n" 1 $pad]
	    set more_extended $pad
	}
	if {$last >= 1.0} {
	    return 0
	} else {
	    .more.t yview scroll 1 pages
	    return 1
	}
    } else {
	scan $t "%d %d %d %d" total win first last
	#	puts "$total $win $first $last"
	set first [expr $first+$win-1]
	if {[expr $first+1] >= $total} {
	    return 0
	} else {
	    .more.t yview $first
	    return 1
	}
    }
}

#              Next article or group
proc do_next {} {
    global token
    put_funct $token(K_NEXT_ARTICLE)
}

#              Prev article or group
proc do_prev {} {
    global token
    put_funct $token(K_BACK_ARTICLE)
}

proc more-search {} {
    global more_pos str_old tk_version
    set t [.more.sv get]
    if {$tk_version >= 4.0} {
	scan $t "%f %f" f l
	set lines [.more.t index end]
	set first [expr round($f*$lines)]
	set last [expr round($l*$lines)]
	set win [expr round(($l-$f)*$lines)]
    } else {
	scan $t "%d %d %d %d" total win first last
    }
    set str [.bottom.search.txt get]
    if {$str_old != $str} {
	.more.t tag remove inv 0.0 end
	set str_old $str
	set more_pos $first
    }

    if {$more_pos < $first || $more_pos > [expr $last+1]} {
	set more_pos  [expr $first]
    }

    .more.t tag configure inv -underline 1
    scan [.more.t index end] %d nl
    set ln [string length $str]
    set str [string tolower $str]

    set first_match 1
    set bound $nl
    set found 0
    for {set i $more_pos} {$i <= $nl} {incr i} {
	set line [string tolower [.more.t get $i.0 $i.1000]]

	if {[set n [string first $str $line]] != -1} {
	    set offset 0
	    set found 1

	    while {$n >= 0} {
	        .more.t tag add inv $i.[expr $n+$offset] $i.[expr $n+$ln+$offset]
		set offset [expr $n+$ln+$offset]
		set n [string first $str [string range $line $offset 1000]]
	        if {$first_match} {
		    .more.t yview  [expr $i-4]
		    set bound [expr $i+$win-4]
		    set first_match 0
	        }
	    }
	}
    	if {$i >= $bound} {
	    set more_pos  $i
	    break
        }
    }
    if {!$found} {
	msg_Make "String not found"
	after 5000 {catch {destroy .msg}}
    }
}

proc more-search-b {} {
    global more_pos str_old tk_version
    set t [.more.sv get]
    if {$tk_version >= 4.0} {
	scan $t "%f %f" f l
	set lines [.more.t index end]
	set first [expr round($f*$lines)]
	set last [expr round($l*$lines)]
	set win [expr round(($l-$f)*$lines)]
    } else {
	scan $t "%d %d %d %d" total win first last
    }
    set str [.bottom.search.txt get]
    if {$str_old != $str} {
	.more.t tag remove inv 0.0 end
	set str_old $str
        set more_pos $last
    }
    if {[expr $more_pos-1] < $first || $more_pos > $last} {
        set more_pos  [expr $first]
    }

    .more.t tag configure inv -underline 1
    scan [.more.t index end] %d nl
    set ln [string length $str]
    set str [string tolower $str]

    set first_match 1
    set bound 0
    set found 0
    for {set i $more_pos} {$i > 0} {set i [expr $i-1]} {
	set line [string tolower [.more.t get $i.0 $i.1000]]

	if {[set n [string first $str $line]] != -1} {
	    set offset 0
	    set found 1
	    while {$n >= 0} {
	        .more.t tag add inv $i.[expr $n+$offset] $i.[expr $n+$ln+$offset]
	        set offset [expr $n+$ln+$offset]
	        set n [string first $str [string range $line $offset 1000]]
                if {$first_match} {
                    .more.t yview  [expr $i-$win+3]
                    set bound [expr $i-$win+3]
                    set first_match 0
                }
	    }
	}
    	if {$i <= $bound} {
	    set more_pos $i
	    break
    	}
    }
    if {!$found} {
	msg_Make "String not found"
	after 5000 {catch {destroy .msg}}
    }
}

proc more-srch {} {
    frame .bottom.search
    button .bottom.search.bt -text "/" -command "more-search" -bd 2 \
	-relief raised  -padx 0 -pady 2
    button .bottom.search.bf -text "\\" -command "more-search-b" -bd 2 \
	-relief raised -padx 0 -pady 2
    entry .bottom.search.txt -relief sunken -width 15
    pack .bottom.search.bt .bottom.search.txt  .bottom.search.bf -side left
    bind .bottom.search.txt <Return> "more-search"
}

proc bottom_buttons {} {
    global tk_version mono_font token
    
    frame .bottom -borderwidth 2  -relief ridge
    checkbutton .bottom.font -variable Config(mono_font) -text "Mono" \
	-command "more_font"  -bd 2 -relief raised -width 7
    if {$tk_version >= 4.0} {
	.bottom.font configure  -pady 4
    }
    button .bottom.bns -text "n-subj"  \
	-command "put_funct $token(K_NEXT_SUBJECT)" \
	-width 7 -padx 0 -pady 2
    button .bottom.all -text "All"  \
	-command "do_more_lines" -width 5 -state disabled -padx 0 -pady 2
    button .bottom.bp -text "prev"  -command "do_prev" -width 7 -padx 0 -pady 2
    button .bottom.next -text "next"  -command "do_next" -width 7 -padx 0 -pady 2
    button .bottom.page -text "PAGE"  -command "put_funct $token(K_CONTINUE)" -width 10 -padx 0 -pady 2
    more-srch
    
    pack .bottom.search -side left -padx 10
    pack .bottom.all  .bottom.font .bottom.bns  .bottom.bp .bottom.next \
	.bottom.page -side left -padx 8 -pady 2
}

proc do_more_lines {} {
    global token
    more_lines 100000
    put_funct $token(K_REDRAW)
}

proc more_ff {} {
    .more.t insert end "\n\n"
    .more.t tag add ff  "end - 2 chars" "end - 1 chars"
}

proc more_Make {} {
    global tk_version color_w Config has_exmh

    frame .more
    if {$Config(mono_font)} {
	set font [option get .more fix_font {} ]	
    } else {
	set font [option get .more var_font {} ]	
    }

    if {$has_exmh} {
	Widget_Text .more 1 -relief raised -bd 2  \
	    -font $font -wrap none 
    } else {
        text .more.t -relief raised -bd 2 -yscrollcommand ".more.sv set" \
	    -setgrid true -setgrid 1 \
	    -font $font \
	    -height 1 -wrap none -cursor left_ptr
	pack  .more.t -side left -expand yes -fill both
	scrollbar .more.sv -relief flat -command ".more.t yview"
	
	pack .more.sv -side left -fill y
    }
    text_bindings .more.t

    more_tags

}

proc more_tags {} {
    global color_bd
    .more.t tag configure bold -font [option get .more bold_font {} ]
    .more.t tag configure ff  -relief raised -borderwidth 2 -background\
	$color_bd
}

proc main_Make {} {
    global Config

    top_buttons
    middle_buttons
    bottom_buttons

    menu_Make
    more_Make

    pack  .top -side top 
    pack  .menu-g .menu-article .menu-prompt -side top -fill x
    pack  .more -side top -expand yes -fill both
    pack  .bottom -side top

    if {$Config(middle_button_pos) == 0} {
	pack  .middle -side top -after .top
    } elseif {$Config(middle_button_pos) == 1} {
	pack  .middle -side top -after .menu-prompt
    } else {
	pack  .middle -side top -after .more
    }
}

