.ND

\&\einput texinfo    
.ds St mgetty\ +\ sendfax
.OH '\\*(St''%'
.EH '%''\\*(St'
.PP
.PP
.PP
.sp 6
.ce
.ps +10
.ce
mgetty+sendfax
.ps -10
.sp 4
.ce
Version\ 0.22
.sp 1
.ce
November\ 1994
.sp 5
.ce
Gert\ Doering
.ce
gert@greenie.muc.de
.ce
gdoering@physik.tu-muenchen.de
.PP
.bp
.PP
.PP
.PP
.PP
.PP
.PP
.bp
.NH
Introduction
.br
.PP
\&\fBmgetty\fR allows you to use a class 2 or 2.0 fax modem for receiving
faxes and handling external logins without interfering with outgoing calls.
\&\fBsendfax\fR is a standalone program which sends fax files.  This
manual explains how to configure and install the package and offers some
hints on handling faxes.
.PP
.PP
.NH 2
Copying\ conditions\ and\ (lack\ of)\ warranty
.br
.PP
\&\fBWARNING:\fR This package is still BETA software. Use it at your own
risk, there is \fBno\fR warranty. If it erases all the data on your hard
disk, damages your hardware, or kills your dog, that is entirely your
problem. Anyway, the program works for me and quite a lot of other people.
.PP
The \fBmgetty+sendfax\fR package is Copyright \(co 1993,1994 Gert
Doering.
.PP
You are permitted to redistribute \fBmgetty+sendfax\fR freely, modify it,
include it in other programs, \&..., as long as you don't make profit
directly out of selling \fBmgetty\fR (see below), include the complete
\&\fBmgetty\fR source, and do not remove my name. If you distribute a
modified version, or include \fBmgetty\fR code in your projects, mark it
clearly as such (``\&... \fIderived\fR from \fBmgetty+sendfax\fR by
Gert Doering'')!
.PP
If the program works for you, and you want to honour my efforts, you are
invited to donate as much as you want\&...
.PP
What I mean above with ``as long as you don't make profit directly out of
selling \fBmgetty\fR'' is: it is perfectly OK if you get paid for
\&\fBmgetty\fR support, or if you distribute \fBmgetty\fR among other
goodies on a CD-ROM collection or whatever, but if you sell \fBmgetty\fR
bundled with a faxmodem as ``unix fax package'' or ``with unix software!'',
or if you start selling \fBmgetty\fR with only minor enhancements for lots
of money, I want a share. If in doubt, just ask me.
.PP
In any case, if you don't like the restrictions in this license, contact
me, and we can work something out.
.PP
This license expires, that is, two years after release date, a given
\&\fBmgetty+sendfax\fR release falls into the public domain, and everybody
is absolutely free to do with the code what he wants.
.PP
.NH 2
Features\ of\ \fBmgetty\fR\ and\ \fBsendfax\fR
.br
.PP
This package contains two major programs, \fBmgetty\fR and
\&\fBsendfax\fR.
.PP
This is what you can do with \fBsendfax\fR if you have a standard
class 2 fax modem:
.PP
.IP \(bu\ 
send faxes directly or using shell scripts
.IP
.IP \(bu\ 
do ``fax polling'', this means you can call the weather station and
get them to send you a fax containing the current weather map. (Not all
modem manufacturers implement this feature in their modems!)
.IP
.IP \(bu\ 
create a ``fax queue'', outgoing faxes get sent automatically, the
user is informed by mail about the result.
.PP
\&\fBmgetty\fR allows you to use a single modem line for receiving
calls and dialing out.
.PP
.IP
.IP \(bu\ 
\&\fBmgetty\fR knows about ``smart'' modems, and will make sure that the
modem is always in a defined state (specific modem initialization possible)
.IP
.IP \(bu\ 
Incoming calls are answered manually (\fBRING\fR
-> \fBATA\fR -> \fBCONNECT\fR) instead of using auto-answer
(\f(CW\`ATS0=1\'\fR), this way the modem won't pick up the phone when the
machine is down or logins are not allowed. 
.IP
.IP \(bu\ 
\&\fBmgetty\fR incorporates all features of uugetty: it honours \f(CW\`LCK.*\'\fR
files created by \fBuucico\fR and other comm programs, this way it will
prevent dial-outs while a caller is online and it won't be confused if
other programs use the modem.
.IP
.IP \(bu\ 
\&\fBmgetty\fR can receive faxes (if your modem supports fax class 2 or 2.0).
.IP
.IP \(bu\ 
\&\fBmgetty\fR knows about incoming FidoNet calls.
.IP
.IP \(bu\ 
\&\fBmgetty\fR has extensive logging / debugging features
.IP
.IP \(bu\ 
do ``fax poll sending'', that is, you can setup your machine as fax poll
server, to send some fax pages to ``fax poll'' callers. (Send informations
about your system, the current wheather map, ...). Be warned, even less
modems support this feature.
.IP
.IP \(bu\ 
\&\fBmgetty\fR can selectively refuse calls based upon CallerID, if your
modem supports it, and you're subscribed to the service.
CallerID is also logged.
.IP
.IP \(bu\ 
\&\fBmgetty\fR has facilities to allow you to refuse incoming FAXes when
available disk space is low.
.IP
.PP
If you have any bug reports, suggestions, (critics will be shot!),
please report them to gert@greenie.muc.de (Attention! Do not use my
old mail address ``gert@greenie.gold.sub.org''---it doesn't work any
longer).
.PP
Also, I have created a mgetty mailing list, for discussion of problems
and suggestions. You can subscribe by sending a request to
mgetty-request@muc.de (give me some time---I'm doing this manually),
and you can send articles to the list by sending them to mgetty@muc.de.
Please make sure that the mail address you send me is valid - I'm quite
sick of getting all list mails bounced back to me because one of the
addresses doesn't work.
.PP
If you are located in the US, to avoid intercontinental traffic, you can
subscribe at yggdrasil.com, send a mail to listserv@yggdrasil.com with
.DS
.ft CW
subscribe mgetty-developers <your-mail-address>
.DE
.ft R
in it. (The address to send articles to still is mgetty@muc.de!)
.PP
.NH 2
Supported\ systems\ and\ modems
.br
.PP
Mgetty has been successfully installed and run on the following
systems:
.PP
.DS
    SCO Unix 3.2.1 (ODT 1.0)                    (well tested)
    SCO Unix 3.2.4 (ODT 2.0 + 3.0)              (very well tested)
    Linux 0.99pl1 .. 1.1pl52                     (very well tested)
    ISC Unix 3.0                                (tested)
    SVR4 Unix                                   (well tested)
    SVR4.2 Unix                               (needs more testing)
    AT&T 3B1 3.51m                              (well tested)
    HP-UX 8.x                                   (well tested)
    AIX                                         (well tested)
    SunOS                                       (works quite well)
    NetBSD / FreeBSD                          (well tested)
.DE
.PP
It should be possible to run mgetty on any other Unix with \f(CW\`termio.h\'\fR
or \f(CW\`termios.h\'\fR. For best results, \fBselect(S)\fR or \fBpoll(S)\fR
are recommended, but there's a workaround. (Warning: for Unix SVR3.1 or
earlier, \fIdo not use poll()\fR, it will not work on tty devices.)
.PP
.PP
Up to now, it has been successfully used with the following modems (no
exhaustive list) in fax mode:
.PP
.DS
    ZyXEL U1496 (various ROM releases)
        (very well tested, a couple of problems remain, depending on the
         ROM release)
\&\&
    SupraFAX v32bis
        (tested, works well, no fax polling available)
\&\&
    GVC FM144/+
	(tested, works well, no fax polling available)
\&\&
    TKR DM-24VF+ (Deltafax)
	(tested, works quite well, dunno about polling)
\&\&
    Zoom V.FAST 24K
        (tested, works)
\&\&
.DE
.PP
It \fIshould\fR work with all class 2 faxmodems. Maybe the DC2
character sent at the beginning of a page by \f(CW\`faxrec.c\'\fR must be
changed to XON, for old class 2 modems (implementing very old drafts of
the standard). See section Modems. In Data mode, it will work with every
hayes-compatible modem.
.PP
.PP
.NH 2
Configuration\ and\ installation
.br
.PP
Compiling of the package should be quite straightforward. You have to
copy \f(CW\`policy.h-dist\'\fR to \f(CW\`policy.h\'\fR and edit it to set some
local policy options, see the comments in that file.
.PP
Then, edit the \f(CW\`Makefile\'\fR, to specify installation paths and some
system defines (explained there).
.PP
After that, a \f(CW\`make\'\fR should build the programs, and \f(CW\`make
install\'\fR should install them.
  
If your compiler complains about the \fB#ident\fR lines I use for
\&\f(CW\`SCCS\'\fR, please run \fBmake noident\fR, that will take care of those
lines.
.PP
If you get an error message about ``unresolved symbols'' when linking, you
may want to tell to tell the package whether you have the select(S) or poll(S)
system calls, by defining \fB-DUSE_SELECT\fR or \fB-DUSE_POLL\fR flags in
the \f(CW\`Makefile\'\fR (If you don't know it, try both, until the error goes
away).
.PP
If your system has neither the select(S) call nor the poll(S) call,
mgetty is not fully operational---these functions are the only way to
prevent mgetty from eating up characters when some other process is
trying to dial out.
.PP
You can use mgetty anyway, by specifying \fB-DUSE_READ\fR in the
Makefile, but beware: with this, mgetty will eat up at least one
character of the modem response when another program is dialing out.
That may lead to disastrous results if e.g. the \f(CW\`CONNECT\'\fR string
is thus corrupted, but most of the time, the character that \f(CW\`mgetty\'\fR
eats away will be an \fBcr\fR or \fBnl\fR or part of the command
that the modem echoes back.
.PP
If you have any problems compiling mgetty and sendfax (on a Unix-like
system---I do not support MS-DOS or Windows!), please contact me.
\&\fIBut make sure that you have read the documentation!\fR
.PP
.PP
.bp
.NH
Using\ \fBmgetty\fR
.br
.PP
You can't simply call \fBmgetty\fR from a shell script (like \f(CW\`/etc/rc\'\fR)
or interactively, because login is not possible unless mgety is called
directly by the \fBinit\fR process. The next sections explain how to do this.
.PP
.PP
.NH 2
How\ \fBmgetty\fR\ works
.br
.PP
To help you understand how mgetty works, here is an example of what
happens in various circumstances when you use it to control a modem
connected to a serial line, e.g. \f(CW\`/dev/tty2a\'\fR.
.PP
When the computer is booted, the operating system starts the \fBinit\fR
process, which is responsible for making sure that gettys are running on
the appropiate i/o devices, e.g. virtual terminals, serial lines and
modems.  \fBinit\fR reads its configuration file, \f(CW\`/etc/inittab\'\fR (on
System V), which tells it that the line \f(CW\`/dev/tty2a\'\fR should be
controlled by mgetty. It then creates an entry in \f(CW\`/etc/utmp\'\fR
(\fBlogin\fR needs this, that's why you can't log in if you try to start
mgetty by hand), and forks a new \fBmgetty\fR process, using the command
line specified.
.PP
When mgetty is started, it first checks if a valid lock file held by
another process exists. If it does, this means that the port is in
use, and mgetty will wait until the lock file goes away. Invalid lock
files, e.g. for nonexistent processes (``stale'' locks), are ignored.
.PP
Once the port is free, mgetty creates its own lockfile, initializes
the modem and removes its lock file again. Then it waits for something
to happen on the port. Note that it does \fInot\fR read any
characters, it just checks if there are any available for reading by
using \fBpoll()\fR or \fBselect()\fR.
.PP
There are two possibilities once characters arrive, either a different
program (e.g.  \fBuucico\fR) has started dialing out or a \f(CW\`RING\'\fR
was sent by the modem.  In the first case, mgetty should leave the
port alone. This is easy \fIif\fR the program dialing out has created a
valid lock file, mgetty will find it, wait for it to go away and then commit
suicide (which will cause \fBinit\fR to start a fresh \fBmgetty\fR
process).
.PP
In the second case, when there is no lock file, mgetty assumes that
the phone is ringing, creates a lock file and reads the characters
available. If it finds a \f(CW\`RING\'\fR, it picks up the phone by sending
\&\f(CW\`ATA\'\fR and waits for the \f(CW\`CONNECT\'\fR message. If the caller is
a fax machine, it saves the fax in the directory \f(CW\`FAX_SPOOL_IN\'\fR
(usually \f(CW\`/usr/spool/fax/incoming\'\fR) and exits. If it is a modem,
it prints \f(CW\`/etc/issue\'\fR and displays a login prompt. Once it has
received a login string, it calls \fB/bin/login\fR and lets it handle
things from here. \fBlogin\fR will read the password and will then
start the user's login shell, \fBuucico\fR, a dialup SLIP link or
whatever, but mgetty doesn't care about that. The lock file remains so
that no other programs can use the modem while somebody is logged in.
.PP
(If the \f(CW\`login.config\'\fR configuration file is used, mgetty can also call
other login programs than \fB/bin/login\fR.)
.PP
Once mgetty has terminated for whatever reason, \fBinit\fR might
reinitialize the port (this is why mgetty waits for lock files to go
away instead of quitting immediately) and will then start a new
\&\fBmgetty\fR process, which will remove lock files left over from the
last login.
.PP
The lock file handling is tricky, but very important. It is essential
that \fIall\fR programs that use the modem agree on one locking
protocol, otherwise one program might not know that the modem is in
use and will try to dial out anyway. A typical lock file is a file
called \f(CW\`/usr/spool/uucp/LCK..ttyxx\'\fR, containing the PID of
the process currently using the modem. Other processes can read it and
tell if the lock file belongs to an existing process or if it is
``stale'' and can be removed. This will obviously not work if the
processes look for lock files in different places, or if one of them
writes its PID in ASCII and another one tries to read it as a binary
number (while mgetty and sendfax do not care whether foreign lock files
are written in binary or ascii format, other programs do! mgetty can
sometimes detect this problem, and will thenlog a warning).
.PP
.NH 2
The\ \f(CW\`/etc/inittab\'\fR\ entry
.br
An typical \f(CW\`inittab\'\fR entry for \fBmgetty\fR looks like this (on
SystemV-style OSes):
.PP
.DS
.ft CW
<tt>:rlevel:<respawn|off>:/usr/local/sbin/mgetty [options] <device>
.DE
.ft R
.PP
where \f(CW\`tt\'\fR is a short form of the \f(CW\`device\'\fR name, used by
\&\fBinit\fR and \fBwho\fR for internal purposes. Usually this is
something like \f(CW\`S0\'\fR or \f(CW\`2A\'\fR or so.
.PP
\&\f(CW\`rlevel\'\fR specifies the runlevel that the command in the fourth field
is run at, this may be \f(CW\`23\'\fR or \f(CW\`56\'\fR or so, look at \fBman
init\fR.
.PP
The next field tells \fBinit\fR whether that entry is active
(\fBrespawn\fR) or not (\fBoff\fR), and the fourth field specifies which
program to run.
.PP
The following options are available for \fBmgetty\fR:
.PP
\&\f(CW\`-x \fI<level>\fR\'\fR sets the debugging level
.PP
\&\f(CW\`-s \fI<speed>\fR\'\fR sets the port speed. If not specified, the default
from \f(CW\`policy.h\'\fR, (definition \fBDEFAULT_PORTSPEED\fR) will be used.
.PP
\&\f(CW\`-k \fI<space>\fR\'\fR sets the minimum number of kbytes required
on the incoming FAX spool directory.  If there isn't this much space
in the spool directory, the connection is terminated.  The default
is 1 megabyte.
.PP
\&\f(CW\`-m \fI'expect send ...'\fR\'\fR sets the modem initialization sequence.
  
\&\f(CW\`-r\'\fR for direct lines (no modem chats are done)
.PP
\&\f(CW\`-p \fI<login prompt>\fR\'\fR sets the login prompt (various escapes are
allowed)
.PP
\&\f(CW\`-n \fI<rings>\fR\'\fR sets the number of \fBRING\fR messages to expect
before sending \fBATA\fR to answer the phone. Default is one \fBRING\fR.
.PP
\&\f(CW\`-R \fI<sec>\fR\'\fR tells mgetty to enable ``ring-back'' or
``ring-twice'' mode. This means that mgetty won't pick up a call
immediately, but the caller has to hang up after the first ring, and
call again in the next \fI<sec>\fR seconds.
.PP
\&\f(CW\`-i \f(CW\`/etc/issue\'\fR\'\fR specifies the issue file to display before 
prompting for login.
.PP
\&\f(CW\`-S \f(CW\`<fax_document>\'\fR\'\fR specifies a document to send to polling fax
machines (full path required). \f(CW\`<fax_document>\'\fR has to be in G3 format
(as for \fBsendfax\fR).
.PP
A sample entry in \f(CW\`/etc/inittab\'\fR might look like this:
.PP
.DS
.ft CW
F1a:23:respawn:/usr/local/sbin/mgetty -x 3 tty2a
.DE
.ft R
.PP
For a more detailed explanation of all the options, please look into the
\&\f(CW\`mgetty(1)\'\fR man page.
.PP
.NH 2
Choosing\ the\ right\ device
.br
.PP
Some operating systems provide two separate devices for each serial
line, one of which is intended especially for gettys. This is
\&\fINOT\fR a good idea, because it it won't work with \fBmgetty\fR. It is
meant for modems used in auto-answer mode.
.PP
\&\fBmgetty\fR picks up the phone by hand, this will only work properly
if you use the \fIsame\fR device you would use for dialing out. (Some
people like to create a symlink \f(CW\`/dev/modem\'\fR for this, but you
have to be consistent and use this for \fIall\fR comm programs if you
do - otherwise you'll run into problems with the lock file names).
.PP
Here are some examples for different systems:
.PP
.IP \(bu\ 
SV Unix systems using the FAS serial driver:
.IP
Use \fBttyF01\fR etc., (minor number 80+(port number). Do \fInot\fR
use \fBttyFMxxx\fR---mgetty will open the device anyway, but then an
open to the ``normal'' port (without carrier detect) will block.
.IP
.IP \(bu\ 
SCO Unix systems with the stock serial driver:
.IP
Use the modem-control port (\fBtty2A\fR), \fInot\fR \fBtty2a\fR, because
hardware flow control and carrier detection do not work on ``lowercase''
tty decices.
.IP
The same holds for ``smart'' serial boards, as specialix, digiboard,
\&\&..., because they mimic the behaviour of SCO's sio driver.
.IP
.IP \(bu\ 
Linux:
.IP
Use \f(CW\`/dev/ttyS*\'\fR, \fInot\fR \f(CW\`/dev/cua*\'\fR
.IP
.IP \(bu\ 
SunOS, FreeBSD, NetBSD:
.IP
Use \f(CW\`/dev/cua*\'\fR, not \f(CW\`/dev/ttyS*\'\fR. Don't ask me why it has to be
this way, but the other way won't work.
.IP
.PP
.NH 2
Log\ files
.br
.PP
\&\fBmgetty\fR will normally write all actions into a logfile, named
\&\f(CW\`LOG_PATH.\fI<device>\fR\'\fR (LOG_PATH is defined \f(CW\`policy.h\'\fR),
e.g. \f(CW\`/tmp/log_mg.ttyxx\'\fR, so you can easily see what's happening in your
system. (If a fatal error
occurs, the error message is also written to the console, and if that
is not possible, mailed to \f(CW\`ADMIN\'\fR). The name of the log file can be
changed in \f(CW\`policy.h\'\fR.
.PP
If \fBmgetty\fR is compiled with \fB-DSYSLOG\fR, auditing and error log
messages will also go to \fBsyslog\fR (if your system supports it).
.PP
.NH 2
Denying\ logins
.br
.PP
If you want to prevent mgetty from accepting calls, you can do so by
creating a file called \f(CW\`/etc/nologin.\fI<device>\fR\'\fR
(e.g. \f(CW\`/etc/nologin.tty2a\'\fR). mgetty will then detect an incoming call,
see this file and NOT answer the phone. This way the caller does not lose
money for a useless call when logins are not allowed anyway. (You can
change the filename that is checked by changing \fBNOLOGIN_FILE\fR in
\&\f(CW\`policy.h\'\fR)
.PP
This can be used for quite sophisticated scheduling purposes - imagine a
modem attached to a line used for voice during the daytime. So, you want
the modem only to answer the phone during 9 pm and 7 am. What you do is to
have \fBcron\fR create a \f(CW\`/etc/nologin.\fIdevice\fR\'\fR file at 7 am (so
the modem won't answer the call during the day) and remove it at 9 pm (so
the modem can aswer the phone at night).
.PP
Naturally, this can be easily extended - e.g., answer the phone only on
weekends (similar cron job), don't answer the phone if there are less
than 5 Mbyte free on disk (have a process check for free disk space
regularily and create \f(CW\`/etc/nologin.*\'\fR file(s) accordingly), \&...
.PP
.NH 2
Direct\ serial\ lines
.br
.PP
If you have a direct serial line between two unix machines, or a unix
machine and something else, and want to run a getty program on the unix
side that should not interfere with outgoing traffic (e.g.: two unix
machines, both sides running gettys, both sides able to initiate an uucp
connection), you can also use mgetty. Start it with the \f(CW\`-r\'\fR flag (as
with uugetty), and it will not try to initialize the modem or wait for
RINGs. It will just sit silently on the port and wait\&... You won't see
\&\f(CW\`/etc/issue\'\fR on the other side until mgetty gets at least one
character, this prevents two mgettys from talking to each other.
.PP
.NH 2
Interaction\ between\ \fBmgetty\fR\ and\ other\ programs
.br
.PP
Normally, after a caller enters his login name, \fBmgetty\fR calls
\&\fB/bin/login\fR to do the password checking and system login.
.PP
In some special cases, you may want to call other programs instead of
\&\fB/bin/login\fR. For example, you could want to call
\&\fB/usr/lib/uucp/uucico -L <username>\fR for all login names starting with
\&\f(CW\`U*\'\fR (to have \fBuucico\fR do the authentication, works only with
taylor uucp 1.05 or taylor uucp 1.04 with my patch in
\&\f(CW\`patches/taylor.p1\'\fR), or \fB/usr/lib/fnet/ifcico\fR for incoming
FidoNet calls (using \fBifcico\fR from Eugene Crosser's \f(CW\`ifmail\'\fR
package).
.PP
\&\fBmgetty\fR can do all this. It's controlled by a configuration file
\&\f(CW\`login.config\'\fR that is normally located in
\&\f(CW\`/usr/local/lib/mgetty+sendfax/\'\fR (definition \fBLOGIN_CFG_FILE\fR in
\&\f(CW\`policy.h\'\fR). I have provided a sample file with lots of comments,
please look into that file for the syntax to use. To make \fBmgetty\fR
understand incoming fido calls, you have to compile it with \fB-DFIDO\fR.
.PP
If you are worrying about security, you can also use this mechanism: just
call \fB/bin/login\fR only for trusted, known users, and \fB/bin/false\fR
for every other login name - so, only those listed in \f(CW\`login.config\'\fR
will be able to log in.
.PP
.NH 2
Using\ Caller-ID\ to\ selectively\ accept\ or\ reject\ calls
.br
.PP
If your modem is able to retrieve callerid information, and \fBmgetty\fR
is compiled with \fBCNDFILE\fR defined in \f(CW\`policy.h\'\fR, \fBmgetty\fR
can check the caller's number before answering the phone. (Until now, it
has only been implemented for ZyXELs - does anybody have a description how
Rockwell-based modems return Caller-ID informations?). If \fBCNDFILE\fR is
undefined, or if that file does not exist, all calls will be allowed.
.PP
Whether a call is accepted or denied is controlled by a configuration file,
per default this is \f(CW\`/usr/local/lib/mgetty+sendfax/dialin.config\'\fR
(a sample file is installed per default).
.PP
That file contains a series of tokens separated by newlines, commas, tabs
and spaces. The callerid number is compared with each token in turn, until
a match occurs. A match occurs when the token compares equally to the
callerid information up to the length of the token.  If the token is
prefixed with a ``!'', a match means ``do not answer the phone''. The token
``any'' matches any telephone number, and will terminate scanning of the
cndfile. If no callerid number is present, it is assumed to have the value
``none''. A line starting with ``#'' is a comment.  There is an implicit
``any'' at the end of the file.
 
For example:
.PP
.DS
.ft CW
	# list of my friends' data lines
	3433535, 7445343, 5551212
	# dad's fax
	4164646777
	# disallow [other] calls from numbers matching the following prefix:
	!416
	# disallow that speed dialer that keeps hitting my machine
	!3444444
	# allow all calls with the following prefixes
	832, 555
	# don't allow calls when there's no callerid:
	!none
	# It's okay to accept calls from out of area
	# ("OUT_OF_AREA" token seems ZyXEL specific)
	OUT_OF_AREA
	# disallow all other calls
	!any
.DE
.ft R
.PP
For the future, Chris Lewis is planning on adding special modem initialization
strings (e.g., 2400 bps only, fax-only, ...) dependant on the caller
number.
.PP
.PP
.bp
.NH
Fax\ Operations
.br
.PP
Both mgetty and sendfax deal exclusively with raw ``g3'' fax files. You
will have to use external programs to create, view or print these.
.PP
There are two kinds of g3 files, the high resolution type with 204x196
dpi and the low (``normal'') resolution ones with 204x98 dpi.  If you
mix up the two, the recipient will get a fax page that is either twice
or half the proper length. You have been warned.
.PP
The width of a fax page is always 1728 pixels, the length is arbitrary
(though there are some plain paper fax machines out there that limit the
page length to A4 paper). A typical full page has a length around 2100
pixels in high-resolution mode.
.PP
.PP
.NH 2
Converting\ fax\ files
.br
.PP
I recommend getting the \f(CW\`pbmplus\'\fR package written by Jeff Poskanzer,
which includes lots of small programs to convert various bitmap formats
into a portable intermediate format (\fBpbm\fR) that can easily be
converted to fax format with the \fBpbmtog3\fR program. Further, it comes
with lots of tools to scale, flip, and otherwise manipulate the \fBpbm\fR
bitmaps. Be warned: it includes its own version of \fBpbmtog3\fR and
\&\fBg3topbm\fR, so be careful which one gets installed. The programs in the
\&\fBmgetty\fR package behave slightly different (that is, they work!), and
are significantly faster.  Note that the \fBpbmplus\fR package does not
include a graphical front end.
.PP
The \f(CW\`pbmplus\'\fR package can be found on most major FTP sites, e.g. on
ftp.x.org in the \f(CW\`/contrib\'\fR directory See section ftp.
.PP
If you want to view the images using X11, you should get one of the many
image viewers, like \f(CW\`xview\'\fR, \f(CW\`xloadimage\'\fR or \f(CW\`xv\'\fR.
See section Fax-Tools
.PP
Here are some examples for viewing fax files using \fBg3topbm\fR:
.PP
.IP \(bu\ 
You can print a fax on a PostScript printer (try \f(CW\`lpr -Pps\'\fR if you
don't have \f(CW\`lp\'\fR):
.IP
.DS
.ft CW
cat $faxfile | g3topbm | pnmtops -noturn | lp -dest postscript
.DE
.ft R
.IP
.IP \(bu\ 
or on an Epson-LQ, scaled for fine resolution (use -yscale 1.84 for
normal resolution):
.IP
.DS
.ft CW
cat $file | g3topbm | pnmscale -xscale 1.76 -yscale 0.92 |\e
    pgmtopbm | pbmtodot -360x180| lp -o epson -
.DE
.ft R
.IP
.IP \(bu\ 
or you could view it using X11 via:
.IP
.DS
.ft CW
cat $file | g3topbm >/tmp/fax.pbm ; xloadimage /tmp/fax.pbm
.DE
.ft R
.IP
or:
.DS
.ft CW
g3tobpm $file | xv -
.DE
.ft R
.IP
.PP
There are three easy ways to create g3 fax files, either use \f(CW\`pbmtog3\'\fR
(included in this package and also in the pbmplus toolkit. \fBNote:\fR
See section pbmtog3), use GhostScript (GNU Software, can be found on
prep.ai.mit.edu) which contains a ``digifax'' driver that will produce the
required format, or try Chris Lewis' \f(CW\`hp2pbm\'\fR package which will
convert HP Laserjet print files into g3 fax files (\fBhp2hig3\fR
program).
.PP
Once you have the right tools, you have lots of ways to create fax files
for a wide variety of applications. Here are some examples:
.PP
.IP \(bu\ 
Ascii files can be converted using \f(CW\`pbmtext | pbmtog3\'\fR (use a
\&\fIlarge\fR font, and don't convert texts longer than about 50 lines).
Alternatively, you can convert ascii files to PostScript using
\&\f(CW\`psify\'\fR, the \f(CW\`pslp.ps\'\fR program from the ghostscript
distribution, or similar tools, and feed their output into GhostScript.
.IP
.IP \(bu\ 
PostScript input can be converted by GhostScript (version 2.4 or
higher), using the digifax (\f(CW\`dfaxhigh\'\fR and \f(CW\`dfaxlow\'\fR) drivers.
It will generate a plain g3 file with a 64 byte additional header, which
will be skipped automatically. (You have to generate separate g3 files,
one per page). 
.IP
A typical call to ghostscript would look like this:
.IP
.DS
.ft CW
gs -sDEVICE=dfaxhigh -sOutputFile=/tmp/fax.g3.%d yourdocument.ps
.DE
.ft R
.IP
Do \fInot\fR use the ``tiffg3'' or similar drivers, they will create output
files with headers that sendfax does not understand, thus causing the
receiving fax machine to reject the data (it will assume that the
transmitted headers are garbled data).
.IP
If you use Ghostscript version 3.01 and up, you can use the \f(CW\`faxg3\'\fR
driver as well, its output is identical to the output of the
\&\f(CW\`dfaxhigh\'\fR driver except for a 64 byte header.
.IP
.IP \(bu\ 
Bitmaps can be converted using the \f(CW\`pbmplus\'\fR tools, but you'll have
to do the proper scaling by hand. Use a pipeline with \fBpbmtog3\fR at the
end.
.IP
.IP \(bu\ 
TeX dvi files can be converted to PostScript using \f(CW\`dvialw\'\fR or
\&\f(CW\`dvips\'\fR. If you want to get the best possible output quality, you can
use Metafont to create a set of 204x196 dpi fonts, which will look a lot
better than scaled 300 dpi fonts (look into \f(CW\`contrib/dvi-fax\'\fR for
instructions how to do this). You can use the \fBepsf\fR macros to include
encapsulated PostScript files, e.g. a scanned signature.
.IP
.IP \(bu\ 
Another way for TeX file conversion is Ralf Schleicher's \fBfaxdvi\fR
package, found in \f(CW\`contrib/faxdvi-0.1.tar\'\fR. Don't ask me about, ask
him!
.IP
.IP \(bu\ 
HP-Laserjet files can be translated with Chris Lewis' \f(CW\`hp2pbm\'\fR
package. It contains a program \fBhp2hig3\fR that will read
HP-Laserjet \f(CW\`PCL4\'\fR files and produce G3 output.
.IP
\&\fBWarning:\fR the G3 files that hp2hig3 emits lack the leading EOL
code, thus causing \fBsendfax\fR to complain and possibly fail. As a quick
fix, you can pipe those files through \fBg3cat\fR, it will fix the data.
.IP
.PP
A rather crude sample conversion program (\fBfaxcvt\fR) is provided in
the fax directory.
.PP
Better conversion, including guessing of the format of the input files,
is done by the \fBfaxspool\fR program, also provided in the fax
directory. See section Queuing
.PP
.PP
.NH 2
Receiving\ faxes
.br
.PP
If everything has been set up properly, faxes will be received
automatically. Obviously, mgetty has to be listening to the proper modem
line. Then, if a fax arrives, mgetty will store it in the directory
\&\fBFAX_SPOOL_IN\fR and send a mail to \fBMAIL_TO\fR (defined in
\&\f(CW\`policy.h\'\fR.
.PP
The file name format is somewhat tricky (the reason behind it is that I
have to create something unique without using \fBmktemp()\fR, because that
would make it impossible to find out which pages belong to which fax). It
is:
.DS
.ft CW
f<res><seq><line>[-<remote id>].<pagenr>
.DE
.ft R
\&\fB<res>\fR is \fBn\fR or \fBf\fR, depending on the resolution of the
fax. \fB<seq>\fR is a sequence number, 7 digits wide, somewhat related to
the reception time. \fB<line>\fR are the last two letters of the tty
device, e.g. \f(CW\`S1\'\fR. If the sending side specified a fax station id,
it comes next, after a leading dash (all blanks are replaced by dashes).
Finally, after a dot, you'll see the page number.
.PP
.PP
If you want to process incoming faxes automatically, for example, print
them, re-send them to another fax, send them by mail to you when you're on
vacation, you could use what I call ``notify programs'':
.PP
If you define \fBFAX_NOTIFY_PROGRAM\fR in \f(CW\`policy.h\'\fR, mgetty
will call this program (or shell script) when a fax has been completely
received. It will be called with the following command line arguments:
.PP
.DS
.ft CW
FAX_NOTIFY_PROGRAM \fI<hangup code>\fR '\fI<sender id\fR>' \fI<nr of pages>\fR \e
                   \fI<file name page 1>\fR \fI<file name page 2>\fR \&...
.DE
.ft R
.PP
\&\fI<hangup code>\fR is 0 if the receive was successful, non-zero
otherwise.  \fI<sender id>\fR is the fax identification string received
from the other side.  \fI<file name page (i)>\fR is the full path name for
each received page.
.PP
A sample command line might look like this:
.PP
.DS
.ft CW
/usr/local/bin/new_fax 0 "+49 89 3243328" 1 /usr/spool/fax/ff-01.a123
.DE
.ft R
.PP
Such a ``notify program'' could print out the fax, convert it into a MIME
metamail and send it away, display it in an X window (this a little bit
tricky), or whatever.
.PP
I provide a few examples (printing on HP laserjet, mailing as gzip'ed,
uuencoded pbm file, \&...) in \f(CW\`samples/new_fax.*\'\fR
.PP
.PP
If you have the \fBdialog\fR shell tool, you can use the \fBfaxv\fR
program (``faxview'') that I provide in \f(CW\`dialog/faxv\'\fR to browse
through all faxes in the incoming spool directory, view them, print them,
rename and move them, \&.... \f(CW\`faxv\'\fR is really more a sample program
to show you how to do it, and you have to configure the X11 viewer and the
printing program in the source code, but I use it for my faxes, and it
works. Because of limitations on some operating systems, the list of faxes
displayed is limited to the last 50 faxes received.
.PP
.PP
.NH 2
Basic\ \fBsendfax\fR\ usage
.br
.PP
Sendfax is very primitive---no spool management, no format conversion,
etc.  It is designed to be able to send exactly one fax (consisting of
multiple pages) to exactly one fax machine, but it is usable from
within shell scripts.  Its input are pages in ``g3'' format, either
created with ghostscript or with pbmtog3.
.PP
It is called like this:
.PP
.DS
.ft CW
sendfax [-v] [-n] \fI<phone-number>\fR \fI<fax page(s)>\fR
.DE
.ft R
.PP
e.g.
.PP
.DS
.ft CW
sendfax 0893243328 /tmp/to_gert_1.g3 /usr/spool/fax/outgoing/picture.g3
.DE
.ft R
.PP
It will then attempt to open the fax device and send all the pages to
the remote fax machine, in the given order.
.PP
It will print little or nothing to stdout or stderr, except if it cannot
find or open one of the named files.
.PP
(Since most class 2 faxmodems do not implement the command set
properly, putting a header on a page does not work with them - because
of that, I had to disable the fax header code. It will output a
warning message and ignore the \fIheader\fR file. \fBfaxspool\fR
works around this problem by using \fBg3cat\fR (See section Fax-Tools) to
``paste'' a header line on top of each page)
.PP
If you specify \f(CW\`-v\'\fR, it will output more verbose progress messages.
.PP
If you specify \f(CW\`-n\'\fR, it will try to send the fax data in normal
resolution, default is fine resolution. (No conversion is done, so make
sure that your input data is already in the proper format.)
.PP
Detailed reports can be found in the log file (usually
\&\f(CW\`/usr/spool/fax/Faxlog\'\fR) --- but they may be of little more than
technical interest since virtually all conversation with the fax modem is
logged. (Nevertheless, if you send me any bug report, \fIplease include
all log files\fR)
.PP
\&\fBWarning:\fR Watch sendfax closely when sending the first few
faxes. I had it abort a transfer a couple of times, not being able to
recover but \fInot\fR hanging up the modem! (In my case, it was a
problem of the modem that went away when I upgraded the firmware. Older
ZyXEL releases sometimes stopped the DTE and forgot to re-start
it again.)
.PP
The return codes of the sendfax program were chosen to make it easy for
external programs (i.e. faxrunq) to decide whether to try again or not:
.PP
.DS
.ft CW
 0: all pages transmitted successful
 1: error on command line
 2: cannot open fax device (typically happens if fax device is
    locked, but could also be a permission problem)
 3: error initializing the modem
 4: dial failed, "BUSY"
10: dial failed, "ERROR" or "NO CARRIER"
11: waiting for XON failed (should never be seen)
12: transmitting page(s) failed (or polling failed)
.DE
.ft R
.PP
If the error code is less than 10, the attempt didn't cost anything, so an
external program should try again to send the files. If it is 10 or higher,
the failed attempt probably cost something, and the program should decide
whether to try again (thus expending more money) or mail the operator and
tell him something went wrong. My \fBfaxrunq\fR program will suspend the
job after five unsuccessful tries with error codes >= 10.
.PP
.NH 2
Fax\ polling\ using\ \fBsendfax\fR
.br
.PP
Sendfax can also be used for fax polling, the syntax is:
.PP
.DS
.ft CW
sendfax -p \fI<fax-number>\fR
.DE
.ft R
.PP
.PP
or for sending a fax and then switch to polling:
.PP
.DS
.ft CW
sendfax -p \fI<fax-number>\fR \fI<send-documents>\fR
.DE
.ft R
.PP
(in this case \fI<send-documents>\fR are sent, and then the documents
from the other modem are polled, if there are any)
.PP
the received pages are written to the current directory, so make sure
you have write access...
.PP
.PP
\&\fBWarning:\fR Fax polling does \fInot\fR work with ZyXEL Modems
with ROM releases before 6.00 - with the 6.01 and 6.10 Eproms it works,
but 6.11a is broken again. 6.12 and 6.13 work fine.
.PP
It definitely doesn't work with Rockwell-based Faxmodems (Supra), since
this chipset does not support polling.
.PP
Could anybody try this with an Everex Faxmodem?
.PP
.PP
.NH 2
Automated\ fax\ queuing\ 
.br
.PP
For fax spooling and processing the queue, four more utility programs are
provided:
.PP
.IP
.IP \(bu\ 
\&\fBfaxspool\fR will spool a number of files (accepting various formats)
and put them into the fax spool directory. Its syntax is:
.IP
.DS
.ft CW
faxspool [options] phone-number input-file(s)
.DE
.ft R
  
\&\f(CW\`phone-number\'\fR can be an alias, in this case the files
\&\f(CW\`/usr/local/lib/mgetty+sendfax/aliases\'\fR and \f(CW\`$HOME/.faxnrs\'\fR will
be searched for a line starting with this alias. The remainder of this line
will then be used as fax number.
.IP
\&\fBfaxspool\fR interacts with the \fBfile\fR program and
\&\f(CW\`/etc/magic\'\fR to determine the file type of the input files. If your
\&\f(CW\`/etc/magic\'\fR lacks entries for the various bitmap files, take a look
at \f(CW\`fax/etc-magic\'\fR, it contains the most important magic numbers.
.IP
\&\fBfaxspool\fR reads the text to put on top of each fax page from
\&\f(CW\`LIBDIR/faxheader\'\fR. This file must contain pure ASCII text. Some
tokens are replaced by the actual values: @T@ becomes the destination
phone number, @P@ becomes the actual and @M@ the total page number,
and @U@ is replaced by the user name. If your fax modem cuts of a few
lines on top of each page, it may be a good idea to put a blank line
before the header line itself, and it is also a good idea to indent the line
about 5 spaces.
.IP
For the available options, please read the \f(CW\`faxspool.1\'\fR man page.
.IP
.IP \(bu\ 
\&\fBfaxrunq\fR will read this directory and try to send all the faxes
queued there (time scheduling is available, but primitive). If faxrunq
succeeds, the fax is deleted and the sender is mailed. If it does not
succeed after five tries (\f(CW\`BUSY\'\fR or a locked fax modem do
\&\fInot\fR count for this) it will send a mail and not try any further
to send this fax. (This should prevent your faxmodem from making you
bancrupt\&...).
.IP
\&\fBfaxrunq\fR should be called at regular intervals from \fBcron\fR to
process the queued jobs. It should only be executed by \fIroot\fR, to
make sure that all the files in the fax spool directory are read- and
writeable.
.IP
.IP
.IP \(bu\ 
\&\fBfaxq\fR will display all entries in the fax queue. If called with
the \f(CW\`-o\'\fR parameter, it will also display completed, but not yet
deleted jobs (JOB.done files). If called with the \f(CW\`-v\'\fR parameter, the
output will be more verbose.
.IP
Jobs that are just being sent are not shown (\fBfaxq\fR doesn't see locked
jobs)
.IP
.IP \(bu\ 
\&\fBfaxrm\fR can be used to remove fax jobs from the queue. It is called
with the job ids of the to-be-removed faxes as command line argument. The
job ids are those that \fBfaxq\fR returns.
.IP
.PP
These utilities do still have some rough edges, but I think they are fairly
usable by now.
.PP
Earlier variants of those utilities had to be configured in the source
code, from release 0.20 on, that should be done by \fBmake\fR. Please
check the scripts nevertheless, whether all directories and files are set
up properly.
.PP
.NH 2
Additional\ tools\ for\ working\ with\ g3\ files
.br
.PP
Some additional tools are provided for manipulating G3 fax files
.PP
.IP \(bu \ 
\&\fBg3cat\fR (in the \f(CW\`tools\'\fR directory) concatenates multiple G3
fax files. It accepts ``raw'' g3 files and digifax files and outputs a
``raw'' g3 file without headers. Its syntax is analogous to
\&\fBcat\fR, except that you \fIhave\fR to specify \f(CW\`-\'\fR to read
from \f(CW\`stdin\'\fR.
.IP
\&\fBg3cat\fR recognizes two flags: \fB-l\fR, to separate the fax files
with a thin black line, and \fB-a\fR to byte-align the end-of-line
codes in the file (Warning: some modems do not like this).
.IP
.IP \(bu\ 
To convert an incoming fax to Jef Poskanzers \f(CW\`portable bitmap\'\fR
(\fBpbm\fR) format, you can use the \fBg3topbm\fR program that is
also provided in \f(CW\`tools/\'\fR. It's advantages over Jef's
\&\fBg3topbm\fR program are that it's approximately five times faster
and takes only one eigth as much virtual memory (on machines with low
virtual memory, it can thus be up to 100 times faster!). Its disadvantage
is that it produces only ``raw'' (i.e., binary) \f(CW\`pbm\'\fR files; and
it's not as stable when handling erroneous \f(CW\`g3\'\fR data (means that
if one line is severly corrupted, it can happen that the next line
will not be decoded properly. The rest of the file will then be OK
again).
.IP
Syntax:
.DS
.ft CW
g3topbm [-r] [-s] [-l] [-d <dpi>] [g3-file]
.DE
.ft R
.IP
If no g3 file is specified, standard input is used.
.IP
The \fB-s(tretch)\fR option causes \fBg3topbm\fR to double each row of
the g3 file.  You can use this to adjust the aspect ratio of a "normal"
resolution fax file to match that of a "fine" resolution fax.  Of course
you can use other \fBpbmplus\fR tools for this instead, but 
\&\fB-s\fR is sure to be faster.
.IP
If you have a HP Laserjet printer, you can make \fBg3topbm\fR output HP
LJ data with the \fB-l\fR switch. The desired resolution is chosen with
the \fB-d 75|150|300\fR switch.
.IP
If \fBmake install\fR detects that you have installed the \fBpbmplus\fR
tools before, it will move its \fBg3topbm\fR to \fBg3topbm.pbm\fR, so
you can still use it, if you want (same for \fBpbmtog3\fR).
.IP
.IP \(bu\ 
For the other direction, I have provided a \fBpbmtog3\fR program that will
convert Jef Poskanzer's Portable BitMap format into G3 fax data suitable
for faxing with \fBsendfax\fR. The \f(CW\`pbm\'\fR files can be produced by
various sources, e.g. drawing programs (\fBxpaint\fR), bitmap manipulation
programs (\fBxv\fR), or simply be converted from other file formats by
means of the \f(CW\`pbmplus\'\fR tools.
.IP
As above, my variant is a lot faster than Jef's, and unlike his, it
produces g3 data that adheres to the T.4 standard (if you don't fiddle too
much with the options...), so you don't have to apply any patches to make
it work together with \fBsendfax\fR.
.IP
Syntax:
.DS
.ft CW
pbmtog3 [-r] [-a] [-w page with] [-h blank lines] [pbm-file]
.DE
.ft R
.IP
if no pbm file is specified, standard input is used.
.IP
For a detailed description, see the \f(CW\`pbmtog3(1)\'\fR man page.
.IP
.IP
.IP \(bu\ 
To convert an incoming fax into X-Windows \f(CW\`xwd\'\fR bitmaps, you can
use Chel van Gennip's \fBg3toxwd\fR program, found in the
\&\f(CW\`contrib/\'\fR directory.
.IP
.IP \(bu\ 
If you want to print out faxes on a HP laserjet printer, you have two
opions: you can use Chel's \fBg3tolj\fR program (also in the
\&\f(CW\`contrib/\'\fR directory), or you use my \fBg3topbm\fR program with the
\&\fB-l\fR option, which will make it output LJ data.
.IP
.PP
.NH 2
Using\ an\ external\ fax\ as\ a\ scanner
.br
.PP
It is possible to tell mgetty to answer the phone even if it is not
ringing (I call this ``virtual rings''). Just send mgetty a signal
\&\fBSIGUSR1\fR, this is usually done with \f(CW\`kill -USR1
\&\fI<mgetty-pid>\fR\'\fR.  Mgetty will then pick up the phone and try to make a
connection.
.PP
If you have a normal fax machine connected to the fax modem, it should
be possible to have that fax machine dial any digit (to turn off the
dial tone), and then have mgetty answer the phone to receive the
``incoming'' fax, thus using the fax machine as scanner without paying for a
call. For a description of an sample setup (thanks, caz!), please see
\&\f(CW\`doc/scanner.txt\'\fR.
.PP
Whether it works may depend on your phone company's setup, but it should.
.PP
If you have a modem that has a \f(CW\`data/voice\'\fR button, it should also be
possible to hit that button to make the modem pick up the phone. Mgetty
will automatically notice that and handle it properly. (I've tested this
only with ZyXELs - could somebody else please test this with other modem
types and send me a logfile? Thanks)
.PP
.PP
.bp
.NH
Voice\ Operations
.br
.PP
This chapter explains how you can use mgetty to implement an answering
machine if you have a modem that understands the voice command set
(i.e. the ZyXEL). Note that these extensions are maintained by Klaus
Weidner (klaus@snarc.greenie.muc.de), send email about the voice features
to that address.
.PP
.PP
.PP
.NH 2
Introduction
.br
.PP
The voice extended mgetty (called \fBvgetty\fR) is intended for people who
want to share a phone line for data and voice use, with the main focus
being voice calls. It is \fBNOT\fR intended for a dialup system that
occasionally gets a voice call, since some modems are confused by hearing
a recorded voice message and won't get a connect.
.PP
.PP
.NH 3
Features
.br
.PP
.IP
.IP \(bu behaves like a normal answering machine for human callers\ 
.IP
.IP \(bu automatic fax/data reception when a calling tone is detected\ 
(and the modem recognizes it)
.IP
.IP \(bu smart voice/fax/data switching based on an FFT of the incoming\ 
signals (currently ZyXEL only)
.IP
.IP \(bu If the caller isn't recognized as a human, a fax/data connect\ 
is attempted, if this is successful, the caller will get a normal login
.IP
.IP \(bu does not interfere with dialouts\ 
.IP
.IP \(bu remote playback of messages via a DTMF code\ 
.IP
.IP \(bu toll saver -- if there are new messages, pick up the phone\ 
earlier, this way you can hang up in time to avoid a useless call
.IP
.IP \(bu message light - the autoanswer LED of your modem (if it has\ 
one) is turned on if there are new messages 
.IP
.IP \(bu easy playback - on some modems, you can play back the new\ 
messages just by pressing DATA/VOICE
.IP
.IP \(bu speech synthesizer support - add the date and time to messages\ 
(not included by default)
.IP
.IP \(bu voice conversion utilities - play messages on /dev/audio\ 
(currently ZyXEL only)
.IP
.PP
.NH 3
What\ you\ need
.br
.PP
Obviously, you need a modem that supports the voice commands. I have tried
only three different models so far, I would be interested in hearing about
others.
.PP
The ZyXEL works well, as long as you don't have a ROM older than 6.01. 
(Older ROMs might work, but I wouldn't count on it). I recommend
6.13, since it introduces a new, high-quality 4-bit voice format
and hardware flow control for voice transmission, which greatly
increases the reliability.
 
The Dolphin modem should work, but I haven't tried the code for a long
time. If you have a Dolphin modem, I'd be interested to hear about your
experiences with this code. The Dolphin modem can't do FAX, but vgetty will
notice that itself. The pvfadpcm conversion doesn't work, the format is
undocumented.
.PP
Rockwell-Based modems, e.g. the Creatix 144FV, do work, but conversion of
their voice data to PVF isn't possible, because
Rockwell considers their ADPCM voice data format proprietary and
refuses to hand out informations about it, unless you sign a non-disclosure
agreement, which in turn would prevent me from giving away the source
code. Complain to Rockwell about it. Loudly!
.PP
For ZyXELs, I recommend reading the ZFax documentation to find out how the
voice stuff works in general (i.e., where do I hook up a microphone etc.).
It's the file \f(CW\`zfax*.mnu\'\fR in the zfax main directory. Remember that CELP
compression is only supported by `+' models. If you use any mode other than
CELP, you will need a data rate of 38400 bps (57600 bps for the new 4-bit
ADPCM), a serial port with a 16550 UART is highly recommended on PCs.
.PP
.NH 2
Installation
.br
.PP
If you have unpacked everything correctly, you should have a directory
`mgetty' which in turn contains a directory called `voice'. The
Makefile in `mgetty/' builds mgetty, the one in `mgetty/voice' builds
vgetty and the voice tools.
.PP
Make sure you have `mgetty' configured correctly and working, this
package uses most of its code. You need to edit at least policy.h to
fit your system. Have a look at the README and mgetty.texi for
instructions.
.PP
Once you have got mgetty working, you should configure the `voice' section
at the end of the main mgetty \f(CW\`Makefile\'\fR. It shouldn't be necessary to
edit \f(CW\`voice/Makefile\'\fR. You can edit `voice/voclib.h' to configure some
voice options, check the comments there for instructions. The defaults
ought to work unless you have an unusual setup.
.PP
To build vgetty, do \f(CW\`make vgetty\'\fR in your mgetty directory. If you are
courageous you can try \f(CW\`make vgetty-install\'\fR to set up the voice
directory and install the binaries.
.PP
Put your greeting message(s) in the messages directory and store their file
names in the \f(CW\`Index\'\fR file, then edit \f(CW\`.code\'\fR and put your remote
playback code in it.
.PP
To install vgetty, put it in an appropiate directory (i.e. /etc, /usr/etc
or /sbin) and add the command line to \f(CW\`/etc/inittab\'\fR as described in
the mgetty documentation. The command line options are the same, you will
probably want to use something like \f(CW\`-n 4\'\fR to wait for four rings
before picking up the phone.
.PP
.PP
.NH 3
Internals
.br
Below is the default directory structure - if you change it, you will
have to modify the vg_* scripts. (VOICE_DIR is set in the Makefile,
the default is /usr/spool/voice.)
.PP
.DS
.ft CW
VOICE_DIR/messages/*  : greeting messages
VOICE_DIR/incoming/*  : received messages
VOICE_DIR/voice/vg_*  : external programs called by vgetty
VOICE_DIR/.code       : code digits for remote playing of messages
.DE
.ft R
.PP
All the external programs are shell scripts, you can easily change them if
you want more features. I'd like to hear about any interesting uses.
.PP
The \fBvg_message\fR script contains sample code for notifying
somebody by mail about incoming phone calls and for uuencoding
the messages and sending them via email, uncomment the appropiate
sections if you want to experiment with this.
.PP
.NH 2
Usage
.br
.PP
\&\fBvgetty\fR is installed just like \fBmgetty\fR and accepts the same
command line options. You should have a file called \f(CW\`Index\'\fR in your
greeting message directory that contains the filenames of your greeting
files, one per line. It will pick a random one when it answers the phone.
.PP
If you want to use your modem as an answering machine during the day
and for data dialin during the night, you can use `cron' to create a
file called \f(CW\`/etc/answer.<device>\'\fR which contains a single line,
either `voice/fax/data' or just `fax/data' to accept only these types
of calls. If the file exists but is empty, vgetty won't answer the
phone at all (this is in addition to the \f(CW\`/etc/nologin.<device>\'\fR
feature of \fBmgetty\fR). You can add a second line to specify the
number of rings to wait for, this overrides the command line setting.
Here's what my \f(CW\`/etc/answer.modem\'\fR file contains:
.PP
.DS
.ft CW
voice/fax/data
rings 4
.DE
.ft R
.PP
DTMF tones can be used to control vgetty. The effects are as follows:
.PP
.DS
.ft CW
playback mode (during the greeting message):
	'*': stop playing, switch to recording mode.
	'#': hang up. (Use this if you answer the phone by hand after
	     the computer has started talking.)
	'0'-'9': start the external DTMF program, pass the digit as $1
.DE
.ft R
.PP
.DS
.ft CW
recording mode:
	"*<digits>#": start the external DTMF program and pass the
	     digits as $1. The '*' is optional, it can be used to
	     remove mistyped digits ("*22*345#" is equivalent to 
	     "*345#").
	'#' without leading digits: hang up the phone.
.DE
.ft R
.PP
The DTMF command is used for remote playback of messages, the default
code is `*12345#' (stored in VOICE_DIR/.code). You get three tries
to enter the correct code.
.PP
If you want to make this more user friendly, you should record
three messages and store them in \f(CW\`VOICE_DIR/messages/\'\fR:
.PP
\&\f(CW\`get-code\'\fR: "Please enter your access code"
\&\f(CW\`incorrect\'\fR: "Incorrect code"
\&\f(CW\`goodbye\'\fR: "Goodbye"
.PP
If you have a speech synthesizer package (I use rsynth-0.9.linuxA), you
might want to take a look at the \f(CW\`speakdate\'\fR script, I use it to
append a date stamp to each recorded message. I'm not going to give a
detailed explanation of how it works, since it is going to be very much
dependent on your setup. Feel free to experiment. I have included my
patches to the rsynth code to enable it to output a voice file on stdout.
.PP
.NH 2
Voice\ utilities
.br
.PP
Type `zplay' without arguments (or read the manpage) to get the usage
summary. The most important applications are:
.PP
.DS
.ft CW
zplay <voice-file>   : play a file on the telco line
zplay -s <voice-file>: play a file on the external speaker
zplay -r <file>      : record a file from the telco line
                       (use your interrupt key (^C) to stop)
zplay -r -m <file>   : record a file from the external microphone
.DE
.ft R
.PP
There is a short manpage for the pvf utilities, it is easy to add new
converters if you want more special effects - send them to me if you
want them integrated into the package.
.PP
Here are some examples of what you can use the tools for:
.PP
Read the adpcm file A, add one second of silence at the start and cut off
the last half second, mix it with the pvf file B, convert the result to
ADPCM-3 and store it in the file C:
.DS
.ft CW
       adpcmtopvf <A | pvfcut -1 .5 | pvfmix B | pvftoadpcm3 >C
.DE
.ft R
.PP
.PP
Convert a voice message to a format suitable for inclusion in a MIME
message:
.DS
.ft CW
       adpcmtopvf <A | pvfspeed 1.2 | pvftobasic >B
.DE
.ft R
.PP
Play a recording on a sound card:
.DS
.ft CW
       adpcmtopvf <A | pvftoau >/dev/audio
.DE
.ft R
.PP
Note that the adpcm converter works only for ZyXELs and is also dependent
on the ROM release you have. Please read the comment in the Makefile.
.PP
For further information, `Use the Source, Luke'.
.PP
.NH 2
Voice\ mode\ troubleshooting
.br
.PP
If you find any bugs, please tell me about them, I'll try to fix them for
the next release. Don't forget to include the relevant information from the
log file (\f(CW\`/tmp/log_mg.ttyxx\'\fR) and what kind of operating system
and modem you are using.
.PP
Don't forget to read the appropiate sections of the mgetty documentation.
This section only mentions vgetty specific problems.
.PP
.PP
.NH 3
Miscellaneous
.br
.PP
.IP \(bu Where can I get a CELP converter?\ 
.IP
ZyXEL considers the CELP format to be proprietary, and won't release
information on the data format. In addition, CELP is a lot more complicated
than ADPCM, and a converter, even if the format was known, would probably
be a fairly complex program. Feel free to write one.
.IP
.IP \(bu How can I play voice data recorded with a Rockwell-based modem on my\ 
Soundcard?
.IP
Short answer: you can't.
.IP
Long answer: there is no way yet to convert Rockwell voice files to
anything else, because Rockwell won't release format specifications. They
consider it proprietary and want you to sign an NDA (which would mean that
you can't give out your source code, stupid enough).
.IP
.IP \(bu I can't record a greeting message\ 
.IP
Try calling yourself from somewhere else and use the recorded message. This
is a last resort if you can't get the microphone to work (I never did) and
you aren't allowed to connect the phone parallel to the modem (which German
Telekom doesn't permit).
.IP
.IP \(bu DTMF detection doesn't work reliably\ 
.IP
Try calling \fBzplay\fR directly to find out if the modem is
detecting the DTMF codes correctly, i.e. \f(CW\`zplay -D -r /dev/null\'\fR.
You can adjust the sensitivity by tuning parameters in \fBvoclib.h\fR
if you have a ZyXEL with 6.12 or newer ROMs.
.IP
.PP
.NH 3
Voice\ playback\ and\ recording\ is\ badly\ garbled\ or\ noisy
.br
.PP
Loud bursts of noise, pauses or dropped sections while playing back data
files can have various reasons, here are some things you can check:
.PP
.IP \(bu Is the serial data rate high enough? If it isn't, the modem\ 
buffers will overflow (or underflow during playback). Most voice formats
require a minimum speed of 38400 bps, the ZyXEL even needs 57600 bps for
4-bit ADPCM. If your operating system (i.e. Linux) doesn't support this
directly, you might be able to redefine the port rate using a utility like
\&\fBsetserial\fR.  If you get a lot of \fB<DLE>o\fRs or \fB<DLE>u\fRs in
your log file (Rockwell modems only), your bps rate is definitely too low.
.IP
.IP \(bu Is the flow control set up correctly? Check the definitions in the\ 
Makefile and policy.h.
.IP
.IP \(bu Data loss - do you have a slow machine with a bad serial chip? On a\ 
PC, you ought to use a port with a 16550 UART.
.IP
.IP \(bu Use a soft, lint-free cloth to clean your hard disk. The magnetic\ 
dust interferes with high-fidelity applications.  (Just kidding\&...)
.IP
.PP
.NH 3
Paper\ faxes\ get\ confused
.br
.PP
A calling fax sends beeps (T.30 calling tones), which are detected by the
modem. Occasionally a calling fax will give up as soon as it hears a voice
on the line, in this case you might want to add two seconds of silence at
the start of your greeting message to give the modem a chance to detect the
beep and enter fax mode.
.PP
.NH 3
Calling\ modems\ don\'t\ get\ a\ connect
.br
.PP
Some modems are confused if they hear a human voice instead of the usual
modem beeps when calling, especially cheap 2400 bps models.  This is
unfortunate, but there isn't much I can do about this.  Voice/Data
distinction is inherently difficult, the modem can't tell the difference
between a human caller who hasn't started speaking yet and a modem which
waits for the called modem to initiate the handshake, since both are
silent. The way \fBvgetty\fR handles this is by playing the greeting
message, and if it doesn't hear anything, switching to DATA mode. If the
calling modem isn't silent like it should be after the greeting message,
this will never happen.
.PP
Another problem is easier to fix - the calling modem has to be patient
enough to wait through the greeting message, the beep and about
seven seconds of silence without giving up, this means that the caller
has to set the chat timeout to a high enough value (i.e. ATS7=120).
If you get many data calls, you should obviously keep the greeting
message short and you might also want to decrease the silence length.
If you get very many data calls, you should get a second phone line and use
mgetty instead.
.PP
.PP
.bp
.NH
Common\ problems\ and\ solutions
.br
.PP
This chapter tries to describe some known problems that can occur when
installing or using this package. Don't worry, most of these have been
solved.
.PP
.PP
.PP
.NH 2
Modems
.br
.PP
This section describes problems that can occur when using various types
of modems. Unfortunately, the class 2 fax implementations vary quite a
bit between different manufacturers.
.PP
.PP
.NH 3
Problems\ common\ to\ many\ modem\ types
.br
.PP
.IP \(bu\ 
Disable auto-answer in the modem (\fBATS0=0\fR), because it will interfere
with the manual answer done by \fBmgetty\fR. If you \fIhave\fR to use
auto-answer, set the \fBmgetty\fR ring-counter (\fB-n <i>\fR) high enough
that \fBmgetty\fR will never try to answer the phone manually.
.IP
.IP \(bu\ 
Make sure that your modem is set to return \fIverbose result codes\fR,
that is, set \fBATV1\fR. Otherwise, the modem won't return \f(CW\`CONNECT\'\fR
or \f(CW\`RING\'\fR but \f(CW\`1\'\fR or \f(CW\`2\'\fR as result code, and mgetty
definitely doesn't understand that.
.IP
.IP \(bu\ 
Make sure that your modem is set to the proper dialing type (\fBATT&W\fR
for touch-tone, \fBATP&W\fR for pulse dialing) --- \fBsendfax\fR uses
\&\fBATD...\fR to dial out, assuming that the modem knows which dialing
method to use. Alternatively, set \fBFAX_DIAL_PREFIX\fR in
\&\f(CW\`policy.h\'\fR accordingly.
.IP
.IP \(bu\ 
If your modem doesn't understand the default initialization string in
policy.h, you can try a different approach. Many modems allow you to
store user profiles containing the desired configuration. If yours
does, you can simply replace the init string with \fBATZ\fR and
make sure that the default profile contains the right settings.
.IP
These options ought to work with most modems:
.IP
\&\fBATS0=0\fR: do not auto-answer, \fBE1\fR: echo on, \fBQ0\fR: send
modem responses, \fB&D3\fR: reset on DTR->low,
.IP
The following are ZyXEL specific:
.IP
\&\fB&H3\fR: set handshake to RTS+CTS,
\&\fB&N0\fR: ``multi-auto'' connect, accept all known protocols,
\&\fB&K4\fR: enable v42bis/mnp5 compression.
.IP
.IP
Naturally, you can use any init string you want (but the modem has to
return OK) --- check with your modem manual.
.IP
.IP \(bu\ 
Some modems do not like the \f(CW\`+FDCC=1,5,...\'\fR command.
.IP
In the latest version, mgetty and sendfax will automatically detect if the
modem isn't able to do 14400 bps for faxing and will use 9600 bps ---
\&\f(CW\`+FDCC=1,3,...\'\fR --- instead.
.IP
.IP \(bu\ 
Sometimes mgetty cannot initialize the modem, it times out waiting for
the first \f(CW\`OK\'\fR.
.IP
I assume that the problem is the DTR-induced modem reset before
sending the first \f(CW\`+++ATH\'\fR to the modem.
I know that some modems need quite a lot time after a reset, so this
should go away if you add more delays before sending the first string
to the modem:
.IP
In \f(CW\`mg_m_init.c\'\fR (line 38 or so) change
.IP
.DS
.ft CW
char *init_chat_seq[] =
           { "", "\e\ed\e\ed\e\ed+++\e\ed\e\ed\e\ed\er\e\edATQ0H0", "OK",
.DE
.ft R
.IP
to
.IP
.DS
.ft CW
char *init_chat_seq[] =
           { "", "\e\ed\e\ed\e\ed\e\ed\e\ed\e\ed+++\e\ed\e\ed\e\ed\er\e\edATQ0H0", "OK",
                   ^^^^^^^^^ additional delays here
.DE
.ft R
.IP
.IP
(please report if that cured the problem, and on which OS / Modem you
did this).
.IP
.IP \(bu\ 
Some operating systems send their commands too fast for some modems (Linux
is known to do this). In that case it may be necessary to increase the
delay times for \fBDO_CHAT_SEND_DELAY\fR and \fBFAX_COMMAND_DELAY\fR in
\&\f(CW\`policy.h\'\fR.
.IP
.IP \(bu\ 
Some Modems toggle DCD betwen pages, mayhaps correlated to the presence of
the ``high speed'' page transmission carrier. \fBsendfax\fR normally runs
carrier-sensitive, and will then get a lot error messages in the
\&\fBread\fR and \fBwrite\fR calls, logging them as \fBI/O Error\fR or
something similar when sending the first or second page. To work around
this, define \fBFAX_SEND_IGNORE_CARRIER\fR in \f(CW\`policy.h\'\fR.
.IP
.IP \(bu\ 
Some other Modems cannot (or not properly) distinguish between calling
faxes and calling modems.
.IP
Some of them just refuse to answer both, only recognizing one and failing
on the other (NO CARRIER) --- in that case, there's nothing you can do to
make it receive both (except making the manufacturer fix it). What you can
do is to force it to receive always fax or always data, what you need more:
go into \f(CW\`mgetty.c\'\fR, find the \fBAT+FAA=1\fR command (near line 60)
and change it to \fBAT+FAA=0\fR. This will disable adaptive answering.
Then, go one line up, and change the \fBAT+FCLASS=0\fR command to reflect
your needs: \fBCLASS=0\fR means data-only, and \fBCLASS=2\fR means
fax-only.
.IP
Some other modems can distinguish the different call types \fImost of
the time\fR, but some 2400 bps modems mysteriously fail. That may be caused
by some -- strange -- modems sending a certain tone when \fIcalling\fR the
other side, and the receiving end mistaking that for the fax calling tone.
Arne Marschall said about that: ``...Or try calling your modem with your
phone and whistle. If it says ``+fcon'' it is one one those which can't
deal with modems using a calling tone'' - try it.
.IP
Another, quite simplistic approach of some modem manufacturers is that
they distinguish Fax by waiting until the time specified in register
\&\fBS7\fR (time to carrier) runs out, and then switching from data to
fax carrier. That normally works quite well - if the other side is patient
enough to wait that ling \&.... For example, if the modem
switches to fax after 60 seconds have passed, and the caller has a timeout
of 50 seconds, it will definitely fail. If in doubt, try setting
\&\fBATS7=30\fR (but only if all else fails - and don't ask \fIme\fR why it
doesn't work...)
.IP
.IP \(bu\ 
Except if you \fBknow\fR that your modem needs less, do not try to
send or receive faxes with a port speed of less than 19200 bps. Since fax
transmission is synchronous (no start and stop bit!), you need at least
12000 bps on the Computer-Modem line to transmit 9600 bps on the line.
.IP
.IP \(bu\ 
For some modems, incoming faxes are detected properly, but mgetty times
out about two minutes later in \fBfax_wait_for(OK)\fR. Most likely, the
\&\fBFAX_RECEIVE_USE_B19200\fR
is set wrongly. Nearly all cheapo modems (e.g. Rockwell-Chip based ones)
step to 19200 bps upon fax reception, and defining this (in
\&\f(CW\`policy.h\'\fR) will tell mgetty about it. Better modems have no
need for that, but if you have defined it and your modem does *not* change
bit rates, it won't work either.
.IP
.IP \(bu\ 
For a couple of modems, you can find initialization and setup hints in the
file \f(CW\`doc/modems.db\'\fR. Just browse through it, maybe you'll find
something helpful. (You're welcome to provide entries for modems not yet
in the list).
.IP
.PP
.NH 3
ZyXEL
.br
.PP
First of all, yes, ZyXELs tend to somewhat non-deterministic behaviour -
some modems work with \fBmgetty+sendfax\fR, others don't, and I do not
always find out what's wrong.
.PP
If it works first, and then suddenly stops working, it does quite often
help do to a \fBfull\fR modem reset, that is, switch it off, press the
DATA/VOICE key, switch it on again and hold the key for about 20 Seconds.
(That's for the 1496E and E+, for other models, it works differently,
check you manual). That cured the problems in some cases.
.PP
The same holds true after a firmware change: always do a full modem reset
in case you change the ROM version!
.PP
Do not use non-plus ZyXELs (the ``slower'' ones) for faxing with DTE
speeds above 38400 bps, I got a report that it won't work.
.PP
Do not use the \fBS18\fR register, set it to 0. Its purpose is for dumb
\&\fBgetty\fR programs where the modem has to change its baud rate back to a
certain value if some other program has modified it. Since \fBmgetty\fR
will reinitialize the modem anyway if another program has dialed out, the
\&\fBS18\fR register cannot improve anything, it can only harm (e.g., if it
is set to \fB3\fR, the modem will send any \fBRING\fR with 19200 bps ---
imagine what happens if \fBmgetty\fR sets the port to 38400 \&...)
.PP
\&\fBWarning:\fR If you use an old ZyXEL and try to send some complex
graphics (the ``tiger.ps'' example file in the GhostScript package is
known to produce this), it may lock up. This is because the ZyXEL
firmware had \fIlots\fR of bugs concerning hardware flow
control---sometimes the ZyXEL just forgot to raise CTS when it can
accept data again. The symptoms are that the transmission hangs, no
modem LEDs are flashing any more, the logfile won't grow any more and
the receiving machines hangs up after printing a partial page.
.PP
This bug has been fixed in ROM release 6.01, so you should consider
upgrading your eproms if you run into this. With ROM release 6.01 and
6.11a, it works correctly (a hundred-odd faxes sent without problems).
.PP
Rom releases I've never been able to make \fBsendfax\fR work reliably are
6.00 and 6.10 (6.10a works), and various 5.0x releases.
.PP
Fax polling (both server and client side) is broken in ROM 6.11a.
.PP
The very latest ROM releases, 6.12 and 6.13, work perfectly in every
possible aspect. I tried fax sending, receiving, polling, data calls,
\&\&... - and everything simply \fIworks\fR!
.PP
The latest ZyXEL roms can normally be found on ftp.sdsc.edu, in
\&\f(CW\`/pub/other/zyxel/r*\'\fR.
.PP
Some models, seemingly only the \f(CW\`EG+\'\fR (german telekom approved),
toggle the DCD line during the pre-page handshake, thus causing
\&\fBsendfax\fR to abort (with a ``I/O error'' during read/write
operations). You can work around this by defining
\&\fBFAX_SEND_IGNORE_CARRIER\fR in \f(CW\`policy.h\'\fR.
.PP
ZyXEL modems can do security callback (\fBAT*Gi\fR with \fBi\fR > 0).
With ROM releases up to 6.11a, this doesn't interact very well with
mgetty. If you want to use it anyway, send me a note and I'll describe
what to change (but be warned, mgetty operation will become somewhat
unreliable by those changes!). With 6.12, it works very good.
.PP
Oh, one additional note: ZyXELs can do voice recording and playback. Klaus
Weidner wrote a mgetty-derived program, \fBvgetty\fR, that will implement
an answering machine and a small voice mailbox using a ZyXEL. If you're
interested, you can find the source in the \f(CW\`voice\'\fR subdirectory.
(Note that there is no \f(CW\`vgetty.c\'\fR, it is built from \f(CW\`mgetty.c\'\fR.
If you have questions relating to vgetty only, please ask Klaus and not me
(I do not know anything about voice, I'm the fax and data guru). His e-mail
address is klaus@snarc.greenie.muc.de.
.PP
.NH 3
Telelink\ IMS\ 08\ Faxline+\ Modems
.br
.PP
Thanks to friendly support by MVS, Germany, I got a Telelink IMS 08 modem
for testing and was able to adapt \fBmgetty\fR accordingly.
.PP
The modems factory defaults are very good, so it's sufficient for
\&\fBmgetty\fR operations to define \fBMODEM_INIT_STRING\fR to
\&\fBAT&F2S0=0&D3X6&K3\fR, and to define \fBFAX_RECEIVE_USE_B19200\fR (yep,
it switches baud rate.  Stupid, but true). After that, receiving fax + data
calls works fine.
.PP
Fax sending is not that trivial. Basically, it works after defining
\&\fBFAX_MODEM_HANDSHAKE\fR to \fB&K3\fR. \fBFAX_SEND_FLOW\fR can be
anything that the host machine supports (because the modem does both
Xon/Xoff and RTS/CTS handshake simultaneously).
.PP
Unfortunately, a few problems remain:
.PP
-- faxing multi-page faxes to ZyXELs with ROM release 6.11a doesn't work
(fails on the receiving end with +FHNG:100 and on the sending side with
+FHNG:50).
.PP
-- faxing to some paper fax machines fails completely, for others, ``only''
complex graphics (like the Ghostscript-``tiger.ps'') fail. This one can be
partially cured by adding lots of padding zeroes into the fax data
(\fBg3cat -p 24\fR) - but that's unelegant, not complying to class 2
specs, and not supported (besides, it still doesn't work all the
time). Maybe later versions of \fBsendfax\fR will do the padding
automatically.
.PP
I recommend against using this modem with sendfax. In addition to the
technical problems, their customer support (at least, that of the german
distributor MVS) is basically non-existant. (I wrote them four times
describing my problems with the modem, and never got an answer).
.PP
.NH 3
Rockwell-based\ modems,\ e.g.\ Supra
.br
.PP
As far as I know, sending or receiving are no problem (although you have to
use 19200 baud when in class 2 faxmode - set \fBDEFAULT_PORTSPEED\fR and
\&\fBFAX_SEND_BAUD\fR to \fBB19200\fR in \f(CW\`policy.h\'\fR, or define
\&\fBFAX_RECEIVE_USE_B19200\fR if you want to accept data calls with more
than 19200 bps). Remember to change the modem initialization strings to the
proper values for your modem, that is, change \fBAT&H3&N0&K4\fR to
\&\fBAT&K3\fR.
.PP
Especially for the \f(CW\`SupraFax\'\fR modem, I've been told that you have
to define \fBFAX_MODEM_HANDSHAKE\fR to \fB&K3\fR and initialize the
modem with \fBAT&S0&D2&K3\fR. Since the modem does not like being
reset with DTR->low (do \fBnot\fR use \fB&D3\fR!), an \fBATZ\fR in
the first initizalization string in \f(CW\`mgetty.c\'\fR, to reset the modem
into a known state, is a good idea, too.
.PP
(Thanks to Christof Junge, chris@cj.in-berlin.de, for trying out several
weeks until everything worked!)
.PP
Some other SupraFAX Rom releases seem to forget that they are set to use
RTS/CTS handshake if a \fB+FCLASS=0\fR is sent to them. I think it should
help to store the \fBAT&K3\fR into NVRAM, but maybe you have to patch
\&\f(CW\`mgetty.c\'\fR. See \f(CW\`contrib/readme.supra\'\fR for details.
.PP
Fax polling does not work because the Rockwell chipset does not support it.
.PP
.PP
.NH 3
Zoom\ VFP/VFX\ 24K\ FaxModem\ (V.FAST\ modem,\ 24,000\ bps)
.br
.PP
For the Zoom V.FAST 24,000 modem, you should change
\&\fBMODEM_INIT_STRING\fR to \fBAT&FS0=0&C1&D2W1\fR (see the manual for the
meaning of the commands). After that, everything should work. (I got very
euphoric reports).
.PP
My own experience with my Zoom VFX 28.800 is also quite good, but it
doesn't seem to like automatic fax/data distinction too much, that is, some
data calls are ``recognized'' as fax and fail miserably. Dunno how to fix
it, I run my Zoom as data-only.
.PP
.PP
.NH 3
Best\ 14496\ EC\ fax\ modem
.br
.PP
Works quite well. Use \fBFLOW_HARD\fR for all flow control settings, use
19200 bps for sending and receiving. Define \fBMODEM_INIT_STRING\fR to
\&\fBAT S7=60 &D3 \e\e\e\eQ3 %C1 \e\e\e\eN7\fR, and \fBFAX_MODEM_HANDSHAKE\fR to
\&\fB\e\eQ3&S0\fR. 
.PP
After that it should work. Kudos to Sami Koskinen (tossu@krk.fi).
.PP
.NH 3
GVC\ FM-144Vbis+/1\ (Rockwell-based)
.br
.PP
Basically, the modem is similar to the SupraFax modem.
.PP
Change \fBFAX_SEND_BAUD\fR and \fBDEFAULT_PORTSPEED\fR in
\&\f(CW\`policy.h\'\fR to \fBB19200\fR, remove the ZyXEL-specific stuff
(\f(CW\`AT&N0&K4&H3\'\fR) from the initialization (\fBMODEM_INIT_STRING\fR)
in \f(CW\`policy.h\'\fR; #define \fBFAX_MODEM_HANDSHAKE\fR as \fB"&H3"\fR
instead of \fB"&K4"\fR.
.PP
Further, if your model toggles DCD betwen fax pages (\fBsendfax\fR fails
mysteriously between pages), \fB#define FAX_SEND_IGNORE_CARRIER\fR.
.PP
After that, it should work.
.PP
Note: If your modem doesn't properly distinguish incoming fax from data
calls (i.e., a 2400 bps caller is repeatedly ``identified'' as fax caller),
upgrade your firmware. I've been told (thanks to John Watson,
watson%carssdf@rutgers.edu) that a new firmware release, \fBv1.69\fR
exists that will fix those problems.
.PP
.NH 3
CREATIX\ Modem\ (Rockwell-Based)
.br
.PP
For the new CREATIX modem, use the following defines in \f(CW\`policy.h\'\fR
(thanks to Jens Hektor, jens@mclane.physiology.rwth-aachen.de):
.PP
.DS
.ft CW
#define DEFAULT_PORTSPEED B38400
#define MODEM_INIT_STRING "ATS0=0Q0&D3&K6"
#define FAX_MODEM_HANDSHAKE "&K6"
.DE
.ft R
.PP
The modem has a voice mode, too, and it should work with \fBvgetty\fR by
now, though I'm not really sure of it -- it's supported, but not very well
tested.
.PP
.NH 3
German\ Telekom\ approved\ GVC\ modems
.br
.PP
(GM-144VBIS+  RC9696/14 (?))
.PP
This modem does \fInot(!)\fR use Xon/Xoff flow control. Further, the default
modem profile sets \f(CW\`&S1\'\fR, which makes the modem disable DSR all the
time. On systems using the FAS serial driver, this will \fIdisable
CTS flow control\fR!
.PP
So, #define \fBFAX_MODEM_HANDSHAKE "\e\eQ3&S0"\fR in \f(CW\`policy.h\'\fR, do not
define \fBFLOW_SOFT\fR for flow control, and fax sending should work. (It
does for me!)  Changing \fBFAX_SEND_BAUD\fR to \fBB19200\fR is not
necessary, it works with \fBB38400\fR.
.PP
Fax receiving... I did not fully test it. It's somewhat difficult since
that modem insists on using auto-answer, but it should be possible to let
it auto-answer if you set mgetty's ring counter high enough. Or, you can
trick the modem, by changing mgetty's answer command (\fBATA\fR) into
\&\fBATS0=1\fR -- upon the next RING, the modem will ``auto-answer''.
.PP
.NH 3
Dallas\ Fax\ 14.4
.br
.PP
Change \fBFAX_SEND_BAUD\fR and \fBDEFAULT_PORTSPEED\fR to
\&\fBB19200\fR, change all occurances of \f(CW\`AT&H3\'\fR to \f(CW\`AT&K5\'\fR, remove
\&\f(CW\`AT&N0\'\fR and \f(CW\`&K4\'\fR in \f(CW\`policy.h\'\fR.
.PP
.NH 3
Everex
.br
.PP
All I programmed is strictly to everex specs, thus, it should work.
Most likely, some fiddling with the initialization strings is necessary.
(If you have an Everex modem, please report to me what you did change).
.PP
.NH 3
Exar\ 9624\ fax\ modem
.br
.PP
This modem needs two stop bits (when sending), so you have to add
\&\fBCSTOPB\fR to \fBtio.c_cflag = \&...\fR in \f(CW\`tio.c\'\fR
/ \fBtio_mode_sane()\fR.
.PP
Also, use \fB#define FAX_SEND_BAUD B19200\fR and, for fax reception,
\&\fB#define DEFAULT_PORTSPEED B19200\fR.
.PP
Further, the modem is a little bit timing critical - please insert
\&\fBdelay(500)\fR calls at the end of \fBfax_open_device()\fR
(\f(CW\`sendfax.c\'\fR, line 122) and before sending the page punctuation
(\fBfax_command("+FET=...")\fR in \f(CW\`sendfax.c\'\fR, \fBmain()\fR, around
line 540).
.PP
Also, for at least one Exar 9624 (built into a Compaq notebook), it's been
necessary to add two delays (\fB\e\ed\e\ed\fR) before the \fBAT+FCLASS=0\fR
initialization string in \f(CW\`mgetty.c\'\fR.
.PP
.NH 3
Tornado\ /\ Lightspeed\ modems
.br
.PP
Here is a suggested setting for the default profile for these modems.
See section Common
.PP
For Lightspeed store profile:
.DS
.ft CW
at&f
at&c1
at&d3
ats0=0
at%c2
atw1
at&w
.DE
.ft R
.PP
and for tornado store profile:
.PP
.DS
.ft CW
at&f
at&d3
ats0=0
at&w
.DE
.ft R
.PP
Then just initialize the modem with \fBMODEM_INIT_STRING\fR set to
\&\fBATZ\fR.
.PP
.NH 3
Zoltrix\ Platinum\ Series\ 14.4
.br
.PP
This modem is also Rockwell-based, so don't expect anything unusual... - it
works quite well, both fax sending and fax/data answering. You should use
the following settings in \f(CW\`policy.h\'\fR (suggested by las@io.org, Laszlo
Herczeg)
.PP
.DS
.ft CW
#define DATA_FLOW	FLOW_HARD
#define FAXREC_FLOW	FLOW_SOFT
#define FAXSEND_FLOW	FLOW_SOFT
#define FAX_SEND_BAUD B38400
#define FAX_MODEM_HANDSHAKE "&K3"
#define MODEM_INIT_STRING	"ATS0=0V1Q0&D3&K3%C1W1"
.DE
.ft R
.PP
In some circumstances, sending of \fBlarge\fR graphics files (the
well-known \f(CW\`tiger.ps\'\fR) may fail.
.PP
.NH 3
MultiTech\ modems\ (MT1432BG)
.br
.PP
First of all, I want to thank MultiTech Munich for their support (borrowing
me two test modems w/o charge).
.PP
Second, I can only strongly recommend this modem, it's \fBgreat\fR. Got
it, unpacked it, switched it on, set mgetty's init string
(\fBMODEM_INIT\fR) to \fBATS0=0&S1\fR -- and everything simply
worked. Flawlessly. (Warning: usually I recommend \fBAT&S0\fR to force
the DSR line high -- needed, because otherwise some O/Ses won't do
hardware flow control -- but that doesn't seem to work on my model. AT&S1
means that H/W flow control only works when a carrier is present, but
then, who needs flow control in command mode?)
.PP
The modem does very reliably distinguish incoming fax and data calls, and
outgoing fax works also very good (unfortunately, it's limited to 9600 bps
fax rate, but that's no big problem).
.PP
The only problem I've seen is that this modem does the fax bit order on
reception \fBright\fR (everybody else does it wrong, to be compatible
with Rockwell, who botched it in the first place). Thus, \fBg3topbm\fR
won't be able to decode the data, unless you call it as \fBg3topbm -r\fR.
(You can see if the bit order is wrong if g3topbm complains in every single
line). I'll work something out for one of the next releases to work around
this.
.PP
Glenn Thobe suggested the following definitions for \f(CW\`policy.h\'\fR (which
mostly are factory defaults anyway, but it wouldn't harm to set them)
.PP
.DS
.ft CW
#define MODEM_INIT_STRING	"ATS0=0Q0&D3&E1&E4&E13&E15"
#define FAX_MODEM_HANDSHAKE "&E4"
.DE
.ft R
.PP
.NH 3
Elink\ ISDN\ Terminal\ Adaptors\ 293,\ 310,\ 393\ with\ X.75\ and\ V.110
.br
.PP
The TA's are connected to national German ISDN (1TR6) or Euro-ISDN. The
host side is a standard serial port with an AT-command set, letting them
look like a conventional modem. Therefore they are often (wrongly) called
\&'ISDN modems'.
.PP
It is strongly recommended to feed them with 115k2 bps, else only V.110
(38k4 bps) is available. Configuration may differ slightly, depending on
which of those Elinks is used, wether it is connected to Euro-ISDN or 1TR6
and not at least they are still under developement, so you're on your own
with that.
.PP
ISDN generally supports two nice features: first it is now possible to
check callers number, which may be used to identify callers, second ist
the charge service, where it is possible to request the amount of charge
units for the call. For mgetty the second one is only from minor interest,
but the first one is.  The opposite phone number will be shown with the
command \fBAT\e\eO\fR. If a call comes in, \fBAT\e\eOA\fR will answer the
call, display caller's id in a 'digit only' (e.g. \f(CW\`04419808550\'\fR) form
and then print out the \fBCONNECT\fR-String.
.PP
To enable mgetty to utilize this, the answer-string must be changed
accordingly and the \f(CW\`CND\'\fR feature must be enabled:
.PP
Use \fBchar *answer_chat_seq = { "", "AT\e\e\e\eOA", ... }\fR in
\&\f(CW\`mgetty.c\'\fR (automatically done by defining \fB-DELINK\fR in
\&\f(CW\`Makefile\'\fR, \fBCFLAGS=...\fR), and \fB#define CNDFILE
"\&.../dialin.config"\fR at the end of \f(CW\`policy.h\'\fR.
.PP
With the resulting mgetty it is now possible to use \fBdialin.config\fR
as suggested (side note: it is not. Will be fixed).
.PP
Having a glance at the output of \fBAT I4\fR-output of the Elink, it looks
as if it is able to support Fax-Service too, but there is no hint in the
manual. So mgetty will likely put itself into data-only mode.
.PP
(Thanks to Ulrich Tieman, lord@olis.north.de, for this section. Don't ask
me, ask him if you use an ELINK)
.PP
.NH 3
Class\ 1\ Faxmodems
.br
.PP
These do not work. They are not going to be supported (class 1 faxing is
a mess, and the timing is extremely critical---nearly impossible in a
unix environment---read the comments to the FlexFax package for
details).
.PP
.NH 2
Operating\ Systems
.br
.PP
This section describes problems that have occured while porting the
package to various operating systems.
.PP
.PP
If your system is not in the list, that doesn't mean it won't work. It
just means that I didn't get a report (or a port) for that system yet.
.PP
mgetty+sendfax should work on most unixoid operating systems, as long as
they provide \fBSysV termio\fR or \fBPOSIX termios\fR call for tty
management. \fBBSD sgtty\fR support isn't finished yet.
.PP
For best results, your system should have \fBselect(S)\fR or
\&\fBpoll(S)\fR, but if both functions are not available or don't work on
ttys (\fBpoll(S)\fR is known to do this on SVR3.1 and earlier), you can
use a kludge, \fB-DUSE_READ\fR.
.PP
Besides that, you'll need some fiddling with the header files to get all
defines and prototypes right.
.PP
Further, you'll have to check \f(CW\`tio.c\'\fR, function
\&\fBtio_set_flow_control()\fR, whether the way hardware flow control is
activated works on your system. Most likely, it won't --- that's one of the
major portability problems. If you change something and get it to work,
please send me patches. (You're welcome to do so anyway).
.PP
.NH 3
SCO\ Unix\ 3.2.2\ (ODT\ 1.0\ /\ 1.1)
.br
.PP
No major twiddling needs to be done. If your \fBselect()\fR refuses to
sleep less than one second, use poll(S) instead (set \fB-DUSE_POLL\fR in
the CFLAGS section of \f(CW\`Makefile\'\fR).
.PP
Use the modem-control devices for mgetty and dial-outs (e.g.
\&\f(CW\`/dev/tty2A\'\fR), or (far better), use FAS with minor number of 80+port,
using full RTS + CTS handshake, and non-blocking opens (\f(CW\`/dev/ttyF01\'\fR)
- the original SCO serial driver is slow, unreliable and doesn't do proper
hardware flow control. See section SCO-324.
.PP
Ignore all the warnings about ``passing arg 2 of signal from
incompatible pointer type''. They are caused because the SCO 3.2.2
development system header files are somewhat unusual.
.PP
.NH 3
SCO\ Unix\ 3.2.4\ (ODT\ 2.0\ and\ ODT\ 3.0)
.br
.PP
I'm using mgetty on SCO 3.2v4(.2) (in fact, developing it there), so be
assured: it works.
.PP
I consider the way that hardware flow control is handled on SCO to be
broken, so I \fIstrongly\fR recommend using the \fBFAS\fR serial driver
(version 2.11 or higher, earlier versions may crash the system), to be
found on your nearest comp.sources.unix
archive. With \fBfas\fR, use the devices with a minor number of
\&\f(CW\`80+port number\'\fR for best results. Make sure that your modem enables
the \f(CW\`DSR\'\fR line, because otherwise, \fBFAS\fR won't do hardware
handshake.
.PP
If you don't use \fBfas\fR, I've been told that you have to use the
\&\f(CW\`modem control\'\fR lines, that is, the ``uppercase'' lines, e.g.
\&\f(CW\`/dev/tty1A\'\fR, because SCO's serial driver won't do any hardware flow
control at all on the ``lowercase'' lines. Be warned, the driver will also
disable hardware flow control if you use Xon/Xoff flow control (no way to
use both). Since I do not have a SCO system without \fBfas\fR, I'd like to
hear very much about results on one.
.PP
Also, you've to define \fBLOCKS_LOWERCASE\fR, since that's the convention
on SCO Unix and most other programs expect it.
.PP
If mgetty works only partially, but hangs the moment \f(CW\`/etc/issue\'\fR
is printed, before the `system!login:' prompt is output, you may have to
change the following line of \f(CW\`mgetty.c\'\fR (around line 540):
.PP
.DS
.ft CW
        /* honor carrier now: terminate if modem hangs up prematurely
	 */
	tio_carrier( &tio, TRUE );
.DE
.ft R
.PP
to:
.PP
.DS
.ft CW
        tio_carrier( &tio, FALSE );
.DE
.ft R
.PP
But before you do this, make sure that your modem enables the CD line
while a carrier is present (Hayes modems: \f(CW\`AT&C1\'\fR) and also enables
the DSR line (otherwise the port will block once \fBCLOCAL\fR is
removed).
.PP
This could have been a problem specific to Uwe's dumb AST-compatible
fourport card, but I do not think so.
.PP
.PP
Compilation issues:
.PP
Ignore warnings about \f(CW\`struct utimbuf\'\fR and \f(CW\`struct timeb\'\fR, they
are caused by improper include files. On SCO 3.2v4.2, ignore the warnings
about the getopt() prototype, or change prototype or include files.
.PP
.PP
Installation:
.PP
SCO provides two utilities to manipulate \f(CW\`/etc/inittab\'\fR,
\&\fBenable\fR and \fBdisable\fR. Those tools work only if you have
specified a gettydefs tag on the \fBmgetty\fR command line, otherwise
they will complain about ``not a valid tty''. So, either append the
gettydefs tag (\fBmgetty\fR will ignore it if not compiled with
\&\fBUSE_GETTYDEFS\fR) or change \f(CW\`/etc/inittab\'\fR manually.
.PP
.NH 3
Linux
.br
.PP
Hardware handshake (RTS+CTS) on Linux works flawlessly (but only if mgetty
is compiled with POSIX_TERMIOS, but that should be default on Linux
anyway). Nevertheless, the \fBscrts.c\fR program in \f(CW\`contrib/\'\fR is
still provided, it has some other uses, too.
.PP
Linux versions prior to 0.99pl15 have a bug in the serial handshake code,
that is, if the \fBCRTSCTS\fR flag is set, software (Xon/Xoff) flow
control won't work. Teodore Ts'o promised me to fix it in newer kernels, I
think the fix went into 99pl14n or so.
.PP
If you have very old (4.1) or otherwise broken (4.4.2) shared libraries,
the alarm() call does not work reliably. This results in a fax receive
aborting with a message like ``alarm clock'' or something similar
(sometimes in the same second that the fax reception started). Upgrade
your libraries to 4.4.1 or 4.4.4.
.PP
Linux has no poll(S), so, don't #define \fBUSE_POLL\fR, and the default,
\&\fBUSE_SELECT\fR, will be used.
.PP
\&\fBImportant note:\fR Use the \f(CW\`/dev/ttyS*\'\fR devices for getty and
for dial-out (that is, for kermit, uucico, cu, seyon, ...) - \fBnever\fR
use \f(CW\`/dev/cua*\'\fR. Dialing out on \f(CW\`/dev/cua*\'\fR will result in the
error message ``device busy''. (There are reasons why \fBmgetty\fR cannot
use the ``\f(CW\`ttyS*\'\fR vs. \f(CW\`cua*\'\fR kernel locking mechanism'', see
below), and dialing in (ugh) on \f(CW\`/dev/cua*\'\fR will result in dozens of
strange things happening because the process won't get a controlling tty.
.PP
Some guys seemingly can't resist posting misinformation to the net all the
time, don't believe 'em. The \f(CW\`/dev/cua*\'\fR devices are \fBnot\fR
different from the \f(CW\`/dev/ttyS*\'\fR devices concerning data flow or modem
control lines. The only difference is how the device reacts if you do an
\&\fBopen()\fR: Opening \f(CW\`/dev/ttyS*\'\fR normally blocks until the ``carier
detect'' line goes active (unless \fBopen()\fR is called with the
\&\fBO_NDELAY\fR flag; \fBmgetty\fR and all dial-out programs do that), and
opening \f(CW\`/dev/cua*\'\fR will return an error message (\fBerrno=EBUSY\fR)
if another process has the device already open, thus \fIpreventing
dial-out on \f(CW\`/dev/cua*\'\fR\fR if \fBmgetty\fR is active on
\&\f(CW\`/dev/ttyS*\'\fR.
.PP
We use \f(CW\`/dev/ttyS*\'\fR all the time for dial-in \fIand\fR for dial-out,
and believe me, it works, and it's the \fIonly\fR combination that will
work properly. The kernel locking mechanism only works if you use modem
auto-answer (the getty process sleeps until the modem gets a carrier), and
mgetty uses manual answer (it waits for the RING message from the modem),
which will save your callers a lot of grief because their calls will
only be answered if your computer is ready to receive a call. Part of the
motivation for writing mgetty was being tired of losing lots of money
for useless calls to a hung machine.
.PP
There are various different \fBinit\fR and \fBlast\fR programs out there,
some work with mgetty, some don't. If you get some strange output from
\&\fBwho\fR or \fBlast\fR and are using a different \fBinit\fR program
than the \fBsysv init\fR, try to define \fB-DNO_SYSVINIT\fR. That should
help.
.PP
I've been told that it's necessary to do that if you use the
\&\fBsimple-init\fR.
.PP
Anyway, I can only \fBstrongly\fR recommend to switch over to
\&\fBSysVinit\fR if you use \fBsimple init\fR, since the latter seems to
be severely broken regarding utmp and controlling tty handling.
.PP
.NH 3
ISC
.br
.PP
The ISC port has finally been completed, thanks to Russell Brown,
russell@lutton.lls.com.
.PP
First of all, define \fB-DISC\fR in the Makefile. This will take care
of some minor problems. Then, link with \fB-linet -lpt\fR.
.PP
If you have a ISC Unix 4.0, you may have to define \fB-D_POSIX_SOURCE\fR
to get around some include file problems and link \fB-lcposix\fR.
.PP
If you have problems with the AWK programs in the \f(CW\`fax/\'\fR shell
scripts, try defining \fBAWK=nawk\fR in the \f(CW\`Makefile\'\fR. That should
take care of those problems.
.PP
Again, for best results I recommend using the FAS serial driver, and
using a port with a minor number of 80+portno (ttyF01 etc.)
.PP
If you use a Digiboard smart serial cart (e.g. the digiboard pc/8e), use
the \f(CW\`/dev/ttyi*\'\fR devices instead of \f(CW\`/dev/cui*\'\fR, becaus only the
former ones honour carrier drops (If you use \f(CW\`cui*\'\fR, your processes
won't die if the modem unexpectedly hangs up)
.PP
.PP
.NH 3
SVR4\ Unix
.br
.PP
mgetty has been ported to SVR4 now (many thanks to Bodo Bauer,
<bodo@hal.nbg.sub.org> and Martin Husemann, <martin@bi-link.owl.de>).
.PP
As far as I know, it's sufficient to add \f(CW\`-DSVR4\'\fR to the CFLAGS in
Makefile. If you have any problems or suggestions, please report them
also to Bodo, since I do not have a SVR4-System to run tests on.
.PP
If you use the \fBSAS\fR serial driver (streams-version of \fBFAS\fR) and
want to force \fBsas\fR to use hardware-handshake all the time, use a
device with a minor device number of \fB80+port number\fR (see the
\&\fBsas\fR manual for explantations). If you use a port with a minor device
number of \fB7*16+i\fR, \fBmgetty\fR is able to switch hardware handshake
on and off according to the flags set in policy.h, using
\&\f(CW\`sys/termiox.h\'\fR. (Well, it works - but apparently fax reception
doesn't work with this minor device number. Symptom: only one byte is
received during fax reception (0x00). Anybody any clue?). 
.PP
If you use \fBFAS\fR, use the devices with a minor device number of
\&\fB80+port number\fR (as usual).
.PP
.NH 3
SVR4.2\ -\ Onsite\ Unix,\ UnixWare,\ ...
.br
.PP
Basically, SVR4.2 is quite similar to SVR4, but you have to watch out for
some details (defining \fB-DSVR42\fR in the Makefile will do it for you).
.PP
Most important, the \fItermiox\fR interface via the \fBTCGETX\fR /
\&\fBTCSETX\fR \fBioctl()\fRs does not seem to work any longer - the calls
return an error, and the port behaves strangely. If you're experiencing
this, please try commenting out the corresponding code in \f(CW\`tio.c\'\fR,
funtion \fBtio_set_flow_control()\fR and mail me whether that make it
work.
.PP
Further, ussing \fBUSE_POLL\fR or \fBUSE_READ\fR, won't work. The default
of \fBUSE_SELECT\fR is OK.
.PP
To enable hardware handshake, use the tty device with the trailing ``h'',
e.g.  \f(CW\`tty01h\'\fR. On the other one (\f(CW\`tty01\'\fR), the driver won't do
H/W handshake.
.PP
Depending on the configuration, parallel dial-out with Taylor-UUCP may fail
(uucico complaining that it cannot set \fBCLOCAL\fR), in that case, you've
to recompile Taylor with different settings for the \fBtermio\fR selection
(POSIX vs. SYSV).
.PP
Many thanks to Joerg Weber (joerg@interface-business.de) for finding all
those problems.
.PP
.NH 3
BSD-like\ flavours\ of\ Unix
.br
.PP
A port to 386BSD, NetBSD, FreeBSD has been done by Martin Husemann,
martin@bi-link.owl.de, and Gunther Shadow, gusw@fub46.zedat.fu-berlin.de.
.PP
I think it works quite well, except that the \fBVTIME\fR mechanism to
timeout \fBread()\fR calls doesn't work in older *BSD versions. If
\&\fBmgetty\fR hangs, with the last line in the log file being something
like ``waiting for line to clear'', upgrade your kernel, or, if you can't
do that, compile \fBmgetty\fR with \fB-DBROKEN_VTIME\fR (in that case,
select() will be used).
.PP
For older versions of BSD Unix that do not have \f(CW\`termios.h\'\fR, you'll
have to complete the unfinished support for \f(CW\`sgtty.h\'\fR in \f(CW\`tio.c\'\fR
and \f(CW\`tio.h\'\fR.
.PP
Generally, BSD Unices do not have a \f(CW\`/etc/inittab\'\fR as system V has.
Instead, they have \f(CW\`/etc/ttytab\'\fR. Thus, you have to enter a line like
.DS
.ft CW
cua0    "/usr/local/sbin/mgetty -x 3 cua0"       vt100
.DE
.ft R
there. Don't forget to remove (or comment out) the original getty on the
corresponding \f(CW\`/dev/tty*\'\fR line.
.PP
.NH 3
IBM\'s\ AIX\ Operating\ System
.br
.PP
Chris Lewis, Harald Milz and Michael Staats have done excellent work on
porting \fBmgetty\fR to AIX. I think that some problems may still remain,
but as far as I know, it works now.
.PP
On AIX it's not allowed to manipulate \f(CW\`/etc/inittab\'\fR directly,
instead, you've got to use some system administration tools. To ease
\&\fBmgetty\fR installation on AIX, Michael Staats has provided a small
shell script, \fBinittab.aix\fR, that will help you setup your
\&\f(CW\`inittab\'\fR after you've run \fBmake install\fR. Just call it with the
name of the tty you're modem is connected to, e.g. 
.PP
\&\fB./inittab.aix tty0\fR.
.PP
.NH 3
SunOS\ 4.1.1\ and\ up
.br
.PP
mgetty has been ported to SunOS, and the reports that I got until now
indicated success.
If you use SunOS, please send me a brief report about your results.
.PP
Thanks to Earl Hartwig, earl@fozzi.ocunix.on.ca, for the initial port.
.PP
For compilation, please define \fB-Dsunos4\fR.
.PP
In \f(CW\`policy.h\'\fR, you've to adapt the location of the LOCK files.
.PP
In all the shell scripts, set \fBecho='...'\fR to
\&\fB/usr/5bin/echo\fR, because the standard one doesn't
support escape codes like \f(CW\`\en\'\fR or \f(CW\`\ec\'\fR.
.PP
If a fax reception hangs shortly after the \f(CW\`+FCON\'\fR is seen, please try
setting \fBFAXREC_FLOW\fR to Xon/Xoff (\fBFLOW_SOFT\fR). Hardware
handshake has problems on SunOS versions without the ``Jumbo TTY'' patch.
.PP
Please use the ``outgoing'' devices (\f(CW\`/dev/cua*\'\fR) for mgetty and
dial-outs, using the ``incoming'' devices (\f(CW\`/dev/tty*\'\fR) will make
dialout impossible.
.PP
It is strongly recommended that you install the ``jumbo tty patch'' (patch
number 100513-04 for 4.1.2 or .3, patch number 101621-01 for 4.1.3_u1 and
up) because it will fix a lot misbehaviour of the serial line drivers.
.PP
Please read also the generic BSD section.
.PP
.NH 3
AT&T\ 3b1
.br
.PP
Glenn Thobe and Chris Lewis have ported mgetty+sendfax to AT&T's 3B1
machines, it should compile without changes to the source (but define
-D_3B1_ in the Makefile).
.PP
These ports are to two different environments:
.PP
Glenn's port was with GCC (ANSI C) and an add-on select() library routines. 
Chris's port was with stock 3b1 C, without select().
Both seem reliable.
.PP
Some further hints concerning a select() library and the pbmplus tools can
be found in the file \f(CW\`contrib/3b1\'\fR which are the notes from Glenn's
port.
.PP
Chris's port relies simply on the suggested definitions (especially
\&\fB-DUSE_READ\fR) in the Makefile.  Chris suggests that you use select()
if you already have it for some other reason, but that it seems to work
just fine without it.
.PP
.NH 2
General\ problems
.br
.PP
.PP
.NH 3
pbmtog3
.br
The \fBpbmtog3\fR program from the \f(CW\`pbmplus\'\fR distribution produces G3
data that does not adhere to the T.4 standard. The initial EOL code is
missing, and the lines are not always 1728 pixels wide.  So, some fax
machines won't accept the output at all (not printing even one line), and
others will complain.
.PP
A fix for this problem is available: I have included a patch for pbmtog3,
called \f(CW\`patches/pbmtog3.p1\'\fR, that will fix the problems. (Oh, by the
way, if you try to send a fax generated with an unpatched pbmtog3, sendfax
will complain that it doesn't like the file \&... I've added a small
sanity check to spare me the time browsing through the logfiles guessing
\&\fIwhy\fR sendfax failed (won't work if the file has been processed by
\&\fBg3cat\fR, though!)).
.PP
Basically, there is no need at all to use \f(CW\`pbmplus\'\fR' \fBpbmtog3\fR
program any more, since \fBmgetty\fR includes an own copy. I just wanted
to warn you --- for example, if you install \f(CW\`pbmplus\'\fR \fIafter\fR
\&\fBmgetty\fR, my program will get overwritten and that will lead to
problems sending faxes, unless you have applied the patch.
.PP
Anyway, my program is lots faster \&....
.PP
.NH 3
Lock\ files
.br
Kermit et.al. cannot dial out while mgetty is running (modem responses
are eaten by mgetty)---what's wrong?
.PP
Most propably, you have not configured the \fBLOCK\fR and
\&\fBLOCKS_BINARY\fR defines in \f(CW\`policy.h\'\fR properly. Make sure that
the lockfiles kermit (or cu, pcomm, seyon,\&...) expect are in the
path specified in \fBLOCK\fR and set \fBLOCKS_BINARY\fR to 1 if they do
not write the PID of the locking process in ascii (10 bytes) to the lock
file but as a 4-byte integer instead. Mgetty and Sendfax will understand
both types of lock files, but if \fBLOCKS_BINARY\fR is not set properly,
other programs may not understand the lock file.
.PP
Also, make sure that both processes use the same name for the device.
(i.e., mgetty locking \f(CW\`/dev/ttyS0\'\fR and kermit locking
\&\f(CW\`/dev/modem\'\fR will definitely fail.)
.PP
.NH 3
ECU\ 3.20\ or\ earlier\ on\ SCO\ collides\ with\ mgetty
.br
.PP
ECU releases 3.20 and earlier had a severe bug in the utmp handling that
prevented dialing out on a port that mgetty uses. It has been fixed in ECU
3.27. If you run into that problem, please get a newer release.
Alternatively, you can use the patch that Uwe Fuerst provided, it can be
found in \f(CW\`patches/ecu320.p1\'\fR.
.PP
.NH 2
Sample\ Log\ files
.br
.PP
Both mgetty and sendfax can provide logfiles that can be very helpful for
debugging and accounting purposes. The amount that is logged is controlled
with the default set in \f(CW\`policy.h\'\fR and the command line argument
\&\fB-x <level>\fR. Higher numbers give more details.
.PP
At this place, I want to show you some typical cases, so you can compare
your log files to those given here and check what is different.
.PP
(Note: naturally all the modem initializations, and also some of the modem
responses, vary between modem brands!)
.PP
All the mgetty log files have been done with log level \fBL_MESG\fR, that is,
\&\fB-x 4\fR. The sendfax log file was done with \fBL_NOISE\fR, \fB-x 5\fR.
.PP
.PP
.NH 3
mgetty,\ incoming\ data\ call
.br
.PP
This is a log file of a typical data connection, ZyXEL-to-ZyXEL modems,
connect with 19200 bps on a port speed of 38400, login as "Uartinet", the
login program called is \fB/usr/lib/uucp/uucico\fR (controlled by
\&\f(CW\`LOGIN_CFG_FILE\'\fR, which directs all login names starting with "U" to
uucico)
.PP
.DS
.ft CW
03/03 22:40:15  check for lockfiles
03/03 22:40:15  locking the line
03/03 22:40:16  lowering DTR to reset Modem
03/03 22:40:16  send: \ed\ed\ed+++\ed\ed\ed[0d]\edATQ0V1H0[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  send: ATS0=0Q0&D3&H3&N0&K4[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  send: AT+FCLASS=0[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  send: AT+FAA=1;+FBOR=0;+FCR=1[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  send: AT+FLID="49 89 3243328"[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  send: AT+FDCC=1,5,0,2,0,0,0[0d]
03/03 22:40:20  waiting for ``OK'' ** found **
03/03 22:40:20  fax_command: send 'AT+FLPL=1'
03/03 22:40:20  fax_wait_for(OK)** found **
03/03 22:40:21  waiting...
03/03 22:41:28  waiting for ``RING'' ** found **
03/03 22:41:28  send: ATA[0d]
03/03 22:41:28  waiting for ``CONNECT'' ** found **
03/03 22:41:42  send: 
03/03 22:41:42  waiting for ``
\&'' ** found **
03/03 22:41:43 ##### data dev=tty4c, pid=6470, caller=none, conn='38400/ZyX  16800/V42b', name='', cmd='/usr/lib/uucp/uucico', user='Uartinet'
.DE
.ft R
.PP
.NH 3
mgetty,\ incoming\ fax\ call
.br
.PP
This is a log file of a fax call I got today. It was a fax call with 14400
bps (actually, the call came from another faxmodem, but you won't see that
in the log file), using high resolution. One page was received, the
connection time was 33 seconds. No errors occured.
.PP
(All the stuff up to "waiting\&..." is identical to the example above, so
I don't list it again)
.PP
.DS
.ft CW
[...]
03/03 21:39:32  waiting...
03/03 21:46:22  waiting for ``RING'' ** found **
03/03 21:46:22  send: ATA[0d]
03/03 21:46:22  waiting for ``CONNECT''
03/03 21:46:32  found action string: ``+FCON''
03/03 21:46:32  action is A_FAX, start fax receiver...
03/03 21:46:32  fax_wait_for(OK)
03/03 21:46:36  fax_id: '+FTSI:+31 20 6147110       '
03/03 21:46:36  transmission par.: '+FDCS:1,5,0,2,0,0,0,0'** found **
03/03 21:46:36  fax_command: send 'AT+FDR'
03/03 21:46:36  fax_wait_for(CONNECT)
03/03 21:46:37  fax_id: '+FTSI:+31 20 6147110       '
03/03 21:46:37  transmission par.: '+FDCS:1,5,0,2,0,0,0,0'** found **
03/03 21:46:38  fax_get_page_data: receiving /usr/spool/fax/incoming/ffd764c9e4d-+31-20-6147110.01...
03/03 21:46:51  fax_get_page_data: page end, bytes received: 24933
03/03 21:46:51  fax_wait_for(OK)
03/03 21:46:51  page status: +FPTS:1** found **
03/03 21:46:53  fax_wait_for(CONNECT)
03/03 21:46:55  connection hangup: '+FHNG:000'** found **
03/03 21:46:56 ##### fax dev=tty4d, pid=4807, caller=none, name='', id='+31 20 6147110       ', +FHNG=000, pages=1, time=00:00:33
.DE
.ft R
.PP
.NH 3
mgetty,\ logging\ into\ syslog
.br
.PP
If your system has a \fBsyslogd\fR and the \fBsyslog()\fR C function,
mgetty can send parts of its log files to the \f(CW\`syslog\'\fR (For details,
see comments in \f(CW\`policy.h\'\fR). Not all the information from the log file
is logged here (to avoid clobbering the syslog), just errors and so-called
"audit" messages (seen in the log file as lines with "####" at the
beginning). These have a fixed format, and could easily be parsed by a
program. Let me list a few, and then comment them.
.PP
.DS
.ft CW
Mar  3 18:36:16 greenie mgetty[673]: failed A_FAIL dev=tty4d, pid=673, caller=none, conn='', name=''
Mar  3 18:41:56 greenie mgetty[1866]: fax dev=tty4d, pid=1866, caller=none, name='', id='49 89 3243328        ', +FHNG=100, pages=1, time=00:00:29 
Mar  3 21:46:56 greenie mgetty[4807]: fax dev=tty4d, pid=4807, caller=none, name='', id='+31 20 6147110       ', +FHNG=000, pages=1, time=00:00:33 
Mar  3 20:45:59 greenie mgetty[4038]: data dev=tty4d, pid=4038, caller=none, conn='38400/V.32  9600/MNP5', name='', cmd='/bin/login', user='mbox'
Mar  3 22:41:43 greenie mgetty[6470]: data dev=tty4c, pid=6470, caller=none, conn='38400/ZyX  16800/V42b', name='', cmd='/usr/lib/uucp/uucico', user='Uartinet'
.DE
.ft R
.PP
Those five lines are one failed call, two fax calls, one of them failed and
one successful, and two data calls, one of a human caller, loggin into the
BBS system, and one of a calling uucico.
.PP
It looks very confusing until you understand the system behind it. The
first fields specify date and time, originating host (greenie is my
machine) and program (mgetty). The next field specifies the type of the
connection made: \f(CW\`fax\'\fR, \f(CW\`data\'\fR or \f(CW\`failed\'\fR - the latter one
usually means failure to initialize the modem or failure to connect to a
calling modem, resulting in the well-known \f(CW\`NO CARRIER\'\fR message...
.PP
The \f(CW\`dev\'\fR and \f(CW\`pid\'\fR fields specify the line and process ID of the
mgetty process writing that line.
.PP
The \f(CW\`caller\'\fR and \f(CW\`name\'\fR fields give caller ID information - if
none is available (as it is here in Germany), or if your modem doesn't
handle it, it will list \f(CW\`none\'\fR and \f(CW\`''\'\fR, respectively.
.PP
For fax calls, additional informations given are the remote station ID
(\f(CW\`id='\&...'\'\fR), the hangup code (\f(CW\`+FHNG=\&...\'\fR, 0 means "ok"),
the number of pages and the connection time.
.PP
For data calls, the string that the modem returned after \f(CW\`CONNECT\'\fR is
listed as \f(CW\`conn='\&...'\'\fR. The string that was entered at the login
prompt is listed as \f(CW\`user='\&...'\'\fR, and the program that is called
to do the login is given as \f(CW\`cmd='\&...'\'\fR. Usually this will be
\&\fB/bin/login\fR unless you have some special system setup for fido or
uucp callers - as I have here, as you can see above.
.PP
.NH 3
sendfax,\ sending\ a\ single\ page
.br
.PP
This is a simple one-page fax that I sent some days ago. Just a single
page, f1.g3, to the phone number 2710834. No errors of any kind occured.
.PP
.DS
.ft CW
02/18 11:10:05  sending fax to 2710834
02/18 11:10:06  checking f1.g3
02/18 11:10:06  makelock(tty4c) called
02/18 11:10:06  do_makelock: lock='/usr/spool/uucp/LCK..tty4c'
02/18 11:10:06  lock made
02/18 11:10:06  fax_open_device succeeded, tty4c -> 4
02/18 11:10:06  fax_command: send 'AT'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'AT'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'AT+FCLASS=2'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'AT+FCLASS=2'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'AT+FLID="49 89 3243328"'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'AT+FLID="49 89 3243328"'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'ATL7M1'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'ATL7M1'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'AT+FDCC=1,5,0,2,0,0,0,0'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'AT+FDCC=1,5,0,2,0,0,0,0'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'AT+FBOR=0'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:06  fax_wait_for: string 'AT+FBOR=0'
02/18 11:10:06  fax_wait_for: string 'OK'** found **
02/18 11:10:06  fax_command: send 'AT&H3D2710834'
02/18 11:10:06  fax_wait_for(OK)
02/18 11:10:07  fax_wait_for: string 'AT&H3D2710834'
02/18 11:10:39  fax_wait_for: string '+FCON'
02/18 11:10:39  fax_wait_for: string '+FNSF:00 00 00 00 '
02/18 11:10:39  fax_wait_for: string '+FCSI:       49 89 2710834 '
02/18 11:10:39  fax_id: '+FCSI:       49 89 2710834 '
02/18 11:10:39  fax_wait_for: string '+FDIS:1,3,0,2,0,0,0,4'
02/18 11:10:39  fax_wait_for: string 'OK'** found **
02/18 11:10:39  fax_send_page("f1.g3") started...
02/18 11:10:39  fax_command: send 'AT+FDT'
02/18 11:10:39  fax_wait_for(CONNECT)
02/18 11:10:39  fax_wait_for: string 'AT+FDT'
02/18 11:10:45  fax_wait_for: string '+FDCS:1,3,0,2,0,0,0,4'
02/18 11:10:45  transmission par.: '+FDCS:1,3,0,2,0,0,0,4'
02/18 11:10:45  fax_wait_for: string 'CONNECT'** found **
02/18 11:10:45  waiting for XON, got:[0a][11]
02/18 11:10:45  sending f1.g3...
02/18 11:11:03  sending DLE ETX...
02/18 11:11:03  fax_wait_for(OK)
02/18 11:11:16  fax_wait_for: string 'OK'** found **
02/18 11:11:16  fax_command: send 'AT+FET=2'
02/18 11:11:16  fax_wait_for(OK)
02/18 11:11:16  fax_wait_for: string 'AT+FET=2'
02/18 11:11:25  fax_wait_for: string '+FPTS:1'
02/18 11:11:25  page status: +FPTS:1
02/18 11:11:26  fax_wait_for: string '+FHNG:00'
02/18 11:11:26  connection hangup: '+FHNG:00'
02/18 11:11:26  (Normal and proper end of connection)
02/18 11:11:26  fax_wait_for: string 'OK'** found **
02/18 11:11:26  fax_send: 'AT+FCLASS=0^M'
02/18 11:11:26  removing lock file
.DE
.ft R
.PP
.NH 2
How\ to\ get\ the\ mentioned\ software\ by\ ftp
.br
.PP
Most of the software mentioned in this document should be available on most
major ftp sites. Nevertheless, I've got so many questions about the
software that I'll list some ftp sites here.
.PP
Furthermore, I'll list some other software that may be interesting if you
plan to use \fBmgetty+sendfax\fR in different environments than I do.
.PP
.IP \(bu\ 
\&\fBmgetty+sendfax\fR
.IP
The current release can usually be found at:
.IP
sunsite.unc.edu:\f(CW\`/pub/Linux/system/Serial/mgetty+sendfax*\'\fR
.IP
tsx-11.mit.edu:\f(CW\`/pub/linux/sources/sbin/mgetty+sendfax*\'\fR
.IP
ftp.leo.org:\f(CW\`/pub/comp/networking/communication/modem/mgetty/*\'\fR
.IP
\&\&... and on all sites that mirror SunSITE.unc.edu or tsx-11.
.IP
The current beta release is always placed at:
.IP
ftp.informatik.tu-muenchen.de:\f(CW\`/tmp/mgetty.tar.gz\'\fR (it's a symlink to
the latest beta version on ftp.leo.org).
.IP
Use on your own risk!
.IP
.IP \(bu\ 
\&\fBpbmplus\fR
.IP
I found the pbmplus package (bitmap manipulation tools) at the following
places (most other sites mirroring X11 should also have them):
.IP
src.doc.ic.ak.uk:\f(CW\`/computing/graphics/pbmplus10dec91.tar.Z\'\fR
.IP
wuarchive.wustl.edu:\f(CW\`/packages/X11R5/contrib-pub/pbmplus10dec91.tar.Z\'\fR
.IP
ftp.germany.eu.net:\f(CW\`/X11/contrib/pbmplus10dec91.tar.Z\'\fR
.IP
The \fBpbmplus\fR package has been superceded by the \fBNetPBM\fR
package which has some more conversion tools (but also some more bugs). It
should be available on the same sites. You could also check:
.IP
wuarchive.wstl.edu:\f(CW\`/graphics/graphics/packages/NetPBM\'\fR
.IP
ftp.rahul.net:\f(CW\`/pub/davidsen/source\'\fR
.IP
ftp.informatik.uni-oldenburg.de:\f(CW\`/???\'\fR
.IP
The \fBpbmtodot\fR program mentioned in the ``fax'' chapter can be found,
if nowhere else, in the \f(CW\`mgetty\'\fR directory on ftp.leo.org (see above).
.IP
.IP \(bu\ 
\&\fBFAS\fR
.IP
Some sites carrying the \fBfas\fR serial driver for SCO Unix, ISC, \&...:
.IP
ftp.fu-berlin.de:\f(CW\`/pub/unix/driver/fas/fas-2.11.tar.gz\'\fR
.IP
ftp.germany.eu.net:\f(CW\`/newsarchive/comp.sources.unix/volume27/fas-2.11.0/*\'\fR
.IP
src.doc.ic.ac.uk:\f(CW\`/usenet/comp.sources.unix/volume27/fas-2.11.0/*\'\fR
.IP
.IP \(bu\ 
\&\fBGhostScript\fR
.IP
The GNU GhostScript postscript interpreter can be found at all sites
carrying GNU Software. The ``main'' GNU site is \fIprep.ai.mit.edu\fR.
.IP
.IP \(bu\ 
\&\fBhp2pbm\fR
.IP
GhostScript is huge and slow... if you don't need it for other purposes,
you could use Chris Lewis' hp2pbm package, placed at
.IP
ftp.uunet.ca:\f(CW\`distrib/chris_lewis/hp2pbm/*\'\fR
.IP
This package contains all you need to convert ASCII or LJ PCL4 -> PBM, G3,
PS, X windows, Epson 24 pin. Coupled with mgetty's \fBg3topbm\fR, it's all
you need to send ASCII or HP LJ via FAX, and display/print FAXes on X, PS,
LJ, Epson, or via PBM utilities
.IP
It performs better than most of the equivalent PBMPLUS utilities.  Indeed,
if your application can generate both LJ and PS, generating LJ and
converting to G3 via \fBhp2pbm\fR is *much* faster than generating PS and
converting via GhostScript.
.IP
[Citing Chris: Incidentally, "g3topbm" plus my "pbm2lj" is much faster
than g3tolj.  Am not entirely sure why yet.  May have something to do
with scaling, which g3topbm and pbm2lj don't do.]
.IP
.IP \(bu\ 
\&\fBpsroff\fR
.IP
ftp.uunet.ca:\f(CW\`/distrib/chris_lewis/psroff3.0pl17/*\'\fR
.IP
[Chris: It should be ...psroff/*, but they never answer when I ask them to
fix my symlink]
.IP
Contains all you need to generate PS, LJ, or ditroff from ditroff or CAT
troff or groff. Together with hp2pbm, you can generate FAXes.  Contains
quite a number of LJ fonts, font manipulation, and font scaling utilities.
.IP
With the last two tools, you can send, receive, and print FAXes using
_just_ mgetty and hp2pbm (and a Laserjet printer ;-), without needing
pbmplus or GhostScript or anything else.
.IP
.IP \(bu\ 
\&\fBIfmail\fR
.IP
Ifmail is Eugene Crosser's FidoNet (tm) compatible Mailer + Gateway
software fuer Unix and Linux. It interworks with \fBmgetty\fR quite well,
allowing incoming Fido calls as well as Unix-Login and Fax. It can be
found on:
.IP
tsx-11.mit.edu:\f(CW\`/pub/linux/sources/usr.bin/ifmail*\'\fR
.IP
sunsite.unc.edu:\f(CW\`/pub/Linux/system/Mail/ifmail*\'\fR
.IP
.IP \(bu\ 
\&\fBdialog\fR
.IP
Dialog is a very nice shell tool to simplify input/output functions in
shell scripts. All the programs in \f(CW\`mgetty/dialog/\'\fR rely on it. It
runs on most operating systems, as long as they have a \fBcurses\fR
library. The source can be found on
.IP
sunsite.unc.edu:\f(CW\`/pub/Linux/utils/shell/dialog*\'\fR
.IP
.PP
.NH 2
How\ to\ get\ the\ mentioned\ software\ by\ UUCP
.br
.PP
For those of you that do not have FTP access: all the software mentioned in
the last section can also be found on the following UUCP sites:
.PP
.IP \(bu\ 
GREENIE (my system): ++49-89-3243328, V32bis/V.FastClass, get
greenie!~/green.files.gz
.IP
.IP \(bu\ 
Nasim (Frank Bartels): ++49-89-5469594, ZyXEL, get /pub/ls-lR.nasim.gz
.IP
.PP
.NH 2
Thanks
.br
Many thanks to:
.PP
.IP \(bu\ 
Peter Bechtold, peter@fns.greenie.muc.de, for sending me dozens of faxes
to test mgetty, for calling me back numerous times after failed
attempts to send him a fax with sendfax, \&...
.IP
Further, for the idea to use the remote fax id as part of the filename on
received faxes.
.IP
.IP \(bu\ 
Klaus Weidner, klaus@greenie.muc.de, for the original linux port,
testing dozens of pre-releases, writing the original texinfo
documentation, and finally for writing \fBvgetty\fR.
.IP
.IP \(bu\ 
Lawrence 'dreamer' Chen, lawrence@combdyn.com, for the initial ISC port,
and for testing the package with a SupraFAX-Modem.
.IP
.IP \(bu\ 
Kay Schulz, kschulz@gold.t-informatik.ba-stuttgart.de, for testing on ISC
--- and telling me that it's possible to ask dozens of questions without
having ever read the README file \&...
.IP
.IP \(bu\ 
Georg Edelmann, georg@alpha.saar.de, for testing on Linux, and finding
some stupid bugs.
.IP
.IP \(bu\ 
Uwe S. Fuerst, uwe@phiger.com, for testing on SCO 3.2v4 (and helping me a
lot nailing down the problem with dial-in/dial-out)
.IP
.IP \(bu\ 
Bodo Bauer, bodo@hal.nbg.sub.org, for porting mgetty to SVR4 (though he
did quite confuse me by insisting that the fax receiver does
not work \&...)
.IP
.IP \(bu\ 
Christoph Adomeit, for bugging me long enough to implement XON / XOFF
flow control in fax sending / receiving, and for lending me one of
his GVC modems long enough to make faxing (well, fax sending) work with it.
.IP
.IP \(bu\ 
Christopher M. Ward, for testing on SCO with another GVC modem.
.IP
.IP \(bu\ 
Ralf Stephan, for finding a problem in sendfax whith some modems that
lower CD too soon.
.IP
.IP \(bu\ 
John C. Peterson, for correcting a similar problem in mgetty / faxrec.
.IP
.IP \(bu\ 
Chel van Gennip, for the \fBpbmscale\fR, \fBg3toxwd\fR and
\&\fBg3tolj\fR programs.
.IP
.IP \(bu\ 
Glenn Thobe and Chris Lewis, for doing the 3B1 port(s).
.IP
.IP \(bu\ 
Chris Lewis, for doing all the \f(CW\`/etc/gettdefs\'\fR stuff, CallerID,
space limiting, making the source look really awful (K&R C support),
miscellaneous minor fixes,
and tolerating my sometimes very unfriendly reactions to his suggestions.
.IP
.IP \(bu\ 
Caz Yokoyama, for his suggestions concerning faxspool and the mail-to-fax
gateway
.IP
.IP \(bu\ 
Martin Husemann, for SVR4 testing (damn ESIX) and the NetBSD 386 port
.IP
.IP \(bu\ 
Michael A. Meiszl, mam@mamunx.werries.de, because he asked me to (*grin*)
- and because he found + changed lots of small, nevertheless annoying
things.
.IP
.IP \(bu\ 
Brent Mosbrook from ZyXEL USA, brentm@zyxel.com, who has been very helpful
solving some ZyXEL-specific fax questions.
.IP
.IP \(bu\ 
\&\&... and to all others who tested release after release.
.IP
.PP
.PP
.PP
