/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* libfb.h */

#ifndef _LIBFB_H_INCLUDED
#define _LIBFB_H_INCLUDED

#include "fb.h"

#ifndef TRUE
#define TRUE (0==0)
#endif
#ifndef FALSE
#define FALSE (!TRUE)
#endif

extern int  fb_init(void);
extern int  fb_leave(void);

extern int fb_vt_open(void);
extern int fb_vt_close(void);

extern int  fb_dev_open(void);
extern int  fb_dev_close(void);

extern int  fb_get_info(fb_info_t *pinfo);
extern int  fb_get_default_mode(unsigned long *pmode);
extern int  fb_get_num_modes(void);
extern int  fb_get_mode_info(unsigned long mode, fb_mode_t *pmode);
extern int  fb_set_mode(unsigned long mode);

extern int  fb_video_on(void);
extern int  fb_video_off(void);

extern int  fb_shm_init(void);
extern int  fb_shm_attach(void);
extern int  fb_shm_detach(void);
extern int  fb_shm_close(void);
extern int  fb_copy_from_shm(void);
extern int  fb_copy_to_shm(void);

extern int  fb_mmap(void);
extern int  fb_munmap(void);

extern int  fb_get_base(unsigned char **base);

extern int  fb_beep(unsigned short freq, unsigned short ms);

extern int  fb_test_test(void);

#endif
