/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

/* chipset.h */
/* generic chipset interface */

#ifndef SVGAFB_CHIPSET_H
#define SVGAFB_CHIPSET_H

extern void *fb_fontbuffer;

/* port functions */
/* kernel has outb(value,port) */
#define OUTB(_port,_value) outb(_value,_port)
#define INB(_port) inb(_port)

extern fb_info_t chip_info;

/* A dynamical chip_modesinfo is definitely required for Mach32 !!! */
extern fb_mode_t *chip_modesinfo;

extern unsigned long chip_mode;

#define NEEDS_NEXT_BANK 0x80000000U

struct mapping_desc {
	struct task_struct *tsk;
	unsigned long start;
	unsigned long size;
	pte_t *faulting_pte;
	struct mapping_desc *equiv;
	};

struct chip_bank_desc {
	unsigned long base;
	unsigned short pages;
	unsigned short shift;
	short value;
	void (*set_bank)(int page);
	void (*set_both_banks)(int page);
	struct mapping_desc *next_map, *end_maps, *mappings;
	};

extern struct chip_bank_desc chip_banks[];
extern int chip_choose_bank(int mode, int address);
extern short chip_num_banks;

extern unsigned char *chip_test_chipset(void);

extern int chip_init(void);
extern void chip_leave(void);
extern void chip_cleanup(void);	/* Is the the same as chip_leave ??? */

extern unsigned long chip_savestate_getsize(void);
/*
 * save/restore state of card and vga font. It is valid for font to be NULL to inhibit saving/
 * restoring but not for state!.
 */
extern void chip_savestate(void *state, void *font);
extern void chip_restorestate(void *state, void *font);
extern int chip_graphics(void);

extern int chip_blank(void);
extern int chip_unblank(void);

extern int chip_setorigin(fb_origin_t *origin);

extern int chip_setcolormap(fb_cmap_t *cmap);
extern int chip_getcolormap(fb_cmap_t *cmap);

extern void chip_test_test(void);

/*
 * Convenience:
 */

extern inline void init_mapdesc(struct mapping_desc *ptr, int nummaps) {
	while(nummaps--)
		ptr++ -> tsk = NULL;
}
#endif
