/*
 * This file is part of fb, the frame buffer device, a grafics card driver for
 *                                linux.
 *
 *     Copyright (C) 1995 Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Dipl.-Ing. Pascal Haible (haible@IZFM.Uni-Stuttgart.DE)
 *
 */

#ifndef SVGAFB_ET4000_H
#define SVGAFB_ET4000_H

#include "vga.h"
#include <asm/page.h>		/* PAGE_SIZE */

/* ET4000 memory layout */

#define CHIP_PAGES_PER_BANK	(CHIP_BANK_SIZE/PAGE_SIZE)

#define CHIP_MAX_MEM		(1024*1024)
#define CHIP_MIN_BANK_SIZE	(CHIP_BANK_SIZE)
#define CHIP_MAX_BANK_SIZE	(CHIP_BANK_SIZE)
#define CHIP_MAX_PAGES_PER_BANK	(CHIP_MAX_BANK_SIZE/PAGE_SIZE)
#define CHIP_MAX_NUMBER_BANKS	(CHIP_MAX_MEM / CHIP_MIN_BANK_SIZE)
#define CHIP_MAX_NUMBER_PAGES	(CHIP_MAX_NUMBER_BANKS * CHIP_MAX_PAGES_PER_BANK)

struct chip_regs_s {
	struct vga_regs_s vga_regs;
	unsigned char crt3x[8];
	unsigned char crt3f;
	unsigned char seq07;
	unsigned char mc;
	unsigned char segsel;
	unsigned char att16;
};

/* I/O ports */

#define ET4_HC		0x3BF
#define ET4_MCE		0x3C3
#define ET4_SEGSEL	0x3CD


/* extern struct chip_regs_s *chip_regs; */

/* ET4000 registers description (from vgadoc2)
**
**
**
** 102h: Microchannel Setup Control
** bit 0  Disable Card if set
**
** 3BFh (R/W): Hercules Compatability register
** 
** 3C0h index 16h: ATC Miscellaneous
**    (Write data to 3C0h, Read from 3C1h  (May not be needed))
** bit 4,5  High resolution timings.
**       7  Bypass the internal palette if set
**
** 3C3h (R/W): Microchannel Video Subsystem Enable Register:
** bit 0  Enable Microchannel VGA if set
**
** 3C4h index  6  (R/W): TS State Control
** bit 1-2  dots per characters in text mode 
**	    (bit 0: 3c4 index 1, bit 0)
**	    bit <2:0>	! dots/char
**		111	!    16
**		100	!    12
**		011	!    11
**		010	!    10
**		001	!     8
**		000	!     9
**
** 3C4h index  7  (R/W): TS Auxiliary Mode
** bit 0  If set select MCLK/4 (if bit 6 is also set to 1)
**     1  If set select SCLK input from MCLK
**   3,5  Rom Bios Enable/Disable:
**	  0 0  C000-C3FF Enabled
**	  0 1  Rom disabled
**	  1 0  C000-C5FF,C680-C7FF Enabled
**	  1 1  C000-C7FF Enabled
**     6  MCLK/2 if set
**     7  VGA compatible if set EGA else.
**
** 3CBh (R/W): PEL Address/Data Wd
**  
** 3CDh (R/W): Segment Select
**     0-3  64k Write bank nr (0..15)
**     4-7  64k Read bank nr (0..15)
**
** 3CEh index  Dh (R/W): Microsequencer Mode
**
** 3CEh index  Eh (R/W): Microsequencer Reset 
**
** 3d4h index 24h (R/W): Compatibility Control
** bit 0  Enable Clock Translate
**     1  Additional Master Clock Select
**     2  Enable tri-state for all output pins
**     3  Enable input A8 of 1MB DRAMs
**     4  Reserved
**     5  Enable external ROM CRTC translation
**     6  Enable Double Scan and Underline Attribute
**     7  CGA/MDA/Hercules
**
** 3d4h index 32h (R/W): RAS/CAS Video Config
**       Ram timing, System clock and Ram type. Sample values:
**	   00h  VRAM  80nsec
**	   09h  VRAM 100nsec
**	   00h  VRAM  28MHz
**	   08h  VRAM  36MHz
**	   70h  DRAM  40MHz
**
** 3d4h index 33h (R/W): Extended start ET4000 
** bit 0-1  Display start address bits 16-17
**     2-3  Cursor start address bits 16-17
**	  Can be used to ID ET4000
**
** 3d4h index 34h (R/W): Compatibility Control Register
** bit 2  bit 3 of clock select (bit 1-0 in misc output)
**     3  if set Video Subsystem Enable Register at 46E8h
**		  else at 3C3h.
**
** 3d4h index 35h (R/W): Overflow High ET4000
** bit 0  Vertical Blank Start Bit 10
**     1  Vertical Total Bit 10
**     2  Vertical Display End Bit 10
**     3  Vertical Sync Start Bit 10
**     4  Line Compare Bit 10
**     5  Gen-Lock Enabled if set (External sync)
**     6  Read/Modify/Write Enabled if set. Currently not implemented.
**     7  Vertical interlace if set
**
** 3d4h index 36h (R/W): Video System Configuration 1
** bit 0-2 Refresh count per line - 1
**     3   16 bit wide fonts if set, else 8 bit wide
**     4   Linear addressing if set. Video Memory is 
**         mapped as a 1 Meg block above 1MB. (set
**	   GDC index 6 bits 3,2 to zero (128k))
**     5   TLI addressing mode if set
**     6   16 bit data path (video memory) if set
**     7   16 bit data (I/O operations) if set
**
** 3d4h index 37h (R/W): Video System Configuration 2
** bit 0-1  Display memory data bus width
**          0,1=8bit, 2=16bit, 3=32bit; may be
**	    read as number of memory banks (1,2,4)
**	 2  Bus read data latch control. If set latches
**	    databus at end of CAS cycle else one clock delay
**       3  Clear if 64kx4 RAMs                   ???
**	  if set RAM size = (bit 0-1)*256k
**	    else RAM size = (bit 0-1)* 64k
**       4  16 bit ROM access if set
**       5  Memory bandwidth (0 better than 1) ???
**       6  TLI internal test mode if set 
**       7  VRAM installed if set DRAM else.
**
** 3d4h index 3Fh (R/W):
** bit   7  This bit seems to be bit 8 of the CRTC offset register (3d4h index 13h).
**
** 3d8h (R/W): Display Mode Control
**
** 46E8h (R):  Video Subsystem Enable Register
** bit   3  Enable VGA if set
**
**
**       3C4h index 05 used.
** 
**
**  Bank Switching:
**
**     64k banks are selected by the Segment Select Register at 3CDh.
**     Both a Read and a Write segment can be selected.
**
**  The sequence: 
**
**      port[$3BF]:=3;
**      port[$3D8]:=$A0;
**
**  is apparently needed to enable the extensions in the Tseng 4000.
**
**
**  Used extended ET4000 registers (EXT+xx) :
**
**	00 : CRT (3d4) index 30
**	01 : CRT (3d4) index 31
**	02 : CRT (3d4) index 32
**	03 : CRT (3d4) index 33
**	04 : CRT (3d4) index 34
**	05 : CRT (3d4) index 35
**	06 : CRT (3d4) index 36
**	07 : CRT (3d4) index 37
**	08 : CRT (3d4) index 3f
**	09 : SEQ (3c4) index 07
**	0A : Microchannel register (3c3)
**	0B : Segment select (3cd)
**	0C : ATT (3c0) index 16
**
*/

#endif
