/***************************************************************************
 * ljif.c: interface filter for HP LaserJet
 * AJCD December 1991, adapted from: pjif, which is from:

#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/ljif.c,v 1.1 1991/12/24 11:24:49 ajcd Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint

***************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <string.h>

/* Notes:
 * These notes are from the DeskJet Developer's guide.

 Start and end jobs with ESC E.
 Page eject when FF sent or cursor passes end of page, or page length change.
 ESC sequences: ESC !-/ are parameterised sequences, ESC anything else is two
 char sequence.

 */

extern int errorcode;
/* set from flags */

extern int debug, width, length, xwidth, ylength, literal, indent, special;
extern char *zopts, *class, *job, *login, *accntname, *host, *accntfile;
extern char *printer, *format, *name;
extern int npages;	/* number of pages */
extern char *calloc();	/* memory allocation */

/* variables for special options */
static int manualfeed = 1;
static int twocolumn = 0;
static int half = 1;
static float cpi = 16.66;
static float size = 8.5;
static int face = 0;
static int pslant = 0, sslant = 0;
static int pweight = 0, sweight = 3;

static int lines = 0;
static int chars = 0;
static int printed = 0;

cleanup() {
        printf("\033E");
}

formfeed() {
        if (lines || chars || printed) {
	   chars = lines = 0;
	   if (!twocolumn || (half = !half)) {
	      ++npages;
	      printf("\0339\033&a0l%dM\f", width); /*left side*/
	      printf("\033&a0c0R");	/* column and row 0 */
	   } else {
	      printf("\0339\033&a%dl%dM", twocolumn); /*right side*/
	      printf("\033&a%dc0R", twocolumn);	/* half page feed */
	   }
	}
}

linefeed() {
        chars = 0;
	if( ++lines >= length )
	   formfeed();
	else
	   putchar('\n');
}

filter(stop)
	char *stop;
{
	int c, i;
	int binary = 0;
	int parsing = 0;
	int state = 0;
	int value, vflags;
	char pattern[5];

	if (zopts) {      /* search comma separated list */
	   char *s, *next;
	   for (s = zopts; s && *s; s = next) {
	      if (next = strchr(s, ','))
		 *next++ = '\0';
	      if (!strcmp(s, "manualfeed"))
		 manualfeed = 2;
	      else if (!strcmp(s, "twocolumn")) {
		 twocolumn = width-(width-1)/2; /* left margin of R column */
		 width = (width-1)/2;         /* new width */
	      } else if (!strncmp(s, "cpi=", 4)) {
		 if (sscanf(s, "cpi=%f", &cpi) != 1)
		    fatal( "bad option %s", s );
		 if (cpi < 1)
		    fatal( "bad cpi %f", cpi );
	      } else if (!strncmp(s, "ptsize=", 7)) {
		 if (sscanf(s, "ptsize=%f", &size) != 1)
		    fatal( "bad option %s", s );
		 if (size < 1.0)
		    fatal( "bad point size %f", size );
	      } else if (!strncmp(s, "weight=", 7) ||
			 !strncmp(s, "weight2=", 8)) {
		 char *str = s+7;
		 int secondary = (*str == '=');
		 int *weight = &pweight;
		 if (secondary) {
		    str++;
		    weight = &sweight;
		 }
		 if (!strcmp(str, "thin"))        *weight = -5;
		 else if (!strcmp(str, "light"))  *weight = -3;
		 else if (!strcmp(str, "medium")) *weight = 0;
		 else if (!strcmp(str, "bold"))   *weight = 3;
		 else if (!strcmp(str, "black"))  *weight = 5;
		 else if (!strcmp(str, "ultra"))  *weight = 7;
		 else fatal( "bad weight %s", str );
	      } else if (!strncmp(s, "slant=", 6) ||
			 !strncmp(s, "slant2=", 7)) {
		 char *str = s+6;
		 int secondary = (*str == '=');
		 int *slant = &pslant;
		 if (secondary) {
		    str++;
		    slant = &sslant;
		 }
		 if (!strcmp(str, "normal"))      *slant = 0;
		 else if (!strcmp(str, "italic")) *slant = 1;
		 else fatal( "bad slant %s", str );
	      } else if (!strncmp(s, "font=", 5)) {
		 char *str = s+5;
		 if (!strcmp(str, "lpr"))           face = 0;
		 else if (!strcmp(str, "courier"))  face = 3;
		 else if (!strcmp(str, "letter"))   face = 6;
		 else if (!strcmp(str, "prestige")) face = 8;
		 else fatal( "bad font %s", str );
	      } else {
		 (void)fprintf(stderr, "%s: unrecognised option: -Z%s\n",
			       name, s);
		 (void)fflush(stderr);
	      }
	   }
	}

	/*
	 * do whatever initializations are needed
	 */
	printf("\033E");                 /* reset */
	printf("\033&k2G");              /* line termination parameters */
	printf("\033&/26A");             /* A4 */
	printf("\033&l0L");              /* no perforation skip */
	printf("\033&/%dH", manualfeed); /* set feed option 1=tray, 2=manual */
	printf("\033&l8D");              /* 8 lines per inch */
	printf("\033(s0p%.2fh%.2fv%ds%db%dT", /* select primary font */
	       cpi, size, pslant, pweight, face);
	printf("\033)s0p%.2fh%.2fv%ds%db%dT", /* select secondary font */
	       cpi, size, sslant, sweight, face);

	npages = 0;
	strcpy(pattern, "...\n"); /* data command patterns */

	/* should parse all page-ejecting and printing commands */
	while( (c = getchar()) != EOF ){
	   switch (parsing) {
	   case 0: /* previous char was OK */
	      if (!binary) {
		 switch ( c ) {
		 case '\n':
		    linefeed();
		    break;
		 case '\f':
		    formfeed();
		    break;
		 case 8:
		    if (chars) {
		       --chars;
		       putchar(c);
		    }
		    break;
		 case 9:
		    {  int extra = ((chars+8)&~7) - chars;
		       while (extra--) {
			  if (++chars > width) {
			     linefeed();
			     chars = 1;
			  }
			  putchar(' ');     /* always one space */
		       }
		    }
		    break;
		 case '\r':
		    chars = 0;
		    putchar(c);
		    break;
		 case '\033':
		    ++parsing;  /* start of command sequence */
		    break;
		 default:
		    if (++chars > width) {
		       linefeed();
		       chars = 1;
		    }
		    printed = 1;
		 case 14: case 15:
		    putchar(c);
		 }
	      } else
		 binary--;
	      break;
	   case 1: /* previous char was ESC */
	      if (c >= '!' && c <= '/') { /* parameterised command */
		 pattern[0] = c;
		 ++parsing;
	      } else { /* act on two-character ESC sequence */
		 parsing = 0;
	      }
	      break;
	   case 2: /* parameterised command: group character */
	      pattern[1] = c;
	      value = vflags = 0;
	      ++parsing;
	      break;
	   case 3: /* parameterised command: value field */
	      if (c == '-' || c == '.')
		 vflags = 1;          /* can't be byte count */
	      else if (c >= '0' && c <= '9' && !vflags)
		 value = value*10 + c-'0';
	      else if (c >= 64 && c <= 126) {
		 pattern[2] = (c & ~32);   /* ignore data */
		 if (strstr("&pX\n*bV\n*bW\n*vW\n)sW\n(sW\n", pattern))
		    binary += value;
		 if (c >= 96 && c <= 126) /* continued */
		    value = vflags = 0; /* next value */
		 else /* terminated */
		    parsing = 0;
	      }
	      break;
	   }
	}
	if( ferror( stdin ) ){
	   logerr_die( "read error on stdin");
	}
	if( lines > 0 ){
	   ++npages;
	}
	if( fflush(stdout) ){
	   logerr_die( "fflush returned error" );
	}

	/* tidy up afterwards */
	printf("\033E");
}
