/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: pf_main.c for prefilters
 ***************************************************************************
 * Revision History: Created Fri Mar  4 19:45:03 CST 1988
 * $Log: pf_main.c,v $
 * Revision 2.1  88/05/09  10:12:12  papowell
 * *** empty log message ***
 * 
 ***************************************************************************/
#ifndef lint
static char id_str1[] =
	"$Header: /disk/home/src2/plp/work_area/filters/RCS/pf_main.c,v 2.1 1988/05/09 10:12:12 papowell Exp $ PLP Copyright 1988 Patrick Powell";
#endif lint
/***************************************************************************
 *  UMN-LPR prefilter template and frontend.
 *
 *	A prefilter is invoked with the following parameters,
 *  which can be in any order, and perhaps some missing.
 *
 *  filtername arguments \   <- from PRINTCAP entry
 *      -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost  \
 *      -Fformat -Ddebug files
 * 
 *  1. Parameters can be in different order than the above.
 *  2. Optional parameters can be missing
 *  3. Values specified for the width, length, etc., are from PRINTCAP
 *     or from the overridding user specified options.
 *
 *  This program provides a common front end for most of the necessary
 *  grunt work.  This falls into the following classes:
 * 1. Parameter extraction.
 * 2. Picking off files.
 *  The front end will extract parameters,  then call the prefilter(file)
 *  routine,  which is responsible for carrying out the required prefilter
 *  actions.
 *
 *  The prefilter() routine should return 0 (success), 1 (retry) or 2 (abort).
 *
 * Parameter Extraction
 *	The main() routine will extract parameters
 *  whose values are placed in the appropriate variables.  This is done
 *  by using the ParmTable[], which has entries for each valid letter
 *  parmeter, such as the letter flag, the type of variable,
 *  and the address of the variable.
 *  The following variables are provided as a default set.
 *      -PPrinter -wwidth -llength -xwidth -ylength [-c] [-iindent] \
 *		[-Zoptions] [-Cclass] [-Jjob] [-Raccntname] -nlogin -hHost  \
 *      -Fformat files
 * VARIABLE  FLAG          TYPE    PURPOSE / PRINTCAP ENTRTY
 * name     name of filter char*    argv[0], program identification
 * width    -wwidth	       int      PW, width in chars
 * length   -llength	   int      PL, length in lines
 * xwidth   -xwidth        int      PX, width in pixels
 * xlength  -xlength       int      PY, length in pixels
 * literal  -c	           int      if set, ignore control chars
 * indent   -iindent       int      indent amount (depends on device)
 * zopts    -Zoptions      char*    extra options for printer
 * class    -Cclass        char*    classname
 * job      -Jjob          char*    jobname
 * accntname -Raccntname   char*    account for billing purposes
 * login    -nlogin        char*    login name
 * host     -hhost         char*    host name
 * format   -Fformat       char*    format
 * accntfile file          char*    AF, accounting file
 *
 * debug     - sets debug level
 *
 *	The functions fatal(), logerr(), and logerr_die() can be used to report
 *	status. The variable errorcode can be set by the user before calling
 *	these functions, and will be the exit value of the program. Its default
 *	value will be 2 (abort status).
 *	fatal() reports a fatal message, and terminates.
 *	logerr() reports a message, appends information indicated by errno
 *	(see perror(2) for details), and then returns.
 *	logerr_die() will call logerr(), and then will exit with errorcode
 *	status.
 *	Both fatal() and logerr_die() call the cleanup() function before exit.
 *
 * DEBUGGING:  a simple minded debugging version can be enabled by
 * compiling with the -DDEBUG option.
 */

#include <stdio.h>
#include <signal.h>
#include <sys/file.h>

int errorcode = 2;

char *name;		/* name of filter */
/* set from flags */
int debug, width, length, xwidth, ylength, literal, indent;
char *zopts, *class, *job, *login, *accntname, *host, *format;
char *printer;
int optind;

main( argc, argv )
	int argc;
	char **argv;
{
	int i;

	getargs( argc, argv );

	/*
	 * Turn off SIGPIPE
	 */
	(void)signal( SIGPIPE, SIG_IGN );
	errorcode = 0;
	for( i = optind; i < argc; ++ i ){
		errorcode = prefilter( argv[i] );
	}
	return(errorcode);
}

/*VARARGS1*/
log(msg, a1, a2, a3)
	char *msg;
{
	(void)fprintf(stderr, "%s: ", name);
	(void)fprintf(stderr, msg, a1, a2, a3);
	(void)putc('\n', stderr);
	(void)fflush(stderr);
}

/*VARARGS1*/
fatal(msg, a1, a2, a3)
	char *msg;
{
	log(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}

/*VARARGS1*/
logerr(msg, a1, a2, a3)
	char *msg;
{
	extern int errno, sys_nerr;
	extern char *sys_errlist[];
	int err = errno;

	(void)fprintf(stderr, "%s: ", name);
	if (msg){
		(void)fprintf(stderr, msg, a1, a2, a3);
		(void)fputs( "- ", stderr);
	}
	if( err < sys_nerr ){
		(void)fputs(sys_errlist[err]);
	} else {
		(void)fprintf(stderr, "Unknown error %d", err);
	}
	(void)putc('\n', stderr);
	(void)fflush(stderr);
}

/*VARARGS1*/
logerr_die(msg, a1, a2, a3)
	char *msg;
{
	logerr(msg, a1, a2, a3);
	cleanup();
	exit(errorcode);
}

getargs(argc, argv)
	int argc;
	char **argv;
{
	int i;		/* argument index */
	char *arg;	/* argument */
	int flag;	/* flag */

	name = argv[0];
	for( i = 1; i < argc; ++i ){
		arg = argv[i];
		if( *arg == '-' ){ /* arg will be string */
				setvar( arg[1], &arg[2] );
		} else {
			optind = i;
			break;
		}
	}
	if( debug ){
		for( i = 0; i < argc; ++i ){
			fprintf(stdout, "%s ", argv[i] );
		}
		fprintf( stdout, "\n" );
		printf("login '%s'\n", login? login : "null" );
		printf("host '%s'\n", host? host : "null" );
		printf("class '%s'\n", class? class : "null" );
		printf("format '%s'\n", format? format : "null" );
		printf("job '%s'\n", job? job : "null" );
		printf("printer '%s'\n", printer? printer : "null" );
		printf("accntname '%s'\n", accntname? accntname : "null" );
		printf("zopts '%s'\n", zopts? zopts : "null" );
		printf("literal, %d\n", literal);
		printf("indent, %d\n", indent);
		printf("length, %d\n", length);
		printf("width, %d\n", width);
		printf("xwidth, %d\n", xwidth);
		printf("ylength, %d\n", ylength);
		for( i = 0; i < argc; ++i ){
			fprintf(stderr, "%s ", argv[i] );
		}
		fprintf( stderr, "\n" );
		fflush(stderr);
		fflush(stdout);
	}
}
			
#define INTV 0
#define STRV 1
#define FLGV 2
struct parm {
	int flag;
	char **var;
	int kind;
} Parmlist[] = {
{'C', &class, STRV },
{'D', (char **)&debug, INTV },
{'F', &format, STRV },
{'J', &job, STRV },
{'P', &printer, STRV },
{'R', &accntname, STRV },
{'Z', &zopts, STRV },
{'c', (char **)&literal, FLGV },
{'h', &host, STRV },
{'i', (char **)&indent, INTV },
{'l', (char **)&length, INTV },
{'n', &login, STRV },
{'w', (char **)&width, INTV },
{'x', (char **)&xwidth, INTV },
{'y', (char **)&ylength, INTV } };

int Parmlen = sizeof(Parmlist)/sizeof(struct parm);

/*
 * setvar( int flag, char *arg )
 * 1. look in table and find entry
 * 2. if STRV, then set 
 * 3. if INTV, then convert and set
 * 4. if FLGV, then set to 1
 */
setvar( flag, arg )
	int flag;
	char *arg;
{
	int u, l, i, c;	/* upper, lower, i */

	l = 0; u = Parmlen;
	while( l <= u ){
		i = (u+l)/2;
		c = flag - Parmlist[i].flag;
		if( 0 == c ){
			/* printf( "found parm %c, %d\n", flag, i ); */
			switch( Parmlist[i].kind ){
			case STRV: *Parmlist[i].var = arg; break;
			case INTV: *(int *)Parmlist[i].var = atoi(arg); break;
			case FLGV: *(int *)Parmlist[i].var = 1; break;
			}
			return;
		} else if( c < 0 ){
			/* printf( "down parm %c, %d\n", flag, i ); */
			u = i - 1 ;
		} else {
			/* printf( "up parm %c, %d\n", flag, i ); */
			l = i + 1 ;
		}
	}
	/* printf( "did not find parm %c, %d\n", flag, i ); */
	return;
}

#ifdef DEBUG
cleanup() {}

prefilter( file )
	char *file;
{
	FILE *fp;
	int c;

	log( "file %s", file );
	if( (fp = fopen( file, "r" )) == NULL ){
		fatal( "cannot open file %s", file );
	}
	while( (c = getc(fp)) != EOF ){
		putchar(c);
    }
}
#endif DEBUG
