/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 ***************************************************************************
 * MODULE: find_name.c
 * manages the Parms[] array entries.  Used by sender and receiver
 * file transfer functions of LPD.
 * The Parms[] array is maintained as a sorted list.
 * Find_name( char *name ): search the Parm[].filename entries for a match.
 *	returns: index if found, -1 if not;
 * Add_name( char *name ): search the Parm[].filename entries for a match.
 *	if not found, add the entry.
 *	returns: index where found or created.
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

/***************************************************************************
 * Find_name( char *name)
 * The Parms[] array is used to hold the names of data and control files
 * corresponding to a job.  The Find_name will look through the list for
 * the job.
 ***************************************************************************/
int
Find_name (char *name) {
    int i, j;

    j = -1;
    for (i = 0; i < Parmcount; ++i) {
	if (strsame (Parms[i].filename, name)) {
	    j = i;
	    break;
	}
    }
    if (Debug > 6)
	log (XLOG_DEBUG, "Find_name: %s, entry %d", name, j);
    return (j);
}

/***************************************************************************
 * Add_name(char *name)
 * Maintains the Parms[].filename entries in sorted order.
 * 1. See if in file. if it is, return index.
 * 2. If not,  you will find the entry where it should be inserted.
 * 3. Move all the entries up one position.
 * the job.
 ***************************************************************************/

int
Add_name (char *name) {
    int i;

    allocParmsIfNeeded ();
    if ((i = Find_name (name)) < 0) {
	i = Parmcount;
	(void) bzero ((char *) &Parms[i], sizeof (struct parm));
	(void) strcpy (Parms[i].filename, name);
	++Parmcount;
	growParmsIfNeeded ();
    }

    if (Debug > 5)
	log (XLOG_DEBUG, "Add_name: %s, entry %d", name, i);
    return (i);
}
