/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 * version 3.3.0 Justin Mason July 1994
 * BSD-based systems support (sgtty)
 ***************************************************************************/

#if !defined(B19200)
#ifdef EXTA
#define B19200 EXTA
#else
#define B19200 B9600
#endif	/* !defined(EXTA) */
#endif	/* !defined(B19200) */

#if !defined(B38400)
#ifdef EXTB
#define B38400 EXTB
#else
#define B38400 B9600
#endif	/* !defined(EXTB) */
#endif	/* !defined(B38400) */

struct bauds {
    char *string;
    int baud;
    int speed;
}     bauds[] = {

    "110", 110, B110,
    "134", 134, B134,
    "150", 150, B150,
    "300", 300, B300,
    "600", 600, B600,
    "1200", 1200, B1200,
    "1800", 1800, B1800,
    "2400", 2400, B2400,
    "4800", 4800, B4800,
    "9600", 9600, B9600,
    "19200", 19200, B19200,
    "38400", 38400, B38400,
    (char *) 0, 0, 0
};

/*
 * Fri Feb 26 08:44:53 CST 1988 Patrick Powell set terminal modes This code was based on
 * a public domain version of public domain version of stty. I suppose that I could have
 * created if from scratermctrlh, but I have seen the same table appearing in many
 * "public domain" display terminal modes programs.
 * 
 * jmason: I've added support for some combination modes, such as "pass8" and "parity".
 */

struct tchars termctrl;
struct ltchars linectrl;
struct sgttyb mode;
static struct {
    char *string;
    int set;
    int reset;
    int lset;
    int lreset;

}      modes[] = {

    "bs0", BS0, BS1, 0, 0,
    "bs1", BS1, BS1, 0, 0,
    "cbreak", CBREAK, 0, 0, 0,
    "-cbreak", 0, CBREAK, 0, 0,
    "cooked", 0, RAW, 0, 0,
    "cr0", CR0, CR3, 0, 0,
    "cr1", CR1, CR3, 0, 0,
    "cr2", CR2, CR3, 0, 0,
    "cr3", CR3, CR3, 0, 0,
    "decctlq", 0, 0, LDECCTQ, 0,
    "-decctlq", 0, 0, 0, LDECCTQ,
    "echo", ECHO, 0, 0, 0,
    "-echo", 0, ECHO, 0, 0,
    "even", EVENP, 0, 0, 0,
    "-even", 0, EVENP, 0, 0,
    "ff0", FF0, FF1, 0, 0,
    "ff1", FF1, FF1, 0, 0,
    "lcase", LCASE, 0, 0, 0,
    "-lcase", 0, LCASE, 0, 0,
    "litout", 0, 0, LLITOUT, 0,
    "-litout", 0, 0, 0, LLITOUT,
    "nl", 0, CRMOD, 0, 0,
    "-nl", CRMOD, 0, 0, 0,
    "nl0", NL0, NL3, 0, 0,
    "nl1", NL1, NL3, 0, 0,
    "nl2", NL2, NL3, 0, 0,
    "nl3", NL3, NL3, 0, 0,
    "noflsh", 0, 0, LNOFLSH, 0,
    "-noflsh", 0, 0, 0, LNOFLSH,
    "nohang", 0, 0, LNOHANG, 0,
    "-nohang", 0, 0, 0, LNOHANG,
    "odd", ODDP, 0, 0, 0,
    "-odd", 0, ODDP, 0, 0,
    "raw", RAW, 0, 0, 0,
    "-raw", 0, RAW, 0, 0,
    "tab0", TAB0, XTABS, 0, 0,
    "tab1", TAB1, XTABS, 0, 0,
    "tab2", TAB2, XTABS, 0, 0,
    "tabs", 0, XTABS, 0, 0,
    "-tabs", XTABS, 0, 0, 0,
    "tandem", TANDEM, 0, 0, 0,
    "-tandem", 0, TANDEM, 0, 0,
#ifndef IS_NEXT
    "tilde", 0, 0, LTILDE, 0,
    "-tilde", 0, 0, 0, LTILDE,
#endif
    "tn300", CR1, ALLDELAY, 0, 0,
    "tty33", CR1, ALLDELAY, 0, 0,
    "tty37", FF1 + CR2 + TAB1 + NL1, ALLDELAY, 0, 0,
    "vt05", NL2, ALLDELAY, 0, 0,

    /* jmason modes and synonyms: */
    "evenp", EVENP, 0, 0, 0,
    "-evenp", 0, EVENP, 0, 0,
    "parity", EVENP, 0, 0, 0,
    "-parity", 0, EVENP, 0, 0,
    "oddp", ODDP, 0, 0, 0,
    "-oddp", 0, ODDP, 0, 0,
#ifdef LPASS8
    "pass8", 0, 0, LPASS8, 0,
    "-pass8", 0, 0, 0, LPASS8,
#endif
};


static struct special {
    char *name;
    char *cp;
    char def;
}       special[] = {

    "stop", &termctrl.t_stopc, CSTOP,
    "start", &termctrl.t_startc, CSTART,
    0
};

void
Do_stty (int fd) {
    int i;
    int localmode;
    int linedisc;
    char buf[BUFSIZ], *bp, *ep, *arg;

    if (ioctl (fd, TIOCGETP, &mode) < 0
	|| ioctl (fd, TIOCGETC, &termctrl) < 0
	|| ioctl (fd, TIOCLGET, &localmode) < 0
	|| ioctl (fd, TIOCGLTC, &linectrl) < 0) {
	logerr_die (XLOG_INFO, "cannot get tty parameters");
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG, "stty: before mode 0x%x, lmode 0x%x, speed 0x%x",
	     mode.sg_flags, localmode, mode.sg_ispeed);
    if (BR) {
	for (i = 0; bauds[i].baud && BR != bauds[i].baud; i++);
	if (i == 0) {
	    fatal (XLOG_INFO, "illegal baud rate %d", BR);
	}
	mode.sg_ispeed = mode.sg_ospeed = bauds[i].speed;
    }
    mode.sg_flags &= ~FC;
    mode.sg_flags |= FS;
    localmode &= ~XC;
    localmode |= XS;

    if (TY && *TY) {
	(void) strcpy (buf, TY);
	ep = buf;
    } else if (MS && *MS) {
	(void) strcpy (buf, MS);
	ep = buf;
    } else {
	ep = 0;
    }
    while (ep && *ep) {
	for (; *ep && isspace (*ep); ++ep);
	for (arg = ep; *ep && !isspace (*ep); ++ep);
	if (*ep) {
	    *ep = 0;
	    ++ep;
	}
	for (i = 0; modes[i].string && strcmp (modes[i].string, arg); i++);
	if (modes[i].string) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG,
		     "stty: modes %s, mc 0x%x ms 0x%x lc 0x%x ls 0x%x",
		     modes[i].string, modes[i].reset, modes[i].set,
		     modes[i].lreset, modes[i].lset);
	    mode.sg_flags &= ~modes[i].reset;
	    mode.sg_flags |= modes[i].set;
	    localmode &= ~modes[i].lreset;
	    localmode |= modes[i].lset;
	    continue;
	}
	for (i = 0; special[i].name && strcmp (special[i].name, arg); i++);
	if (special[i].name) {
	    for (; *ep && isspace (*ep); ++ep);
	    for (bp = ep; *ep && !isspace (*ep); ++ep);
	    if (*ep) {
		*ep = 0;
		++ep;
	    }
	    if (*bp == 0) {
		fatal (XLOG_INFO, "stty: missing parameter for %s", arg);
	    }
	    if (bp[0] == '^') {
		if (bp[1] == '?') {
		    *special[i].cp = 0177;
		} else {
		    *special[i].cp = 037 & bp[1];
		}
	    } else {
		*special[i].cp = bp[0];
	    }
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: special %s %s", arg, bp);
	    continue;
	}
	for (i = 0; bauds[i].string && strcmp (bauds[i].string, arg); i++);
	if (bauds[i].string) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: speed %s", arg);
	    mode.sg_ispeed = mode.sg_ospeed = bauds[i].speed;
	    continue;
	}
	if (!strcmp ("new", arg)) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: ldisc %s", arg);
	    linedisc = NTTYDISC;
	    if (ioctl (fd, TIOCSETD, &linedisc) < 0)
		logerr_die (XLOG_INFO, "stty: TIOCSETD ioctl failed");
	    continue;
	}
	if (!strcmp ("old", arg)) {
	    if (DbgLocal > 4)
		log (XLOG_DEBUG, "stty: ldisc %s", arg);
	    linedisc = 0;
	    if (ioctl (fd, TIOCSETD, &linedisc) < 0)
		logerr_die (XLOG_INFO, "stty: TIOCSETD ioctl failed");
	    continue;
	}
	fatal (XLOG_INFO, "unknown mode: %s\n", arg);
    }
    if (DbgLocal > 3)
	log (XLOG_DEBUG, "stty: after mode 0x%x, lmode 0x%x, speed 0x%x",
	     mode.sg_flags, localmode, mode.sg_ispeed);
    if (ioctl (fd, TIOCSETN, &mode) < 0
	|| ioctl (fd, TIOCSETC, &termctrl) < 0
	|| ioctl (fd, TIOCSLTC, &linectrl) < 0
	|| ioctl (fd, TIOCLSET, &localmode) < 0) {
	logerr_die (XLOG_NOTICE, "cannot set tty parameters");
    }
}
