#include "lp.h"
#include "library/errormsg.h"
#include "library/utils.h"
#include "common/requeue.h"

static char *new_SD;		/* destination spool directory: 
				 * in this function the current spool directory */
static int New_Job_number;      /* New job number */

static void dorequeue (struct plp_queue *, int);

/***************************************************************************
 * requeue_job (FILE *fp; struct plp_queue *q, Job_number)
 * Requeue a job if a hardware problem causes a failure while printing.
 * ACTIONS:
 * 1. Requeue job's files to the current spool directory
 ***************************************************************************/

static int
requeue_job (FILE *cfp, struct plp_queue *q, int Job_number)

{
    struct stat stbuf;		/* for statting files */
    char l[BUFSIZ];		/* for reading the control file */
    char fullname[BUFSIZ];	/* for the full pathname */
    char newname[BUFSIZ];	/* full pathname of new name  */
    char *filepart;		/* end of the pathname */
    char *newfilepart;		/* end of the pathname */
    struct ch_newname           /* Struct for the new cf filename */
    {
	char anf[3];
	char anumber[3];
	char temp_shorthost[64];
    };
    struct ch_newname tmp_new_filepart; 

    char a_Job_number[4];       /* the new Jobnumber */
    char cf_buffer[BUFSIZ];     /* the new cf-file */
    int i;                      /* flag for removing junk from cf_buffer */

    i = 0;
    if (new_SD == 0 || *new_SD == 0) {
	fatal (XLOG_INFO, "no directory entry");
    }
    
    /* get the directory name and copy to buffer */
    if (strlen (new_SD) + sizeof (q->q_name) + 2 > sizeof (newname)) {
	logerr_die (XLOG_NOTICE, "INTERNAL: requeue_job, file name too big");
    }
    (void) strcpy (newname, new_SD);
    newfilepart = &newname[strlen (newname)];
    *newfilepart++ = '/';

    (void) strcpy (fullname, SD);
    filepart = &fullname[strlen (fullname)];
    *filepart++ = '/';
    (void) strcpy (filepart, q->q_name);

    /* check that the control file is there */
    if (stat (fullname, &stbuf) < 0) {
	return 1;		/* Doesn't exist */
    }
    while (fgets (l, sizeof (l), cfp)) {
	/* clobber the \n */
	l[strlen (l) - 1] = '\0';
	if (islower (l[0]) || ( l[0] =='U') ) {
	    if (islower (l[0])) {
		(void) strcpy (filepart, &l[1]);
		if (stat (fullname, &stbuf) < 0) {
		    (void) fclose (cfp);
		    if (Debug > 5)
			log (XLOG_DEBUG,
			     "requeue_job: data file %s does not exist", l);
		} else {
		    /* Requeue file */
		    (void) strcpy ((char *) &(tmp_new_filepart.anf[0]), &(l[1]));
		    sprintf(a_Job_number , "%03d", Job_number);
		    tmp_new_filepart.anumber [0] = a_Job_number [0];
		    tmp_new_filepart.anumber [1] = a_Job_number [1];
		    tmp_new_filepart.anumber [2] = a_Job_number [2];
		    (void) strcpy (newfilepart, (char *) &(tmp_new_filepart.anf[0]));
		    
		    strncat(cf_buffer, &l[0], 1);
		    strcat(cf_buffer, (char *) &tmp_new_filepart);
		    strcat(cf_buffer, "\n");
		    
		    if (Debug > 4)
			log (XLOG_DEBUG, "requeue_job: renaming %s to %s ", fullname, newname);
		    Setuid_debug("requeue_job");
		    user_to_daemon ();
		    Setuid_debug("requeue_job");
		    if (copy_file (fullname, newname, -1) < 0) {
			daemon_to_user (); /* Switch back before exit */
			logerr_die (XLOG_INFO, "requeue_job: copyimg of %s to %s failed", 
				    fullname, newname);
		    }
                    /* ignore the return status; we don't really mind if this fails */
		    (void)unlink (fullname); 
		    daemon_to_user ();
		    Setuid_debug("requeue_job");
		}
	    } else {
		/* hopefully 'd' preceedes 'U'  */
		strncat(cf_buffer, &l[0], 1);
		strcat(cf_buffer, (char *) &tmp_new_filepart);
		strcat(cf_buffer, "\n");
	    }
	} else {
 	    if ( i == 0 ) /* First run; erase all the junk in cf_buffer */
		{
		    (void)strcpy(cf_buffer, &l[0]); 
		    strcat(cf_buffer, "\n");
		    i++; 
		} else {
		    strcat(cf_buffer, &l[0]);
		    strcat(cf_buffer, "\n"); 
		}
	}
    }

    if (Debug > 5)
	log (XLOG_DEBUG, "requeue_job: control file %s is ok", q->q_name);

    /* rewrite the control-file and close it */
    (void) rewind (cfp);
    cf_buffer[strlen(cf_buffer)-1] = '\0' ;
    fputs ( cf_buffer , cfp ) ;
    (void) fclose (cfp);

    (void) strcpy (&(tmp_new_filepart.anf[0]), q->q_name);
    tmp_new_filepart.anumber [0] = a_Job_number [0] ;
    tmp_new_filepart.anumber [1] = a_Job_number [1] ;
    tmp_new_filepart.anumber [2] = a_Job_number [2] ;
    (void) strcpy (newfilepart, &(tmp_new_filepart.anf[0]));
    (void) strcpy (filepart, q->q_name);
    if (Debug > 4) {
	log (XLOG_DEBUG, "requeue_job: renaming %s to %s ", fullname, newname);
    }
    Setuid_debug("requeue_job");
    user_to_daemon ();
    Setuid_debug("requeue_job");
/*    if (rename (fullname, newname) != 0){*/
    if (copy_file (fullname, newname, -1) < 0){
	daemon_to_user (); 			/* Switch back before exit */
	logerr_die (XLOG_INFO, "requeue_job: copying of %s to %s failed", 
		fullname, newname);
	}
    (void)unlink (fullname); /* if that works or not makes
			      * no difference!
			      */
    daemon_to_user ();
    Setuid_debug("requeue_job");
    New_Job_number = Job_number;
    return (0);
}

void
requeue (void)
{
    int i;
    struct plp_queue *q;	/* job entry */
    int perms;			/* hold perms values */
    int control_perms;		/* has control perms */
    char *src_Printer;		/* source queue name */
    char buf[MAXPATHLEN];	/* holds the pathname */
    FILE *fp;                   /* for sequence number */
    int j;                      /* command waiting time */
    int Job_number;		/* job number for requeue */ 
    int requeuedone = 0;	/* a flag for error */              
    char Newnum[4];		/* String for the new job number */    

    Newjobnum = Newnum;		/* global pointer Newjobnum and Newnum are connected */ 
    
    /* If explicitly asked for debug then echo messages to stdout otherwise (db flag in
     * printcap) just log messages in file.*/
    Echo_on_stdout = Debug;
    src_Printer = Printer;

    /* get the printcap entry*/
    new_SD = (char *) malloc (strlen (SD) + 1); 
    (void) strcpy (new_SD, SD); 

    /* set the flags needed */
    Is_local = hostcmp (FQDN, Host) == 0;
    Is_root = strsame (Person, "root");
    mistake = 0;		/* global var for C_requeue: No permission -> no
				 * topq and abort */ 

    perms = 'C';		/* check for control perms on current queue */
    if (!(Is_root || Checkperm (FQDN, Person, First_name, &perms, (int *) 0, 0) > 0)) {
	(void) fprintf (stdout, "Sorry user %s, but you do not have requeue permission to printer '%s'!\n", Person, Printer);
	mistake = 1;		/* no permission */
	return;
    }

    /* check to see that the user has RMJOB privs on this machine */
    perms = 'R';		/* must be able to at least use the Printer */
    if (!(Is_root || Checkperm (FQDN, Person, First_name, &perms, (int *) 0, 0) > 0)) {
	(void) fprintf (stdout,
		"Sorry user %s, but you do not have requeue permission on printer '%s'!\n",
		Person, First_name);
	mistake = 1;
	return;
    }

    perms = 'C';		/* check for control perms */
    control_perms = 1;
    if (!(Is_root || Checkperm (FQDN, Person, First_name, &perms, (int *) 0, 0) > 0)) {
	control_perms = 0;
    }
    if (Debug > 4)
	log (XLOG_DEBUG,
	     "requeue: Is_root %d, Is_local %d, control_perms %d",
	     Is_root, Is_local, control_perms);

    /* get the job queue */
    Jobcount = Getq (); 
    (void) Checkactive ();

    /* run down list */
    if ((RM != NULL) && (*RM != '\0')) { /* It's a local queue */
	(void) fprintf (stdout, "Local  Queue  '%s':\n", Printer);
    } else {
	(void) fprintf (stdout, "Local Printer '%s':\n", Printer);
    }
    (void) fflush (stdout);
    if (Debug > 5)
	log (XLOG_DEBUG, "requeue: Jobcount = %d", Jobcount);

    /*
     * get the sequence file name; this is needed when the job will be
     * requeued in the spool directory where alread a job with this number
     * exists. We increase the number of the requeue job up by 1 using the
     * sequence file.
     */
    (void) sprintf (buf, "%s/.seq.%s", new_SD, ShortHost);
    if (Debug > 3)
	log (XLOG_DEBUG, "requeue: sequence file name '%s'", buf);
	    /* lock the sequence file and get a new number */
    {
	pid_t jobnum_pid_t;

	for (j = 0;
	   (fp = Getlockfile (buf, &jobnum_pid_t, (char *) 0, 0, &LO_statb)) == NULL
	     && j < 3; ++j) {
	    sleep ((unsigned) (j + (getpid () & 1)));
	}
	if (fp == NULL) {
	    Diemsg ("requeue: cannot lock sequence file %s, try later (%s)", buf,
		    Errormsg (errno));
	}
	Job_number = (int) jobnum_pid_t;
    }

    /* set the sequence number to the new value mod 1000; */
    Job_number = (Job_number + 1) % 1000;
    Setlockfile (buf, fp, Job_number, Time_str ());
    (void) fclose (fp);
    if (Debug > 4) 
	log (XLOG_DEBUG, "Requeue: number %d", Job_number);
    
    for (i = 0; i < Jobcount; ++i) {
	q = &Queue[i];
	if (Debug > 3)
	    log (XLOG_DEBUG, "requeue: checking %s, %d, %s",
		 q->q_name, q->q_num, q->q_user);
	if (shouldhold (q, control_perms)) { 

		dorequeue (q, Job_number);

   		 /*The old and the new job number are displayed */
	    	(void) fprintf (stdout,
		    "Requeueing job %d, owner %s, from printer '%s', new job number is: %d.\n",
		    q->q_num, q->q_user, Printer, New_Job_number);
	    	(void) fflush (stdout);
		sprintf (Newjobnum, "%d", New_Job_number);
		requeuedone = 1;
		}
    }
    if (!requeuedone){
	(void) fprintf (stdout,"Warning: job %d does not exist.\n",Parms[0].num);
	mistake = 1;
	return;
    }
}

/***************************************************************************
 * dorequeue (struct plp_queue *q, int Job_number)
 * Requeue the job
 * 1. Lock the control file.
 * 2. If unsuccessful, find the server PID and kill it off.
 * 3. Requeue the job.
 ***************************************************************************/
static void
dorequeue (struct plp_queue *q, int Job_number)

{
    FILE *cfp;

    if ((cfp = Unlockcf (q->q_name)) == NULL) {
	if ((cfp = fopen_daemon (q->q_name, "rw")) == NULL) {
	    logerr (XLOG_INFO, "Control file %s not read-writable.", q->q_name);
	    return;
	}
	/* Kill the server.*/
	if (q->q_daemon == 0) {
	    (void) Checkactive ();
	}
	if (q->q_daemon) {
	    (void) fprintf (stdout, "Killing off %s server %d.\n",
			    q->q_server, q->q_daemon);

	    if (killpg (q->q_daemon, SIGINT) < 0) {
		if (Debug > 2)
		    log (XLOG_DEBUG, "Server %s (%d) was not active.",
			 q->q_server, q->q_daemon);
	    }
	}
    }
    if (Debug > 3)
	log (XLOG_DEBUG, "dorequeue: requeueing files for job %s", q->q_name);
    requeue_job (cfp, q, Job_number);
    
}
