/*
 * Set default values for the configuration variables, which can then be overridden from
 * the config file.
 * 
 * jmason@iona.ie July 94.
 */

#include "lp.h"
#include "library/errormsg.h"

void
Defaults (void) {
    char *s;

    if (!Lpdlogf)
	allocandcpy (Lpdlogf, "/var/spool/lpd/lpd.log.%h");

    allocandcpy (Masterlock, "/var/spool/lpd/lpd.lock.%h");

#ifdef LOCAL
    allocandcpy (Permfile_path, "/etc/printer_perms:/etc/printer_perms.%h:/var/spool/lpd/printer_perms.%h");
    allocandcpy (Permfile_include_path, "/etc:/var/spool/lpd");
    allocandcpy (Printcap_path, "/etc/printcap:/var/spool/lpd/printcap.%h");
    allocandcpy (Printcap_include_path, "/etc:/var/spool/lpd");
#ifdef EUCS_ZOPTIONS
    allocandcpy (Zoptions_path, "/etc/eucs_zoptions:/var/spool/lpd/eucs_zoptions.%h");
    allocandcpy (Costcode_path, "/etc/eucs_code:/var/spool/lpd/eucs_code.%h");
#endif
    conf[num_confs].type = LOCAL_TYPE;
    conf[num_confs].domain = NULL;
    num_confs++;
#endif

#ifdef HESIOD
    allocandcpy (Hesiod_printcap_key, "pcap");
    allocandcpy (Hesiod_costcode_key, "eucs_code");
    conf[num_confs].type = HESIOD_TYPE;
    conf[num_confs].domain = NULL;
    num_confs++;
#endif

#ifdef NIS
    allocandcpy (NIS_printcap_bykey, "printcap.bykey");
    allocandcpy (NIS_printcap_byname, "printcap.byname");
    allocandcpy (NIS_costcode_bykey, "eucs_code.bykey");
    allocandcpy (NIS_costcode_byname, "eucs_code.byname");
    conf[num_confs].type = NIS_TYPE;
    conf[num_confs].domain = NULL;
    num_confs++;
#endif
    allocandcpy (Printer_port, "printer");
    Lpr_port_num = 0;		/* ie. work it out from Printer_port */

#ifdef NON_SETUID              /* For testing */
    Maxportno = 60000;         /* Should be enough... */
    Minportno = IPPORT_RESERVED * 2;
#else 
    /* hmm... the RFC specifies an arbitrary port range of 721 to 731 (inclusive).
     * dunno why, but we may as well stick with it.
     */
    Maxportno = 731;
    Minportno = IPPORT_RESERVED / 2;
#endif /* NON_SETUID */

    allocandcpy (Daemon_user, DAEMON);
    allocandcpy (Mail_command, MAIL);
    allocandcpy (Mail_addressing, "%u@%H");	/* don't expand this until needed */
    allocandcpy (Mail_from_address, "daemon (PLP printer daemon)");
    Mail_on_errors = 1;

    allocandcpy (Architecture, ARCHITECTURE);

    allocandcpy (Config_include_path, CONFIG_FILE);
    if ((s = strrchr (Config_include_path, '/')))
	*s = 0;

    DefaultPrintcap = NULL;
    Ctrlfile_logdir = NULL;
    Host_domain = NULL;

    AllowNonPrivPorts = 0;
    LogNonPrivPorts = 1;
    Restrict_symlinks = 0;

    Log_LPRMs = 1;
    Log_LPCs = 1;
    Log_LPRs = 1;
    Log_LPQs = 0;
    Log_no_filenames = 0;

    Check_for_nonprintable = 0;
    Show_empty_queues = 1;

    allocandcpy (Filter_path,
		 "/bin:/usr/bin:/usr/ucb:/usr/sbin:/usr/etc:/etc");
    allocandcpy (Filter_LD_path,
		 "/lib:/usr/lib:/usr/5lib:/usr/ucblib");

    allocandcpy (Errors_file, "errors");
    allocandcpy (Attach_file, "attached");
#ifdef EUCS_FORMS
    allocandcpy (Forms_file, "options");
#endif

#ifdef EUCS_BANNER
    EUCS_banner_format = 1;
#endif

    Use_printcap_cache = 0;
    Use_perm_cache = 0;
}
