/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: Remote_ops.c
 * intiate remote operations from the local machine
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

/***************************************************************************
 * Remote_status()
 * get the status from the remote Host RM for Printer RP
 ***************************************************************************/
void
Remote_status (void) {
    char buf[BUFSIZ];

    if (RP == 0 || *RP == 0) {
	fatal (XLOG_INFO, "no RP specified for RM (%s)", RM);
    }
    (void) sprintf (buf, "%c%s\n", Short_format ? REQ_DSHORT : REQ_DLONG, RP);
    if (DbgRem > 3)
	log (XLOG_DEBUG, "Remote_status: %s, '%d'%s", RM, buf[0], buf + 1);
    if (JSUCC == Link_line (3, buf)) {
	if (DbgRem > 4)
	    log (XLOG_DEBUG, "request sent");
	Link_get ();
    } else {
	(void) fprintf (stdout, "Remote connect to '%s' (%s) failed: %s\n",
			RP, RM, Errormsg (errno));
    }
    Link_close ();
}

/***************************************************************************
 * Remote_remove()
 * send a remote remove request to the remote Host
 ***************************************************************************/
void
Remote_remove (void) {
    char buf[BUFSIZ];		/* holds command */
    char *bp, *ep;		/* ACME Pointers, Inc. */
    int i;			/* ACME Integers, Inc. */
    static char *xsp = " ";	/* needs a space */

    /*
     * set up the remote command format: <REQ_REMOVE>Printer Person [Parms]
     */
    bp = buf;
    ep = buf + sizeof (buf);
    *bp++ = REQ_REMOVE;
    if (RP == 0 || *RP == 0) {
	fatal (XLOG_INFO, "no RP specified for RM %s", RM);
    }
    bp = estrcp (bp, RP, ep);
    bp = estrcp (bp, xsp, ep);
    bp = estrcp (bp, Person, ep);
    for (i = 0; i < Parmcount; ++i) {
	bp = estrcp (bp, xsp, ep);
	bp = estrcp (bp, Parms[i].str, ep);
    }
    bp = estrcp (bp, "\n", ep);
    /*
     * check command line for length
     */
    if (bp == 0) {
	fatal (XLOG_INFO, "Remote_remove: command line too long '%s'");
    }
    /*
     * send command
     */
    if (DbgRem > 3)
	log (XLOG_DEBUG, "Remote_remove: %s, '%d'%s", RM, buf[0], buf + 1);
    if (JSUCC == Link_line (3, buf)) {
	if (DbgRem > 3)
	    log (XLOG_DEBUG, "request sent");
	Link_get ();
    }
    Link_close ();
}

/***************************************************************************
 * Remote_control(cmd, param)
 * send the remote command to the printer
 * This has the form: \006person command RP param
 ***************************************************************************/
void
Remote_control (char *cmd, char *param) {
    char buf[BUFSIZ];

    if (RP == 0 || *RP == 0) {
	fatal (XLOG_INFO, "no RP specified for RM (%s)", RM);
    }
    (void) sprintf (buf, "%c%s %s %s%s\n", REQ_CONTROL, Person, cmd, RP, param);
    if (DbgRem > 3)
	log (XLOG_DEBUG, "Remote_control:%s '%d%'%s'", RM, buf[0], buf + 1);
    if (JSUCC == Link_line (3, buf)) {
	if (DbgRem > 4)
	    log (XLOG_DEBUG, "request sent");
	Link_get ();
    } else {
	(void) fprintf (stdout, "Remote connect to '%s' (%s) failed: %s\n",
			RP, RM, Errormsg (errno));
    }
    Link_close ();
}

/***************************************************************************
 * Remote_start()
 * start the remote printer
 ***************************************************************************/
int
Remote_start (void) {
    char buf[BUFSIZ];
    int succ;

    if (RP == 0 || *RP == 0) {
	fatal (XLOG_INFO, "no RP specified for RM (%s)", RM);
    }
    (void) sprintf (buf, "%c%s\n", REQ_START, RP);
    if (DbgRem > 3)
	log (XLOG_DEBUG, "Remote_start:%s '%d'\"%s\"", RM, buf[0], buf + 1);
    succ = Link_line (3, buf);
    if (JSUCC == succ) {
	if (DbgRem > 4)
	    log (XLOG_DEBUG, "request sent");
	(void) Link_confirm ();
    }
    Link_close ();
    return (JSUCC == succ);
}
