/***************************************************************************
 * U. Minnesota LPD Software * Copyright 1987, 1988, Patrick Powell
 ***************************************************************************
 * MODULE: startserver.c
 * send a "start" message to the LPD server
 ***************************************************************************
 * Startserver()
 * This originally used to use the UNIX domain sockets,  but now uses the
 * AF_INET domain sockets.  The actual sending is done by calling
 * Remote_start,  after setting the RP (remote printer) and RM fields
 * appropriately.
 * 1. Save the RP and RM values.
 * 2. Set RP to Printer and RM to Host
 * 3. If you are running NW, start the remote one
 * 4. Send the start message.
 * 5. Restore RP and RM
 * 6. Return success indication
 ***************************************************************************/

#include "lp.h"
#include "library/errormsg.h"

void
Startserver (void)
{
    char *old_RP, *old_RM;	/* original RP and RM values */

    if (NW && (RP != NULL) && (RM != NULL)) {
	old_RP = RP;
	old_RM = RM;
	RP = Printer;
	RM = Host;
    } else {
	old_RP = old_RM = NULL;
	RP = Printer;
	RM = Host;
    }

    if (Remote_start () == 0) {
	logerr (XLOG_INFO, "Startserver: host '%s' server for '%s' not started",
		Host, Printer);
    }

    if (old_RP) {
	RP = old_RP;
	RM = old_RM;
    }
}
