/*
 * lp-pipe.h: header file with std. lp-pipe defines & portability things.
 *                              -- Justin Mason 26 Aug 94.
 */

#include "portable.h"	/* from PLP src directory, for OS-specific stuff */
#include <errno.h>
#include <signal.h>

#ifdef HAVE_STRERROR
#define ERRSTR strerror(errno)
#else
extern char *sys_errlist[];
#define ERRSTR sys_errlist[errno]
#endif

/* varargs declarations: */
#ifdef __STDC__
#include <stdarg.h>
#define VA_LOCAL_DECL   va_list ap;
#define VA_START(f)     va_start(ap, f)
#define VA_SHIFT(v,t)	;	/* no-op for ANSI */
#define VA_END          va_end(ap)
#else

#include <varargs.h>
#define VA_LOCAL_DECL   va_list ap;
#define VA_START(f)     va_start(ap)		/* f is ignored! */
#define VA_SHIFT(v,t)	v = va_arg(ap,t)
#define VA_END		va_end(ap)
#endif

/************************************************************************
 * function prototypes, lp-pipe-specific values, etc.
 */

/* the exit codes */
#define LP_SUCCESS	0
#define LP_RETRY	1
#define LP_FAILED	2

plp_signal_t kill_job ();
extern char *status_fname;

#ifdef __STDC__
void setstatus (char *,...); 
#else
void setstatus (); 
#endif
