#ifndef _FTAPE_IOCTL_H
#define _FTAPE_IOCTL_H


/*
 *   the following are ment for raw access only. The driver ignores them if th
 *   QIC-80 flag is set in the minor device number (see kernel-interface.h)
 */
#ifndef _FTAPE_H

struct failed_sector_entry {
  unsigned short segment;
  unsigned short sector;
};

typedef union {
  struct failed_sector_entry mark;
  unsigned long entry;
} eof_mark_union;

/*  failed sector log size (only used if format code != 4).
 */
#define SECTOR_SIZE 1024

#define FAILED_SECTOR_LOG_SIZE  (2 * SECTOR_SIZE - 256)

#define MAX_FAILED_SECTORS (FAILED_SECTOR_LOG_SIZE/sizeof(eof_mark_union))

#define BAD_SECTOR_MAP_SIZE     (29 * SECTOR_SIZE - 256)

#endif /* _FTAPE_H */

/*  The bad sector map is to big to be passed as ioctl param. Thus we pass only a struct
 *  that contains pointers to sufficient user-space memory areas. If a pointer is NULL,
 *  then it simply is ignored.
 */

struct mtqic80info
{                
  unsigned char  *bad_sector_map; /* must be a pointer to a buffer of BAD_SECTOR_MAP_SIZE */
  eof_mark_union *failed_sector_log;  /* array[MAX_FAILED_SECTORS]; */
  unsigned short nr_of_failed_sectors;
  char tape_label[44];
  unsigned short compression_map_location;
  /*
   *   read only data.
   */
  unsigned short first_data_segment;
  unsigned short last_data_segment;
};

/*
 *  _IOW is alright in both cases, because we write the addresses of the pointers
 *  to the kernel. ftape_ioctl() then calls verify_area() on each pointer.
 */
#define	MTIOCGETQIC80INFO _IOWR('m', 100, struct mtqic80info)
#define	MTIOCSETQIC80INFO _IOW('m', 101, struct mtqic80info)

/*
 *  force the driver to write the header segments or to
 *  read them
 */
#define MTIOCQIC80WRHEADER _IO('m',102)
#define MTIOCQIC80RDHEADER _IO('m',103)

/*
 *   let the user know at which block size the volume was created with
 *   this is important as we let the user change the blocksize with
 *   MTSETBLK. One can query the blocksize before reading an old 
 *   volume or before appending data to it. zftape does not allow
 *   read/write access with the wrong blocksize. This is rather
 *   unproblematic as long as people use tar with the standard blocksize
 *   of 10kb which is also zftapes default blocksize, but who knows :-)
 */
struct mtblksz {
  unsigned long mt_blksz;
};
#define MTIOC_ZFTAPE_GETBLKSZ _IOR('m', 104, struct mtblksz)

#endif
