;;; $Id: emacspeak-ispell.el,v 4.0 1996/05/10 21:25:32 raman Exp $
;;; $Author: raman $ 
;;; Description:  Emacspeak extension to speech enable ispell
;;; Keywords: Emacspeak, Ispell, Spoken Output, Ispell version 2.30
;;{{{  LCD Archive entry: 
;;; LCD Archive Entry:
;;; emacspeak| T. V. Raman |raman@crl.dec.com 
;;; A speech interface to Emacs |
;;; $date: $ |
;;;  $Revision: 4.0 $ | 
;;; Location undetermined
;;;

;;}}}
;;{{{  Copyright:

;;; Copyright (c) 1994, 1995 by Digital Equipment Corporation.
;;; All Rights Reserved. 
;;;
;;; This file is not part of GNU Emacs, but the same permissions apply.
;;;
;;; GNU Emacs is free software; you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 2, or (at your option)
;;; any later version.
;;;
;;; GNU Emacs is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Emacs; see the file COPYING.  If not, write to
;;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;}}}
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;;{{{  Introduction:

;;; This module speech enables ispell.
;;; Implementation note: This is hard because of how  ispell.el is written
;;; Namely, all of the work is done by one huge hairy function.
;;; This makes advising it hard. 

;;}}}
;;{{{  first set up voice  highlighting:

(defvar ispell-highlight-personality 'harry
  "Voice used to highlight spelling errors. ")

(and (featurep 'emacspeak )
     (fset 'ispell-highlight-spelling-error
           (symbol-function 'ispell-highlight-spelling-error-overlay)))

 (defadvice ispell-highlight-spelling-error (after emacspeak act )
   "Use voice locking to highlight the error.
Will clobber any existing personality property defined on start end"
   (let ((start (ad-get-arg 0))
         (end (ad-get-arg 1 ))
         (highlight (ad-get-arg 2 )))
     (if highlight
         (put-text-property  start end
                             'personality  ispell-highlight-personality )
       (put-text-property start end
                          'personality  nil ))
     )
   )

;;}}}
;;{{{  ispell command loop:

;;; Speak the error line:
(defadvice ispell-command-loop (before emacspeak pre act )
  "Speak the line containing the incorrect word.
 Then speak  the possible corrections. "
  (let ((choices  (ad-get-arg 0 ))
        (position 0))
    (emacspeak-speak-line nil )
    (dtk-force )
    (while (and choices)
      (dtk-say (format "%s %s" position (car choices )))
      (incf position)
      (setq choices (cdr choices )))
    (dtk-force)))

(defadvice ispell-help (before emacspeak pre act)
  "Speak the help message. "
  (let ((dtk-stop-immediately nil))
    (dtk-speak (documentation 'ispell-help ))))

;;}}}
;;{{{  Advice top-level ispell commands:

(defadvice ispell-buffer (around emacspeak pre act comp)
  "Produce auditory icons for ispell."
  (cond
   ((interactive-p)
    (let ((dtk-stop-immediately nil )
          (voice-lock-mode t)
          (emacspeak-speak-messages nil))
      ad-do-it
      (emacspeak-auditory-icon 'task-done)))
   (t ad-do-it))
  ad-return-value)


(defadvice ispell-region (around emacspeak pre act comp)
  "Produce auditory icons for ispell."
  (cond
   ((interactive-p)
    (let ((dtk-stop-immediately nil )
          (voice-lock-mode t)
          (emacspeak-speak-messages nil))
      ad-do-it
      (emacspeak-auditory-icon 'task-done)))
   (t ad-do-it))
  ad-return-value)

(defadvice ispell-word (around emacspeak pre act comp)
  "Produce auditory icons for ispell."
  (cond
   ((interactive-p)
    (let ((dtk-stop-immediately nil )
          (voice-lock-mode t)
          (emacspeak-speak-messages nil))
      ad-do-it
      (emacspeak-auditory-icon 'task-done)))
   (t ad-do-it))
  ad-return-value)

;;}}}

(provide 'emacspeak-ispell)
;;{{{  emacs local variables 

;;; local variables:
;;; folded-file: t
;;; end: 

;;}}}
