------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                S Y S T E M . T A S K _ P R I M I T I V E S               --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.4 $                             --
--                                                                          --
--     Copyright (C) 1992,1993,1994,1995 Free Software Foundation, Inc.     --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

--  This package provides low-level support for most tasking features.

--  This is a dummy version of this package (no tasking support).

package body System.Task_Primitives is

   procedure Put_Character (C : Integer);
   pragma Import (C, Put_Character, "putchar");

   procedure Prog_Exit (Status : Integer);
   pragma Import (C, Prog_Exit, "exit");

   procedure Write_Character (C : Character);
   procedure Write_EOL;
   procedure Write_String (S : String);
   --  Debugging procedures used for assertion output

   procedure Unimplemented (Feature : String);
   --  This procedure writes out a message to the effect that the
   --  feature specified by the Feature string is unimplemented,
   --  and halts the program.

   ---------------------
   -- Write_Character --
   ---------------------

   procedure Write_Character (C : Character) is
   begin
      Put_Character (Character'Pos (C));
   end Write_Character;

   ---------------
   -- Write_Eol --
   ---------------

   procedure Write_EOL is
   begin
      Write_Character (Ascii.LF);
   end Write_EOL;

   ------------------
   -- Write_String --
   ------------------

   procedure Write_String (S : String) is
   begin
      for J in S'Range loop
         Write_Character (S (J));
      end loop;
   end Write_String;

   ---------------
   -- LL_Assert --
   ---------------

   procedure LL_Assert (B : Boolean; M : String) is
   begin
      if not B then
         Write_String ("Failed Runtime Assertion: ");
         Write_String (M);
         Write_String (".");
         Write_EOL;
         Prog_Exit (1);
      end if;
   end LL_Assert;

   -------------------
   -- Unimplemented --
   -------------------

   procedure Unimplemented (Feature : String) is
   begin
      Write_String (Feature);
      Write_String (" is unimplemented in this version of GNARL.");
      Write_EOL;
      Prog_Exit (1);
   end Unimplemented;

   -------------------------
   -- Initialize_LL_Tasks --
   -------------------------

   procedure Initialize_LL_Tasks (T : TCB_Ptr) is

   begin
      Unimplemented ("Tasking");
   end Initialize_LL_Tasks;

   ----------
   -- Self --
   ----------

   function Self return TCB_Ptr is
   begin
      Unimplemented ("Tasking");
      return null;
   end Self;

   ---------------------
   -- Initialize_Lock --
   ---------------------

   procedure Initialize_Lock
     (Prio : System.Priority;
      L    : in out Lock)
   is
   begin
      Unimplemented ("Tasking");
   end Initialize_Lock;

   -------------------
   -- Finalize_Lock --
   -------------------

   procedure Finalize_Lock (L : in out Lock) is
   begin
      Unimplemented ("Tasking");
   end Finalize_Lock;

   ----------------
   -- Write_Lock --
   ----------------

   --  The error code EINVAL indicates either an uninitialized mutex or
   --  a priority ceiling violation. We assume that the former cannot
   --  occur in our system.
   procedure Write_Lock (L : in out Lock; Ceiling_Violation : out Boolean) is
   begin
      Unimplemented ("Tasking");
   end Write_Lock;

   ---------------
   -- Read_Lock --
   ---------------

   procedure Read_Lock (L : in out Lock; Ceiling_Violation : out Boolean) is
   begin
      Unimplemented ("Tasking");
   end Read_Lock;

   ------------
   -- Unlock --
   ------------

   procedure Unlock (L : in out Lock) is
   begin
      Unimplemented ("Tasking");
   end Unlock;

   ---------------------
   -- Initialize_Cond --
   ---------------------

   procedure Initialize_Cond (Cond : in out Condition_Variable) is
   begin
      Unimplemented ("Tasking");
   end Initialize_Cond;

   -------------------
   -- Finalize_Cond --
   -------------------

   procedure Finalize_Cond (Cond : in out Condition_Variable) is
   begin
      Unimplemented ("Tasking");
   end Finalize_Cond;

   ---------------
   -- Cond_Wait --
   ---------------

   procedure Cond_Wait
     (Cond : in out Condition_Variable;
      L    : in out Lock)
   is
   begin
      Unimplemented ("Tasking");
   end Cond_Wait;

   ---------------------
   -- Cond_Timed_Wait --
   ---------------------

   procedure Cond_Timed_Wait
     (Cond      : in out Condition_Variable;
      L         : in out Lock; Abs_Time : Task_Clock.Stimespec;
      Timed_Out : out Boolean)
   is
   begin
      Unimplemented ("Tasking");
   end Cond_Timed_Wait;

   -----------------
   -- Cond_Signal --
   -----------------

   procedure Cond_Signal (Cond : in out Condition_Variable) is
   begin
      Unimplemented ("Tasking");
   end Cond_Signal;

   ------------------
   -- Set_Priority --
   ------------------

   procedure Set_Priority (T : TCB_Ptr; Prio : System.Priority) is
   begin
      Unimplemented ("Tasking");
   end Set_Priority;

   ----------------------
   -- Set_Own_Priority --
   ----------------------

   procedure Set_Own_Priority (Prio : System.Priority) is
   begin
      Unimplemented ("Tasking");
   end Set_Own_Priority;

   ------------------
   -- Get_Priority --
   ------------------

   function Get_Priority (T : TCB_Ptr) return System.Priority is
   begin
      Unimplemented ("Tasking");
      return System.Priority'First;
   end Get_Priority;

   -----------------------
   --  Get_Own_Priority --
   -----------------------

   --  Note: this is specialized (rather than being done using a default
   --  parameter for Get_Priority) in case there is a specially efficient
   --  way of getting your own priority, which might well be the case in
   --  general (although is not the case in Pthreads).

   function Get_Own_Priority return System.Priority is
   begin
      Unimplemented ("Tasking");
      return System.Priority'First;
   end Get_Own_Priority;

   --------------------
   -- Create_LL_Task --
   --------------------

   procedure Create_LL_Task
     (Priority       : System.Priority;
      Stack_Size     : Task_Storage_Size;
      Task_Info      : System.Task_Info.Task_Info_Type;
      LL_Entry_Point : LL_Task_Procedure_Access;
      Arg            : System.Address;
      T              : TCB_Ptr)
   is
   begin
      Unimplemented ("Tasking");
   end Create_LL_Task;

   ------------------
   -- Exit_LL_Task --
   ------------------

   procedure Exit_LL_Task is
   begin
      Unimplemented ("Tasking");
   end Exit_LL_Task;

   ----------------
   -- Abort_Task --
   ----------------

   procedure Abort_Task (T : TCB_Ptr) is
   begin
      Unimplemented ("Tasking");
   end Abort_Task;

   ----------------
   -- Test_Abort --
   ----------------

   --  This procedure does nothing.  It is intended for systems without
   --  asynchronous abortion, where the runtime system would have to
   --  synchronously poll for pending abortions.  This should be done
   --  at least at every synchronization point.

   procedure Test_Abort is
   begin
      Unimplemented ("Tasking");
   end Test_Abort;

   ---------------------------
   -- Install_Abort_Handler --
   ---------------------------

   procedure Install_Abort_Handler (Handler : Abort_Handler_Pointer) is
   begin
      Unimplemented ("Tasking");
   end Install_Abort_Handler;

   ---------------------------
   -- Install_Error_Handler --
   ---------------------------

   procedure Install_Error_Handler (Handler : System.Address) is
   begin
      Unimplemented ("Tasking");
   end Install_Error_Handler;

   ------------------
   -- Test_And_Set --
   ------------------

   -------------------------
   -- Initialize_TAS_Cell --
   -------------------------
   procedure Initialize_TAS_Cell (Cell :    out TAS_Cell) is
   begin
      Unimplemented ("Tasking");
   end Initialize_TAS_Cell;
   -----------------------
   -- Finalize_TAS_Cell --
   -----------------------
   procedure Finalize_TAS_Cell   (Cell : in out TAS_Cell) is
   begin
      Unimplemented ("Tasking");
   end Finalize_TAS_Cell;
   -----------
   -- Clear --
   -----------
   --
   --  This was not atomic with respect to another Test_and_Set in the
   --  original code.  Need it be???
   --
   procedure Clear        (Cell : in out TAS_Cell) is
   begin
      Unimplemented ("Tasking");
   end Clear;

   ------------
   -- Is_Set --
   ------------

   --
   --  This was not atomic with respect to another Test_and_Set in the
   --  original code.  Need it be???
   --
   function  Is_Set       (Cell : in     TAS_Cell) return Boolean is
   begin
      Unimplemented ("Tasking");
      return False;
   end Is_Set;
   ------------------
   -- Test_And_Set --
   ------------------
   procedure Test_And_Set (Cell : in out TAS_Cell; Result : out Boolean) is
   begin
      Unimplemented ("Tasking");
   end Test_And_Set;

end System.Task_Primitives;
