#    Copyright (C) 1995, 1996 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of GNU Ghostscript.
# 
# GNU Ghostscript is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility to
# anyone for the consequences of using it or for whether it serves any
# particular purpose or works at all, unless he says so in writing.  Refer to
# the GNU General Public License for full details.
# 
# Everyone is granted permission to copy, modify and redistribute GNU
# Ghostscript, but only under the conditions described in the GNU General
# Public License.  A copy of this license is supposed to have been given to
# you along with GNU Ghostscript so you can know your rights and
# responsibilities.  It should be in a file named COPYING.  Among other
# things, the copyright notice and this notice must be preserved on all
# copies.
# 
# Aladdin Enterprises is not affiliated with the Free Software Foundation or
# the GNU Project.  GNU Ghostscript, as distributed by Aladdin Enterprises,
# does not depend on any other GNU software.

# makefile for PNG (Portable Network Graphics) code.

# This partial makefile compiles the png library for use in the Ghostscript
# PNG drivers.  You can get the source code for this library from:
#   ftp://swrinde.nde.swri.edu/pub/png/src/lpng089c.zip   (libpng 0.89)
#		or libpng-0.89.tar.gz
# Please see Ghostscript's `make.txt' file for instructions about how to
# unpack these archives.
#
# The specification for the PNG file format is available from:
#   http://www.group42.com/png.htm
#   http://www.w3.org/pub/WWW/TR/WD-png

# Define the name of this makefile.
LIBPNG_MAK=libpng.mak

# PSRCDIR is defined in the platform-specific makefile, not here,
# as the directory where the PNG library sources are stored.
#PSRCDIR=libpng
# PVERSION is defined in the platform-specific makefile, not here,
# as the libpng version number (currently "88" or "89").
#PVERSION=89

PSRC=$(PSRCDIR)$(D)
CCCP=$(CCC) -I$(PSRCDIR) -I$(ZSRCDIR)

# We keep all of the PNG code in a separate directory so as not to
# inadvertently mix it up with Aladdin Enterprises' own code.
PDEP=$(AK)

png_1=png.$(OBJ) pngmem.$(OBJ) pngerror.$(OBJ)
png_2=pngtrans.$(OBJ) pngwrite.$(OBJ) pngwtran.$(OBJ) pngwutil.$(OBJ)

# libpng modules

png.$(OBJ): $(PSRC)png.c $(PDEP)
	$(CCCP) $(PSRC)png.c

# version 0.88 uses pngio.c
pngio.$(OBJ): $(PSRC)pngio.c $(PDEP)
	$(CCCP) $(PSRC)pngio.c

# version 0.89 uses pngwio.c
pngwio.$(OBJ): $(PSRC)pngwio.c $(PDEP)
	$(CCCP) $(PSRC)pngwio.c

pngmem.$(OBJ): $(PSRC)pngmem.c $(PDEP)
	$(CCCP) $(PSRC)pngmem.c

pngerror.$(OBJ): $(PSRC)pngerror.c $(PDEP)
	$(CCCP) $(PSRC)pngerror.c

pngtrans.$(OBJ): $(PSRC)pngtrans.c $(PDEP)
	$(CCCP) $(PSRC)pngtrans.c

pngwrite.$(OBJ): $(PSRC)pngwrite.c $(PDEP)
	$(CCCP) $(PSRC)pngwrite.c

pngwtran.$(OBJ): $(PSRC)pngwtran.c $(PDEP)
	$(CCCP) $(PSRC)pngwtran.c

pngwutil.$(OBJ): $(PSRC)pngwutil.c $(PDEP)
	$(CCCP) $(PSRC)pngwutil.c

# Define the version of libpng.dev that we are actually using.
libpng.dev: $(MAKEFILE) libpng_$(SHARE_LIBPNG).dev
	$(CP_) libpng_$(SHARE_LIBPNG).dev libpng.dev

# Define the shared version of libpng.
libpng_1.dev: $(LIBPNG_MAK) $(ECHOGS_XE)
	$(SETMOD) libpng_1 -lib png

# Define the non-shared version of libpng.
libpng_0.dev: $(LIBPNG_MAK) libpng$(PVERSION).dev
	$(CP_) libpng$(PVERSION).dev libpng_0.dev

libpng88.dev: $(LIBPNG_MAK) $(ECHOGS_XE)\
 $(png_1) pngio.$(OBJ) $(png_2) zlibe.dev
	$(SETMOD) libpng88 $(png_1) pngio.$(OBJ)
	$(ADDMOD) libpng88 -obj $(png_2)
	$(ADDMOD) libpng88 -include zlibe

libpng89.dev: $(LIBPNG_MAK) $(ECHOGS_XE)\
 $(png_1) pngwio.$(OBJ) $(png_2) zlibe.dev
	$(SETMOD) libpng89 $(png_1) pngwio.$(OBJ)
	$(ADDMOD) libpng89 -obj $(png_2)
	$(ADDMOD) libpng89 -include zlibe
