% Hyphenation patterns for Spanish.
% Compiled by Julio Sanchez (jsanchez@gmv.es) on September 1991.
%
% These patterns have been derived from "On Word Division in Spanish",
% Jos'e A. Ma~nas, Communications of the ACM, and implemented in his
% package ftc. You can get ftc and a draft of the abovementioned
% paper from goya.dit.upm.es in src/text.proc/ftc.Z. FTP access may
% be available. Otherwise, send help to info@goya.dit.upm.es for
% details on use of the mail server.
%
% Rules mentioned below are those described in that paper. After
% several unsatisfactory attempts to pretend I knew better, these 
% patterns closely follow that paper. Pattern 'tl' is not considered. 
% It is conflictive and ftc does not use it either.
%
% These patterns have been generated by shyphen.sh version 1.2, 
% shyphen.sh is a sh script that allows a number of choices. 
% Full benefit from some of these options can only be
% obtained if appropriate fonts are available.
%
% Follows a copyright notice. This is not in the public domain,
% but the copyright is essentially a hold-harmless clause. That
% is, use it at will, but don't sue me if you don't like it.
%
%			COPYRIGHT NOTICE
%
% These patterns and the generating sh script are Copyright (c) GMV 1991
% These patterns were developed for internal GMV use and are made
% public in the hope that they will benefit others. Also, spreading
% these patterns throughout the Spanish-language TeX community is
% expected to provide back-benefits to GMV in that it can help keeping
% GMV in the mainstream of spanish users. However, this is given
% for free and WITHOUT ANY WARRANTY. Under no circumstances can Julio
% Sanchez, GMV, Jos'e A. Ma~nas or any agents or representatives thereof 
% be held responsible for any errors in this software nor for any damages
% derived from its use, even in case any of the above has been notified
% of the possibility of such damages. If any such situation arises, you
% responsible for repair. Use of this software is an explicit
% acceptance of these conditions. 
% 
% You can use this software for any purpose. You cannot delete this
% copyright notice. If you change this software, you must include 
% comments explaining who, when and why. You are kindly requested to 
% send any changes to tex@gmv.es. If you change the generating 
% script, you must include code in it such that any output is clearly
% labeled as generated by a modified script.
%
% Despite the lack of warranty, we would like to hear about any
% problem you find. Please report problems to tex@gmv.es.
%
%               END OF COPYRIGHT NOTICE
%
% Options included in this set: basic isolatin1 ugly
% Open vowels: a e o ^^e1 ^^e9 ^^ed ^^f3 ^^fa
% Closed vowels: i u ^^fc
% Consonants: b c d f g j k l m n p q r s t v w x y z ^^f1
%
% Some of the patterns below represent combinations that never
% happen in Spanish. Would they happen, they would be hyphenated
% according to the rules.

% This keeps {cat|lc}code changes, if any, local. Nice to users of
% multilingual versions. These are the minimum changes needed to process
% the patterns. These and other changes will have to be re-enacted when
% Spanish be established as the current language. See the babel docs if
% you don't understand this.
\begingroup
\catcode`\^^e1=11 \lccode`\^^e1=`\^^e1    % 'a
\catcode`\^^e9=11 \lccode`\^^e9=`\^^e9    % 'e
\catcode`\^^ed=11 \lccode`\^^ed=`\^^ed    % 'i
\catcode`\^^f1=11 \lccode`\^^f1=`\^^f1    % 'o
\catcode`\^^f3=11 \lccode`\^^f3=`\^^f3    % ~n
\catcode`\^^fa=11 \lccode`\^^fa=`\^^fa    % 'u
\catcode`\^^fc=11 \lccode`\^^fc=`\^^fc    % "u
\patterns{
% Rule SR1
% Vowels are kept together by the defaults
% Rule SR2
% Attach vowel groups to left consonant
1ba 1be 1bo 1b^^e1 1b^^e9 1b^^ed 1b^^f3 1b^^fa 1bi 1bu 1b^^fc 
1ca 1ce 1co 1c^^e1 1c^^e9 1c^^ed 1c^^f3 1c^^fa 1ci 1cu 1c^^fc 
1da 1de 1do 1d^^e1 1d^^e9 1d^^ed 1d^^f3 1d^^fa 1di 1du 1d^^fc 
1fa 1fe 1fo 1f^^e1 1f^^e9 1f^^ed 1f^^f3 1f^^fa 1fi 1fu 1f^^fc 
1ga 1ge 1go 1g^^e1 1g^^e9 1g^^ed 1g^^f3 1g^^fa 1gi 1gu 1g^^fc 
1ja 1je 1jo 1j^^e1 1j^^e9 1j^^ed 1j^^f3 1j^^fa 1ji 1ju 1j^^fc 
1ka 1ke 1ko 1k^^e1 1k^^e9 1k^^ed 1k^^f3 1k^^fa 1ki 1ku 1k^^fc 
1la 1le 1lo 1l^^e1 1l^^e9 1l^^ed 1l^^f3 1l^^fa 1li 1lu 1l^^fc 
1ma 1me 1mo 1m^^e1 1m^^e9 1m^^ed 1m^^f3 1m^^fa 1mi 1mu 1m^^fc 
1na 1ne 1no 1n^^e1 1n^^e9 1n^^ed 1n^^f3 1n^^fa 1ni 1nu 1n^^fc 
1pa 1pe 1po 1p^^e1 1p^^e9 1p^^ed 1p^^f3 1p^^fa 1pi 1pu 1p^^fc 
1qa 1qe 1qo 1q^^e1 1q^^e9 1q^^ed 1q^^f3 1q^^fa 1qi 1qu 1q^^fc 
1ra 1re 1ro 1r^^e1 1r^^e9 1r^^ed 1r^^f3 1r^^fa 1ri 1ru 1r^^fc 
1sa 1se 1so 1s^^e1 1s^^e9 1s^^ed 1s^^f3 1s^^fa 1si 1su 1s^^fc 
1ta 1te 1to 1t^^e1 1t^^e9 1t^^ed 1t^^f3 1t^^fa 1ti 1tu 1t^^fc 
1va 1ve 1vo 1v^^e1 1v^^e9 1v^^ed 1v^^f3 1v^^fa 1vi 1vu 1v^^fc 
1wa 1we 1wo 1w^^e1 1w^^e9 1w^^ed 1w^^f3 1w^^fa 1wi 1wu 1w^^fc 
1xa 1xe 1xo 1x^^e1 1x^^e9 1x^^ed 1x^^f3 1x^^fa 1xi 1xu 1x^^fc 
1ya 1ye 1yo 1y^^e1 1y^^e9 1y^^ed 1y^^f3 1y^^fa 1yi 1yu 1y^^fc 
1za 1ze 1zo 1z^^e1 1z^^e9 1z^^ed 1z^^f3 1z^^fa 1zi 1zu 1z^^fc 
1^^f1a 1^^f1e 1^^f1o 1^^f1^^e1 1^^f1^^e9 1^^f1^^ed 1^^f1^^f3 1^^f1^^fa 1^^f1i 1^^f1u 1^^f1^^fc 
% Rule SR3
% Build legal consonant groups, leave other consonants bound to 
% the previous group. This overrides part of the SR2 pattern
% group.
1c2ha 1c2he 1c2ho 1c2h^^e1 1c2h^^e9 1c2h^^ed 1c2h^^f3 1c2h^^fa 1c2hi 1c2hu 1c2h^^fc 
1l2la 1l2le 1l2lo 1l2l^^e1 1l2l^^e9 1l2l^^ed 1l2l^^f3 1l2l^^fa 1l2li 1l2lu 1l2l^^fc 
1r2ra 1r2re 1r2ro 1r2r^^e1 1r2r^^e9 1r2r^^ed 1r2r^^f3 1r2r^^fa 1r2ri 1r2ru 1r2r^^fc 
1b2la 1b2le 1b2lo 1b2l^^e1 1b2l^^e9 1b2l^^ed 1b2l^^f3 1b2l^^fa 1b2li 1b2lu 1b2l^^fc 
1b2ra 1b2re 1b2ro 1b2r^^e1 1b2r^^e9 1b2r^^ed 1b2r^^f3 1b2r^^fa 1b2ri 1b2ru 1b2r^^fc 
1c2la 1c2le 1c2lo 1c2l^^e1 1c2l^^e9 1c2l^^ed 1c2l^^f3 1c2l^^fa 1c2li 1c2lu 1c2l^^fc 
1c2ra 1c2re 1c2ro 1c2r^^e1 1c2r^^e9 1c2r^^ed 1c2r^^f3 1c2r^^fa 1c2ri 1c2ru 1c2r^^fc 
1d2ra 1d2re 1d2ro 1d2r^^e1 1d2r^^e9 1d2r^^ed 1d2r^^f3 1d2r^^fa 1d2ri 1d2ru 1d2r^^fc 
1f2la 1f2le 1f2lo 1f2l^^e1 1f2l^^e9 1f2l^^ed 1f2l^^f3 1f2l^^fa 1f2li 1f2lu 1f2l^^fc 
1f2ra 1f2re 1f2ro 1f2r^^e1 1f2r^^e9 1f2r^^ed 1f2r^^f3 1f2r^^fa 1f2ri 1f2ru 1f2r^^fc 
1g2la 1g2le 1g2lo 1g2l^^e1 1g2l^^e9 1g2l^^ed 1g2l^^f3 1g2l^^fa 1g2li 1g2lu 1g2l^^fc 
1g2ra 1g2re 1g2ro 1g2r^^e1 1g2r^^e9 1g2r^^ed 1g2r^^f3 1g2r^^fa 1g2ri 1g2ru 1g2r^^fc 
1k2la 1k2le 1k2lo 1k2l^^e1 1k2l^^e9 1k2l^^ed 1k2l^^f3 1k2l^^fa 1k2li 1k2lu 1k2l^^fc 
1k2ra 1k2re 1k2ro 1k2r^^e1 1k2r^^e9 1k2r^^ed 1k2r^^f3 1k2r^^fa 1k2ri 1k2ru 1k2r^^fc 
1p2la 1p2le 1p2lo 1p2l^^e1 1p2l^^e9 1p2l^^ed 1p2l^^f3 1p2l^^fa 1p2li 1p2lu 1p2l^^fc 
1p2ra 1p2re 1p2ro 1p2r^^e1 1p2r^^e9 1p2r^^ed 1p2r^^f3 1p2r^^fa 1p2ri 1p2ru 1p2r^^fc 
1t2ra 1t2re 1t2ro 1t2r^^e1 1t2r^^e9 1t2r^^ed 1t2r^^f3 1t2r^^fa 1t2ri 1t2ru 1t2r^^fc 
% Rule SR4 is implicitly implemented by the default values
% Rule HE1 is implemented by TeX parameters \lefthyphenmin and
% \righthyphenmin. Help yourself. The correct values for
% Spanish are 2 and 2. If you set them below these values,
% incorrect breaks will happen.
% Rule HE2
% Break between a consonant and an h
b1h d1h f1h g1h j1h k1h l1h m1h n1h p1h q1h r1h s1h t1h v1h w1h x1h y1h z1h ^^f11h 
% We now avoid some problematic breaks.
su2b2r su2b2l
% These are included here to avoid ugly, though legal, breaks
% They were taken from the sphyphen.tex (silaba.tex) produced
% by Aurion Tecnologia and other sources.
2caca. 2cacas.
2caga. 2cagas.
2cago. 2cerdo
2cola. 2colas.
2culo. 2culos.
2cular.
2loco. 2locos. 2loca. 2locas.
2moco. 2mocos.
2mula. 2mulas.
2pedo. 2pedos. 2peda. 2pedas.
2pito. 2pitos.
2puto. 2putos. 2puta. 2putas.
.caca2
}
\endgroup
\endinput
