/*
    parted - a frontend to libparted
    Copyright (C) 1999  Andrew Clausen, Lennert Buytenhek and Red Hat, Inc.

    Andrew Clausen		<clausen@gnu.org>
    Lennert Buytenhek		<buytenh@gnu.org>
    Matt Wilson, Red Hat Inc.	<msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef COMMAND_H_INCLUDED
#define COMMAND_H_INCLUDED

#include <parted/parted.h>
#include "strlist.h"

typedef struct {
	StrList*	names;
	int		(*method) (PedDevice* dev);
	StrList*	summary;
	StrList*	help;
} Command;

extern Command* command_create (const StrList* names,
				int (*method) (PedDevice* dev),
				const StrList* summary,
				const StrList* help);
extern void command_destroy (Command* cmd);
void command_register (Command** list, Command* cmd);

extern Command* command_get (Command** list, char* name);
extern void command_print_summary (Command* cmd);
extern void command_print_help (Command* cmd);
extern int command_run (Command* cmd, PedDevice* dev);

#endif /* COMMAND_H_INCLUDED */

