/*
 *     stdio.h    iBCS compatable header
 */

#ifndef	_STDIO_H_
#define	_STDIO_H_

typedef long            fpos_t;

#ifndef _LINUX_STDDEF_H   /* Fetch the definitions for NULL */
#include <stddef.h>
#endif

#define BUFSIZ          1024
#define _NFILE          60

#define EOF             (-1)

#define FOPEN_MAX       _NFILE

#define L_ctermid       9
#define L_cuserid       9
#define P_tmpdir        "/usr/tmp/"
#define L_tmpnam        (sizeof(P_tmpdir)+15)

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

#ifndef _STDARG_H
#include <stdarg.h>
#endif

#define  SEEK_CUR 1
#define  SEEK_END 2
#define  SEEK_SET 0
#define  TMP_MAX  32767
#define FILENAME_MAX 1024

/* define file control block */

/* Note - _cnt and _ptr are reversed on some systems - apparently
   pdp-11 and u370 from the comments in the SVr4 stdio.h.  As far as
   I can tell, we never will need reversal, but just in case I left
   something in for this */

typedef struct _iobuf
    {
#ifdef _STDIO_REVERSE
    unsigned char *_ptr;
    int            _cnt;
#else
    int            _cnt;
    unsigned char *_ptr;
#endif
    unsigned char *_base;
    unsigned char  _flag;
    unsigned char  _file;
    } FILE;

#define  fpos_t  long   /* file position variable */

#ifdef ELF_LIBRARY
/* This is what is used under SVr4. */
#define _iob __iob
#define _xxflsbuf __flsbuf
#define _filbuf  __filbuf
/* We define these so that the library correcly uses the strong
   symbols instead of the weak ones */
#define access _access
#define open _open
#define close _close
#define lseek _lseek
#define read _read
#define write _write
#define isatty _isatty
#define unlink _unlink
#endif

#ifdef COFF_LIBRARY
#define _iob	_libc__iob
#define _xxflsbuf	_flsbuf
extern FILE *	_iob;
#else
extern   FILE   _iob[_NFILE];
#endif


#define  stdin  (&_iob[0])
#define  stdout (&_iob[1])
#define  stderr (&_iob[2])

#define  _IOREAD    0x01
#define  _IOWRT     0x02

#define  _IOFBF     0x00
#define  _IOLBF     0x40
#define  _IONBF     0x04

#define  _IOFREEBF  0x08
#define  _IOEOF     0x10
#define  _IOERR     0x20
#define  _IORW      0x80

#define	SEEK_SET	0	/* set file offset to offset */
#define	SEEK_CUR	1	/* set file offset to current plus offset */
#define	SEEK_END	2	/* set file offset to EOF plus offset */

/*
 * Macros for functions which simply change indicators in the file table
 */

#define __scerror(fp)   ((fp)->_flag &= ~(_IOERR | _IOEOF))
#define _clearerr(fp)     __scerror(fp)

#define __sfeof(fp)     ((fp)->_flag & _IOEOF)
#define feof(fp)        __sfeof(fp)

#define __sferror(fp)   ((fp)->_flag & _IOERR)
#define ferror(fp)      __sferror(fp)

#define __sfileno(fp)   ((int) (fp)->_file)
#define fileno(fp)      __sfileno(fp)

#define	getchar()	getc(stdin)
#define	putchar(x)	putc((x), stdout)

#define __sputc(x,f)    (--(f)->_cnt >= 0 ? 0xff & (*(f)->_ptr++ = (char)(x)) \
                        :  _xxflsbuf((x),(f)))
#define putc(x,fd)      __sputc(x,fd)

#define __sgetc(fd) (--(fd)->_cnt >= 0 ? 0xff & *(fd)->_ptr++ : _filbuf(fd))
#define getc(fd)     __sgetc(fd)

#ifdef ELF_LIBRARY
#define sys_nerr _sys_num_err
#define sys_errlist _sys_errlist
#endif

extern int sys_nerr;			/* perror(3) external variables */
extern char *sys_errlist[];

/* function prototypes */

int _filbuf(FILE *);
int _flsbuf(int, FILE *);
int fclose(FILE *);
int fcloseall(void);
FILE *fdopen (int filedes, const char *mode);
int fflush(FILE *);
int fgetc(FILE *);
int fgetchar(void);
int fgetpos(FILE *, fpos_t *);
char *fgets (char *string, size_t count, FILE *stream);
int flushall(void);
FILE *fopen (const char *file, const char *mode);
int fprintf(FILE *, const char *, ...);
int fputc(int, FILE *);
int fputchar(int);
int fputs(const char *, FILE *);
size_t fread(void *, size_t, size_t, FILE *);
FILE *freopen(const char *, const char *, FILE *);
int fscanf(FILE *, const char *, ...);
int fsetpos(FILE *, const fpos_t *);
int fseek(FILE *, long, int);
long ftell(FILE *);
size_t fwrite(const void *, size_t, size_t, FILE *);
char *gets(char *);
int getw(FILE *);
void perror(const char *);
int printf(const char *, ...);
int puts(const char *);
int putw(int, FILE *);
int remove(const char *);
int rename(const char *, const char *);
int rewind(FILE *);
int rmtmp(void);
int scanf(const char *, ...);
void setbuf (FILE *stream, void *pvBuffer);
int setvbuf (FILE *stream, void *pvBuffer, int nType, size_t size);
int sprintf(char *, const char *, ...);
int sscanf(const char *, const char *, ...);
char *tempnam (const char *pszDirectory, const char *pszPrefix);
FILE *tmpfile(void);
char *tmpnam(char *);
int ungetc (int nChar, FILE *stream);
int unlink(const char *);
int vfprintf(FILE *, const char *, va_list);
int vprintf(const char *, va_list);
int vsprintf(char *, const char *, va_list);

#endif /* _STDIO_H_ */

