/* Copyright (C) 1991, 1992 Free Software Foundation, Inc.
This file is part of the GNU C Library.

The GNU C Library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public License as
published by the Free Software Foundation; either version 2 of the
License, or (at your option) any later version.

The GNU C Library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with the GNU C Library; see the file COPYING.LIB.  If
not, write to the Free Software Foundation, Inc., 675 Mass Ave,
Cambridge, MA 02139, USA.  */

#include <ibcs/unistd.h>

#ifndef NO_UNDERSCORE
#define ERRNO _errno
#else
#define ERRNO errno
#endif

	.text
	.globl	_pipe
	.align	4
/*
 * Open up a pipe.
 */
_pipe:
	pushl %ebx
	pushl %edx

	movl	$ __IBCS_pipe , %eax
	.byte	0x9a, 0, 0, 0, 0, 7, 0
/*
 * The file descriptors are in %eax and %edx.
 */
	jnc	.Lexit
/* An error was encountered.  Clean up and return. */
#ifdef PIC
	call .L2
.L2:
	popl %ebx
	addl $_GLOBAL_OFFSET_TABLE_+[.-.L2],%ebx
	movl ERRNO@GOT(%ebx),%ebx
	movl %eax,(%ebx)
#else
	movl %eax,ERRNO
#endif
	movl $-1,%eax
	jmp  .Ldone
	
.Lexit:
	movl 12(%esp), %ebx
	movl %eax,(%ebx)
	movl %edx,4(%ebx)
	movl $0,%eax
.Ldone:
	popl %edx
	popl %ebx
	ret


#ifdef ELF_LIBRARY
	.type _pipe,@function
	.weak pipe
	pipe = _pipe
#endif
