# Note that this is NOT a relocatable package
%define ver      0.5.1
%define rel      3
%define prefix   /usr

Summary: gEdit is a small but powerful text editor for GNOME.
Name:      gedit
Version:   %ver
Release:   %rel
Copyright: GPL
Group: Applications/Editors
Source0:   gedit-%{PACKAGE_VERSION}.tar.gz
URL:       http://gedit.pn.org/
BuildRoot: /var/tmp/gedit-%{PACKAGE_VERSION}-root
Docdir: %{prefix}/doc

%description
gEdit is a small but powerful text editor designed expressly
for GNOME.

It includes such features as split-screen mode, a plugin
API, which allows gEdit to be extended to support many
features while remaining small at its core, multiple
document editing through the use of a 'tabbed' notebook and
many more functions.

GNOME is required to use gEdit (Gnome-Libs and Gtk+).

%package devel
Summary: Develop plugins for the gEdit editor.
Group: Development/Libraries

%description devel
gEdit is a small but powerful text editor for GTK+ and/or GNOME.
This package allows you to develop plugins that work within
gEdit.  Plugins can create new documents and manipulate documents
in arbitrary ways.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix=%{prefix} 
make

%install
rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-, root, root)

%doc README COPYING ChangeLog NEWS TODO AUTHORS INSTALL THANKS
%{prefix}/bin/gedit
%{prefix}/share/locale/*/*/*
%{prefix}/share/apps/*/*
%{prefix}/share/pixmaps/*
%{prefix}/share/mime-info/*
%{prefix}/share/geditrc
%{prefix}/man/*/*
%{prefix}/libexec/*/*/*


%files devel
%defattr(-, root, root)
%{prefix}/include/*/*
%{prefix}/lib/*

%changelog
* Sat Feb 06 1999 Michael Johnson <johnsonm@redhat.com>
- Cleaned up a bit for Red Hat use

* Thu Oct 22 1998 Alex Roberts <bse@dial.pipex.com>
- First try at an RPM
