/*****************************************************************************/
/*  delete_dialog.c - the delete dialog                                      */
/*  Copyright (C) 1998-1999 Brian Masney <masneyb@seul.org>                  */
/*                                                                           */
/*  This program is free software; you can redistribute it and/or modify     */
/*  it under the terms of the GNU General Public License as published by     */
/*  the Free Software Foundation; either version 2 of the License, or        */
/*  (at your option) any later version.                                      */
/*                                                                           */
/*  This program is distributed in the hope that it will be useful,          */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of           */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            */
/*  GNU General Public License for more details.                             */
/*                                                                           */
/*  You should have received a copy of the GNU General Public License        */
/*  along with this program; if not, write to the Free Software              */
/*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA      */
/*****************************************************************************/

#include "ftp.h"

static void askdel (void);
static void yesCB (GtkWidget *widget, gpointer data);

static struct ftp_window_data *wdata;

void delete_dialog (gpointer data) {
   wdata = (struct ftp_window_data *) data;
   if (!check_status (_("Delete"), wdata, 0, 1, 1)) return;

   if (confirm_delete) askdel ();
   else yesCB (NULL, NULL);
}
/*****************************************************************************/
static void askdel (void) {
   char *tempstr;

   tempstr = g_strdup_printf (_("Are you sure you want to delete these %d items"), wdata->numselected);
   MakeYesNoDialog (_("Delete Files/Directories"), tempstr, 1, 2,
   	_("Yes"), yesCB, NULL,
   	_("No"), NULL, NULL);
   g_free (tempstr);
}
/*****************************************************************************/
static void yesCB (GtkWidget *widget, gpointer data) {
   struct ftp_file_data *tempfle;
   GList *templist, *dellist;
   int success, num, reload;
   char *description;
   
   num = -1;
   reload = 0;
   templist = wdata->hdata->files;
   while (templist != NULL) {
      while (templist != NULL) {
         tempfle = (struct ftp_file_data *) templist->data;
         if (tempfle->shown) {
            num++;
            if (tempfle->selected) break;
         }
         templist = templist->next;
      }
      if (templist == NULL) break;
         
      if (wdata->local == 1) {
         if (tempfle->attribs[0] == 'd') success = rmdir (tempfle->file) == 0;
         else success = unlink (tempfle->file) == 0;
         if (!success) {
            if (tempfle->attribs[0] == 'd') {
               ftp_log (gftp_logging_error, NULL, _("Error: Could not remove directory %s: %s\n"), tempfle->file, g_strerror (errno));
            }
            else {
               ftp_log (gftp_logging_error, NULL, _("Error: Could not remove file %s: %s\n"), tempfle->file, g_strerror (errno));
            }
         }
         else {
            ftp_log (gftp_logging_misc, NULL, _("Successfully removed %s\n"), tempfle->file);
         }
      }
      else {
         success = 1;
         if (wdata->local == 2) {
            reload = 1;
            if (!ftp_connect (wdata->hdata, 0)) success = 0;
            wdata->hdata->getdir = 1;
         }
         if (success) {
            if (tempfle->attribs[0] == 'd') success = gftp_remove_directory (wdata->hdata->ftpdata, tempfle->file) == 0;
            else success = gftp_remove_file (wdata->hdata->ftpdata, tempfle->file) == 0;
         }
      }
      if (success) {
         description = g_strdup_printf ("%s://%s:%s@%s:%d%s", 
         	GFTP_GET_URL_PREFIX (wdata->hdata->ftpdata),
         	GFTP_GET_USERNAME (wdata->hdata->ftpdata), GFTP_GET_PASSWORD (wdata->hdata->ftpdata),
         	GFTP_GET_HOSTNAME (wdata->hdata->ftpdata), 
         	GFTP_GET_PORT (wdata->hdata->ftpdata) == 0 ? 21 : GFTP_GET_PORT (wdata->hdata->ftpdata),
         	GFTP_GET_DIRECTORY (wdata->hdata->ftpdata) == NULL ? "" : GFTP_GET_DIRECTORY (wdata->hdata->ftpdata));
         remove_double_slashes (description+6);
         delete_cache_entry (description);
         g_free (description);
         
         gtk_clist_remove (GTK_CLIST (wdata->listbox), num);
         num--;
         dellist = templist;
         dellist->data = NULL;
         templist = templist->next;
         wdata->hdata->files = g_list_remove_link (wdata->hdata->files, dellist);
         free_fdata (tempfle);
         wdata->hdata->totalfiles--;
      }
      else templist = templist->next;
   }
   if (reload) refresh (wdata);
}
/*****************************************************************************/
