/***********************************
 Common structs and values
 (c) 1999 Jeremy Wise
 GnomeICU
************************************/

#ifndef __COMMON_H__
#define __COMMON_H__

/*** GnomeICU header files ***/
#include "../config.h"
#include "datatype.h"
#include "filexfer.h"

/*** Toplevel header files ***/
#include <stdlib.h>
#include <stdio.h>
#include <gnome.h>

typedef struct
{
	gchar *name;
	GSList *members;
} icu_group;

#if 0
typedef struct
{
	GtkWidget *dlg;
	GtkWidget *msg;
	GtkWidget *file;
	UIN_T uin;
} file_request_info;
#endif

struct sokandlb
{
	int sok;
	GtkWidget *notebook;
	GtkWidget *lb_userwin;
	GtkWidget *lb_userwin_online;
	GtkWidget *lb_userwin_offline;
	GtkWidget *lb_userwin_notinlist;
	GtkWidget *head_online;
	GtkWidget *head_offline;
	GtkWidget *head_notinlist;
	GtkWidget *not_contents;
	GtkWidget *window;
};

struct URLInfo
{
	GtkWidget *url;
	GtkWidget *desc;
	GSList *contact;
};

typedef struct
{
	gboolean auto_popup;
	gboolean full_reply;
	gboolean applet;
	gboolean autohide;
	gboolean beep;
	gboolean force;
	gboolean packet_udp;
	gboolean packet_tcp;
	gboolean sound;
	gboolean webpresence;
	gboolean animate;
	gboolean show_window;
	gboolean russian;
	gboolean no_new_users;
   	gboolean hidetooltip;
	gboolean program_on_receive_message;
	gboolean program_on_chat_request;
	gboolean program_on_receive_url;
	gboolean program_on_file_request;
	gboolean program_on_user_online;
	gboolean program_on_user_offline;
	gboolean program_on_auth;
	gboolean program_on_auth_request;
	gboolean program_on_list_add;
	gboolean program_on_contact_list;
} _toggles;

typedef struct 
{
	gchar *receive_message;
	gchar *chat_request;
	gchar *receive_url;
	gchar *file_request;
	gchar *user_online;
	gchar *user_offline;
	gchar *auth;
	gchar *auth_request;
	gchar *list_add;
	gchar *contact_list;
} _programs;

#define AUTO_AWAY 10 /* Turn to away mode after 10 minutes */
#define AUTO_NA   20 /* Turn to n/a mode after 20 minutes */

#define NOT_SPECIFIED 0
#define FEMALE 1
#define MALE 2

#define CMD_OFFSET 14
#define SEQ_OFFSET 16
#define SEQ2_OFFSET 18

#define ICQ_VER 0x0005

#define STDIN 0
#define STDOUT 1
#define STDERR 2

#define PACKET_TYPE_TCP          1
#define PACKET_TYPE_UDP          2

#define PACKET_DIRECTION_SEND    4
#define PACKET_DIRECTION_RECEIVE 8

#define MAX_UDP_MESSAGE_LENGTH 450

#define UPDATE_ONLINE  1<<0
#define UPDATE_OFFLINE 1<<1
#define UPDATE_NOTLIST 1<<2

#define USE_AUTOAWAY


typedef struct _ProgressData
{
	GtkWidget *pbar;
	int timer;
} ProgressData;

typedef struct
{
	BYTE dummy[2]; /* to fix alignment problem */
	BYTE ver[2];
	BYTE zero[4];
	BYTE UIN[4];
	BYTE session[4];
	BYTE cmd[2];
	BYTE seq2[2];
	BYTE seq[2];
	BYTE checkcode[4];
} ICQ_pak, *ICQ_PAK_PTR;

typedef struct
{
	BYTE dummy[2]; /* to fix alignment problem */
	BYTE ver[2];
	BYTE zero;
	BYTE session[4];
	BYTE cmd[2];
	BYTE seq[2];
	BYTE seq2[2];
	BYTE UIN[4];
	BYTE check[4];
} SRV_ICQ_pak, *SRV_ICQ_PAK_PTR;

typedef struct
{
	ICQ_pak head;
	BYTE data[1024];
} net_icq_pak, *NET_ICQ_PTR;

typedef struct
{
	SRV_ICQ_pak head;
	BYTE data[1024];
} srv_net_icq_pak, *SRV_NET_ICQ_PTR;

#define CMD_ACK                0x000A 
#define CMD_SENDM              0x010e
#define CMD_LOGIN              0x03e8
#define CMD_CONT_LIST          0x0406
#define CMD_SEARCH_UIN         0x041a
#define CMD_SEARCH_USER        0x0424
#define CMD_KEEP_ALIVE         0x042e
#define CMD_KEEP_ALIVE2        0x051e
#define CMD_SEND_TEXT_CODE     0x0438
#define CMD_LOGIN_1            0x044c
#define CMD_INFO_REQ           0x0460
#define CMD_EXT_INFO_REQ       0x046a
#define CMD_CHANGE_PW          0x049c
#define CMD_STATUS_CHANGE      0x04d8
#define CMD_LOGIN_2            0x0528
#define CMD_UPDATE_INFO        0x050a
#define CMD_UPDATE_EXT_INFO    0x04b0
#define CMD_ADD_TO_LIST        0x053c
#define CMD_REQ_ADD_LIST       0x0456
#define CMD_QUERY_SERVERS      0x04ba
#define CMD_QUERY_ADDONS       0x04c4
#define CMD_NEW_USER_1         0x04eC
#define CMD_NEW_USER_REG       0x03fC
#define CMD_NEW_USER_INFO      0x04a6
#define CMD_ACK_MESSAGES       0x0442
#define CMD_MSG_TO_NEW_USER    0x0456
#define CMD_REG_NEW_USER       0x03fc
#define CMD_VIS_LIST           0x06ae
#define CMD_INVIS_LIST         0x06a4
#define CMD_META_USER          0x064a
#define CMD_RAND_SEARCH        0x056e
#define CMD_RAND_SET           0x0564
#define CMD_AUTH_UPDATE        0x0514
#define CMD_REVERSE_TCP_CONN   0x015e

#define CMD_WEBPRESENCE_1      0x064a
#define CMD_WEBPRESENCE_2      0x04d8

#define SRV_ACK                0x000a
#define SRV_LOGIN_REPLY        0x005a
#define SRV_USER_ONLINE        0x006e
#define SRV_USER_OFFLINE       0x0078
#define SRV_USER_FOUND         0x008c
#define SRV_RECV_MESSAGE       0x00dc
#define SRV_END_OF_SEARCH      0x00a0
#define SRV_INFO_REPLY         0x0118
#define SRV_EXT_INFO_REPLY     0x0122
#define SRV_STATUS_UPDATE      0x01a4
#define SRV_X1                 0x021c
#define SRV_X2                 0x00e6
#define SRV_UPDATE             0x01e0
#define SRV_UPDATE_EXT         0x00c8
#define SRV_NEW_UIN            0x0046
#define SRV_NEW_USER           0x00b4
#define SRV_QUERY              0x0082
#define SRV_SYSTEM_MESSAGE     0x01c2
#define SRV_SYS_DELIVERED_MESS 0x0104
#define SRV_GO_AWAY            0x00f0
#define SRV_TRY_AGAIN          0x00fa
#define SRV_FORCE_DISCONNECT   0x0028
#define SRV_MULTI_PACKET       0x0212
#define SRV_WEBPRESENCE_ACK    0x03de
#define SRV_BAD_PASSWORD       0x0064
#define SRV_META_USER          0x03de
#define SRV_RAND_USER          0x024e
#define SRV_AUTH_UPDATE        0x01f4

#define META_INFO_SET          0x03e8
#define META_INFO_REQ          0x04b0
#define META_INFO_SECURE       0x0424
#define META_INFO_PASS         0x042e
#define META_INFO_HOMEPAGE	    0x03fc
#define META_INFO_ABOUT		    0x0406
#define META_SRV_GEN           0x00c8
#define META_SRV_MORE          0x00dc
#define META_SRV_WORK          0x00d2
#define META_SRV_ABOUT         0x00e6
#define META_SRV_PASS          0x00aa

#define STATUS_OFFLINE         0xffffffff
#define STATUS_ONLINE          0x00
#define STATUS_INVISIBLE       0x100
#define STATUS_NA_99A          0x04
#define STATUS_NA              0x05
#define STATUS_FREE_CHAT       0x20
#define STATUS_OCCUPIED_MAC    0x10
#define STATUS_OCCUPIED        0x11
#define STATUS_AWAY            0x01
#define STATUS_DND             0x13

#define USER_ADDED_MESS        0x000c
#define AUTH_REQ_MESS          0x0006
#define URL_MESS               0x0004
#define MASS_MESS_MASK         0x8000
#define MRURL_MESS             0x8004
#define NORM_MESS              0x0001
#define MRNORM_MESS            0x8001
#define CONTACT_MESS           0x0013
#define MRCONTACT_MESS         0x8013
#define AUTH_MESS              0x0008

typedef struct
{
	BYTE time[4];
	BYTE port[4];
	BYTE len[2];
} login_1, *LOGIN_1_PTR;

typedef struct
{
	BYTE X1[4];
	BYTE ip[4];
	BYTE X2[1];
	BYTE status[4];
	BYTE X3[4];
	BYTE X4[4];
	BYTE X5[4];
	BYTE X6[4];
	BYTE X7[4];
	BYTE X8[4];
} login_2, *LOGIN_2_PTR;

/* those behind the // are for the spec on
http://www.student.nada.kth.se/~d95-mih/icq/
they didn't work for me so I changed them
to values that did work.
*********************************/
#define LOGIN_X1_DEF 0x00000098
#define LOGIN_X2_DEF 0x04
#define LOGIN_X3_DEF 0x00000003
#define LOGIN_X4_DEF 0x00000000
#define LOGIN_X5_DEF 0x00980010
#define LOGIN_X6_DEF 0x00000050
#define LOGIN_X7_DEF 0x00000003
#define LOGIN_X8_DEF 0x00000000
            
typedef struct
{
	BYTE uin[4];
	BYTE year[2];
	BYTE month;
	BYTE day;
	BYTE hour;
	BYTE minute;
	BYTE type[2];
	BYTE len[2];
} RECV_MESSAGE, *RECV_MESSAGE_PTR;

typedef struct
{
	BYTE uin[4];
	BYTE type[2]; 
	BYTE len[2];
} SIMPLE_MESSAGE, *SIMPLE_MESSAGE_PTR;

typedef struct
{
	UIN_T uin;       /*General*/
	gchar *nick;     /*General*/
	gchar *alias;    /*General*/
	gchar *first;    /*General*/
	gchar *last;     /*General*/
	gboolean sex;    /*General*/
	gint age;        /*General*/
	gboolean auth;   /*General*/
	gchar *ip;       /*Internet*/
	gchar *port;     /*Internet*/
	gchar *status;   /*Internet*/
	gchar *email;    /*Internet*/
	gchar *email2;   /*Internet*/
	gchar *email3;   /*Internet*/
	gchar *phone;    /*Location*/
	gchar *fax;      /*Location*/
	gchar *cellular; /*Location*/
	gchar *street;   /*Location*/
	gchar *city;     /*Location*/
	gchar *state;    /*Location*/
	gint birth_year; /****************************/
	gint birth_month;/****************************/
	gint birth_day;  /****************************/
	DWORD zip;       /*Location*/
	WORD country;    /*Location*/
	gint c_status;
	gchar *homepage; /*About*/
	gboolean hide_email;/*************************/
	gchar *about;    /*About*/
	gchar *job_pos;      /*Work*/
	gchar *department;   /*Work*/
	gchar *company_name; /*Work*/
	gchar *work_address; /*Work*/
	gchar *work_city;    /*Work*/
	gchar *work_state;   /*Work*/
	gchar *work_phone;   /*Work*/
	gchar *work_fax;     /*Work*/
	gchar *work_homepage;/*Work*/

	GtkWidget *window;

	GtkWidget *w_uin;
	GtkWidget *w_nick;
	GtkWidget *w_alias;
	GtkWidget *w_first;
	GtkWidget *w_last;
	GtkWidget *w_sex;
	GtkWidget *w_age;
	GtkWidget *w_auth;
	GtkWidget *w_birth_year;
	GtkWidget *w_birth_month;
	GtkWidget *w_birth_day;

	GtkWidget *w_ip;
	GtkWidget *w_port;
	GtkWidget *w_status;
	GtkWidget *w_email;
	GtkWidget *w_email2;
	GtkWidget *w_email3;
	GtkWidget *w_hide_email;

	GtkWidget *w_phone;
	GtkWidget *w_fax;
	GtkWidget *w_cellular;
	GtkWidget *w_street;
	GtkWidget *w_city;
	GtkWidget *w_state;
	GtkWidget *w_zip;
	GtkWidget *w_country;
	GtkWidget *w_c_status;

	GtkWidget *w_homepage;
	GtkWidget *w_about;

	GtkWidget *w_work_city;
	GtkWidget *w_work_state;
	GtkWidget *w_work_phone;
	GtkWidget *w_work_fax;
	GtkWidget *w_work_address;
	GtkWidget *w_work_homepage;
	GtkWidget *w_company_name;
	GtkWidget *w_department;
	GtkWidget *w_job_pos;
} USER_INFO_STRUCT, *USER_INFO_PTR;

typedef enum
{
	MESSAGE_TEXT,        /* Normal text message */
	MESSAGE_URL,         /* URL message */
	MESSAGE_FILE_REQ,    /* Request to send you a file */
	MESSAGE_CHAT_REQ,    /* Request to start a chat */
	MESSAGE_AUTH_REQ,    /* Request for authorization */
	MESSAGE_USER_ADD,    /* User has added you to his/her list */
	MESSAGE_USER_AUTHD,  /* User has authorized you to add him/her */
	MESSAGE_CONT_LIST   /* Contact list message */
} MESSAGE_TYPES;

typedef struct
{
	MESSAGE_TYPES type;
	gchar *message;
} stored_message, *STORED_MESSAGE_PTR;

typedef struct
{
	UIN_T uin;
	DWORD status;
	DWORD last_status;
	DWORD true_status;
	DWORD lb_index;
	DWORD last_time; /* last time online or when came online */
	DWORD current_ip;
	DWORD port;
	guint chat_away;
	GdkFont *chat_font;
	char *chat_reason;
	GSList *chat_history;
	int tcp_gdk_input;
	int chat_gdk_input;
	int file_gdk_input;
	gboolean file_sending;
	FILE *chat_file;
	GtkWidget *chat_local_text;
	GtkWidget *chat_remote_text;
	SOK_T sok;
	SOK_T chat_sok;
	SOK_T file_sok;
	GtkWidget *chat_window;
	BYTE chat_active;
	BYTE chat_active2;
	DWORD chat_seq;
	DWORD file_seq;
	char *file_name;
	char *file_short_name;
	int file_fd;
	int file_offset;
	int file_size;
	int chat_port;
	int file_port;
	BYTE chat_fg_red, chat_fg_green, chat_fg_blue;
	BYTE chat_bg_red, chat_bg_green, chat_bg_blue;
	BYTE nick[20];
	GtkWidget *list_item;
	GdkPixmap *icon_p;
	GdkBitmap *icon_b;
	WORD messages;
	BYTE **message;
	GSList *stored_messages;
	gboolean invis_list;
	gboolean vis_list;
	gboolean ignore_list;
	guchar force;
	gboolean force_override;
	GtkWidget *read_next;
	int wait;
	ProgressData *pdata;
	int need_update;
	int gdk_input_tag;
	filexferdlg *file_info;
	gboolean show_again;
	USER_INFO_PTR info;
	char *oneline_in;
	char *oneline_out;
	int online_notify;
	int info_seq;
	GSList *tcp_msg_queue;
	GSList *tcp_text_queue;
	int tcp_timeout;
	gboolean have_tcp_connection;
	WORD tcp_buf_len;
	BYTE *tcp_buf;
	WORD tcp_buf_read;
	GIOChannel *gioc;
	guint giocw;
	gboolean have_chat_focus;
	gboolean reported_chat_focus;  /* Focus reported to other user. */
	GtkWidget *should_send_focus;  /* GtkCheckMenuItem */
	gboolean info_was_requested;
	gboolean inlist;
} Contact_Member, *CONTACT_PTR;

typedef struct
{
	char *nick;
	char *first;
	char *last;
	char *email;
	char *email2;
	char *email3;
	char *city;
	char *state;
	char *phone;
	char *fax;
	char *street;
	char *cellular;
	DWORD zip;
	WORD country;
	gint c_status;
	gboolean hide_email;
} MORE_INFO_STRUCT, *MORE_INFO_PTR;

enum {
	TARGET_STRING
};

extern GtkTargetEntry target_table[];

/*** Individual GnomeICU Headers ***/
#include "applet.h"
#include "autoaway.h"
#include "autohide.h"
#include "changeaway.h"
#include "changeinfo.h"
#include "changenick.h"
#include "chat.h"
#include "chatdlg.h"
#include "dialog.h"
#include "dragdrop.h"
#include "events.h"
#include "filexfer.h"
#include "flash.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkconf.h"
#include "histadd.h"
#include "icuchat.h"
#include "icu_db.h"
#include "ignore.h"
#include "invisible.h"
#include "loadpixmap.h"
#include "log.h"
#include "msg_queue.h"
#include "newsignup.h"
#include "notify.h"
#include "packetprint.h"
#include "pixmaps.h"
#include "response.h"
#include "rus_conv.h"
#include "search.h"
#include "sendcontact.h"
#include "sendmsg.h"
#include "server.h"
#include "showlist.h"
#include "tcp.h"
#include "userserver.h"
#include "util.h"
#include "visible.h"
#include "webpresence.h"
#include "awaymsglist.h"
#include "rus_conv.h"

#endif /* __COMMON_H__ */
