/*******************************   
 Handling of ICQ (sound) events   
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/
   
#ifndef __ICQ_EVENTS_H__
#define  __ICQ_EVENTS_H__

#include "common.h"

typedef enum 
{
  EV_MSGRECV,   /* Message received */
  EV_USERON,    /* User logon */
  EV_USEROFF,   /* User logoff */
  EV_CHATREQ,   /* Chat request received */
  EV_CHATBEEP,  /* Chat beep */
  EV_URLRECV,   /* URL received */
  EV_AUTHREQ,   /* Request for authorization received */
  EV_AUTH,      /* Authorize notification */
  EV_FILEREQ,   /* Incoming file */
  EV_LISTADD,   /* Added to list */
  EV_CONTLIST   /* Received Contact List */
} ICQEvType;

void gnomeicu_event( ICQEvType event, UIN_T uin );
void gnomeicu_fire_external_program( ICQEvType event, CONTACT_PTR contact );

#endif /* __ICQ_EVENTS_H__ */
